/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.io.BufferSequence;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.Member$SentQueue;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.PacketBundle;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.packet.DiagnosticPacket;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$AckQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ConfirmationQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$InQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$OutgoingMessageArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ResendQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue;
import com.tangosol.internal.util.MessagePublisher;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.internal.PacketComparator;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.util.Base;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PacketPublisher
extends PacketProcessor
implements MessagePublisher {
    private int __m_AckDelay;
    private PacketPublisher$AckQueue __m_AckQueue;
    private transient List __m_AckdPacketListTemp;
    private Set __m_BroadcastAddresses;
    private int __m_CloggedCount;
    private int __m_CloggedDelay;
    private transient ByteBuffer __m_ClusterNameBuffer;
    private PacketPublisher$ConfirmationQueue __m_ConfirmationQueue;
    private Queue __m_DeferredReadyQueue;
    private long __m_FromMessageId;
    private transient Queue[] __m_IncomingPacketQueues;
    private volatile long __m_LastTrafficJamWarningTimeMillis;
    private transient List __m_LostPacketListTemp;
    private int __m_MaximumPacketLength;
    private transient MultiBufferWriteBuffer.WriteBufferPool __m_MessageBufferAllocator;
    private WindowedArray __m_MessageOutgoing;
    private transient Message[] __m_MsgArrayTemp;
    private transient long[] __m_MsgIdArrayTemp;
    private InetSocketAddress __m_MulticastAddress;
    private transient int __m_MulticastBypassCount;
    private boolean __m_MulticastEnabled;
    private double __m_MulticastThreshold;
    private transient long __m_NackDelayMillis;
    private transient boolean __m_NackEnabled;
    private transient Queue __m_PacketAdapterQueue;
    private int __m_PreferredPacketLength;
    private int __m_ResendDelay;
    private PacketPublisher$ResendQueue __m_ResendQueue;
    private int __m_ResendTimeout;
    private transient Queue __m_SendQueue;
    private transient SingleMemberSet __m_SingleMemberSetTemp;
    private transient long __m_StatsCpu;
    private transient long __m_StatsNacksSent;
    private transient long __m_StatsResent;
    private transient long __m_StatsResentEarly;
    private transient long __m_StatsResentExcess;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private UdpSocket __m_UdpSocketMulticast;
    private UnicastUdpSocket __m_UdpSocketUnicast;

    public PacketPublisher() {
        this(null, null, true);
    }

    public PacketPublisher(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAckdPacketListTemp(new RecyclingLinkedList());
            this.setCloggedCount(1024);
            this.setCloggedDelay(32);
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLostPacketListTemp(new RecyclingLinkedList());
            this.setMulticastEnabled(true);
            this.setMulticastThreshold(0.25);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setSingleMemberSetTemp(new SingleMemberSet());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new PacketPublisher$AckQueue("AckQueue", this, true), "AckQueue");
        this._addChild(new PacketPublisher$ConfirmationQueue("ConfirmationQueue", this, true), "ConfirmationQueue");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new PacketPublisher$InQueue("InQueue", this, true), "InQueue");
        this._addChild(new PacketPublisher$OutgoingMessageArray("OutgoingMessageArray", this, true), "OutgoingMessageArray");
        this._addChild(new PacketPublisher$ResendQueue("ResendQueue", this, true), "ResendQueue");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addressMany(PacketBundle bundle) {
        Packet packet = bundle.getPacket(0);
        if (packet instanceof MessagePacket) {
            DependentMemberSet setTo = ((MessagePacket)packet).getToMemberSet();
            if (!(setTo != null) ? false : packet.isConfirmationRequired()) {
                int[] anToId = setTo.toIdArray();
                int cAddrs = anToId.length;
                boolean fMulticast = false;
                if (!this.isMulticastEnabled() ? false : this.isMulticast(cAddrs)) {
                    int cBypass = this.getMulticastBypassCount();
                    if (cBypass > 0) {
                        this.setMulticastBypassCount(cBypass - 1);
                    } else if (packet.getSentCount() > 0) {
                        this.setMulticastBypassCount(Member$FlowControl.getSuccessGoal());
                    } else {
                        fMulticast = true;
                    }
                }
                if (fMulticast) {
                    bundle.setUdpSocket(this.getUdpSocketMulticast());
                    bundle.addDestination(this.getMulticastAddress());
                } else {
                    bundle.setUdpSocket(this.getUdpSocketUnicast());
                    int i = 0;
                    while (i < cAddrs) {
                        Member member = this.getMember(anToId[i]);
                        if (member != null) {
                            bundle.addDestination(this.getSocketAddress(member, packet));
                        }
                        ++i;
                    }
                }
                int cbPref = this.getPreferredPacketLength();
                long ldtNow = Base.getLastSafeTimeMillis();
                int i = 0;
                while (i < cAddrs) {
                    Member member = this.getMember(anToId[i]);
                    if (member != null) {
                        member.setLastOutgoingMillis(ldtNow);
                        cbPref = Math.min(cbPref, member.getPreferredPacketLength());
                    }
                    ++i;
                }
                bundle.setMaximumLength(cbPref);
            } else if (packet instanceof Broadcast) {
                if (!this.isMulticastEnabled() ? false : ((Broadcast)packet).getToAddress() == null) {
                    bundle.setUdpSocket(this.getUdpSocketMulticast());
                    bundle.addDestination(this.getMulticastAddress());
                } else {
                    bundle.setUdpSocket(this.getUdpSocketUnicast());
                    if (((Broadcast)packet).getToAddress() == null) {
                        Set setBroadcast;
                        Set cAddrs = setBroadcast = this.getBroadcastAddresses();
                        synchronized (cAddrs) {
                            bundle.addDestinations(setBroadcast);
                        }
                    } else {
                        InetSocketAddress[] aAddr = ((Broadcast)packet).getToAddress();
                        int i = 0;
                        int c = aAddr.length;
                        while (i < c) {
                            bundle.addDestination(aAddr[i]);
                            ++i;
                        }
                    }
                }
            }
        }
        return bundle.getAddressCount();
    }

    public void assignMessageIds(Message msg) {
        long lIdFrom = this.getFromMessageId() + 1L;
        this.setFromMessageId(lIdFrom);
        msg.setFromMessageId(lIdFrom);
        MessagePacket packetFirst = msg.getPacket(0);
        if (packetFirst instanceof Directed) {
            Directed packetHead = (Directed)packetFirst;
            DependentMemberSet setTo = packetHead.getToMemberSet();
            if (setTo == null) {
                Member memberTo = this.getMember(packetHead.getToId());
                if (memberTo != null) {
                    packetHead.setToMessageId(memberTo.getNextDestinationMessageId());
                }
            } else {
                Object[] aMember = setTo.toArray();
                int i = aMember.length - 1;
                while (i >= 0) {
                    Member memberTo = (Member)aMember[i];
                    setTo.setDestinationMessageId(memberTo.getId(), memberTo.getNextDestinationMessageId());
                    --i;
                }
            }
            long lFromMsgId = this.getMessageOutgoing().add(msg);
            long lSetId = msg.getFromMessageId();
            if (lSetId != lFromMsgId) {
                throw new IllegalStateException(new StringBuilder(String.valueOf("Set MsgFromId ")).append(lSetId).append(" != expected ").append(lFromMsgId).toString());
            }
            int i = 0;
            int c = msg.getMessagePartCount();
            while (i < c) {
                msg.getPacket(i).setFromMessageId(lFromMsgId);
                ++i;
            }
        } else {
            WindowedArray wa = this.getMessageOutgoing();
            wa.remove(wa.add(msg));
        }
    }

    protected int computePreferredPacketLength(MemberSet setTo) {
        int cbStd = 1452;
        int cbPref = this.getPreferredPacketLength();
        int cTo = setTo == null ? 0 : setTo.size();
        if (cTo == 1) {
            Member memberTo = this.getMemberSet().getMember(setTo.getFirstId());
            if (memberTo != null) {
                int cbPrefThat = memberTo.getPreferredPacketLength();
                cbPref = Math.min(cbPref, cbPrefThat == 0 ? Math.min(cbStd, this.getMaximumPacketLength()) : cbPrefThat);
            }
            return cbPref;
        }
        if (cTo == 0) {
            return cbPref;
        }
        if (!this.isMulticastEnabled() ? false : this.isMulticast(cTo)) {
            cbPref = Math.min(cbPref, Math.min(cbStd, this.getMaximumPacketLength()));
        }
        if (setTo instanceof ActualMemberSet) {
            Iterator iter = setTo.iterator();
            while (iter.hasNext()) {
                Member memberTo = (Member)iter.next();
                int cbPrefThat = memberTo.getPreferredPacketLength();
                cbPref = Math.min(cbPref, cbPrefThat == 0 ? Math.min(cbStd, this.getMaximumPacketLength()) : cbPrefThat);
            }
        } else {
            MasterMemberSet setCluster = this.getMemberSet();
            int[] anToId = setTo.toIdArray();
            int i = 0;
            int c = anToId.length;
            while (i < c) {
                Member memberTo = ((MemberSet)setCluster).getMember(anToId[i]);
                if (memberTo != null) {
                    int cbPrefThat = memberTo.getPreferredPacketLength();
                    cbPref = Math.min(cbPref, cbPrefThat == 0 ? Math.min(cbStd, this.getMaximumPacketLength()) : cbPrefThat);
                }
                ++i;
            }
        }
        return cbPref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deferPacket(Member member, MessagePacket packet) {
        boolean fResult = false;
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            if (packet.getDeliveryState() == MessagePacket.DELIVERY_CONFIRMED) {
                return false;
            }
            int cThreshold = flowControl.isPaused() ? 1 : flowControl.getOutstandingPacketThreshold();
            int cOutstanding = flowControl.getOutstandingPacketCount();
            boolean fOverLimit = cOutstanding > cThreshold;
            boolean fDeferring = flowControl.isDeferring();
            int nState = packet.getDeliveryState();
            if (nState == MessagePacket.DELIVERY_CONFIRMED) {
                fResult = false;
            } else if (fOverLimit) {
                Member$FlowControl member$FlowControl = flowControl;
                synchronized (member$FlowControl) {
                    flowControl.getDeferredQueue().add(packet);
                }
                packet.setDeliveryState(MessagePacket.DELIVERY_DEFERRED, member);
                fResult = true;
            } else if (!fDeferring ? false : nState != MessagePacket.DELIVERY_DEFERRED) {
                Member$FlowControl member$FlowControl = flowControl;
                synchronized (member$FlowControl) {
                    Queue deferredQueue = flowControl.getDeferredQueue();
                    if (deferredQueue.isEmpty()) {
                        this.getDeferredReadyQueue().add(packet);
                    } else {
                        deferredQueue.add(packet);
                    }
                }
                packet.setDeliveryState(MessagePacket.DELIVERY_DEFERRED, member);
                fResult = true;
            }
        }
        return fResult;
    }

    protected void doEarlyLossDetection(Member member, MessagePacket packetNewestTo, PacketIdentifier ptidNewestFrom) {
        MessagePacket packet;
        if (PacketComparator.compare(ptidNewestFrom, member.getContiguousFromPacketId()) > 0) {
            this.scheduleNack(member);
        }
        Member$SentQueue queueRecent = member.getRecentPacketQueue();
        int nMemberId = member.getId();
        if (packetNewestTo == null) {
            MessagePacket packet2;
            do {
                if (!((packet2 = (MessagePacket)queueRecent.peekNoWait()) == null ? true : packet2.isAddressedTo(nMemberId))) continue;
                return;
            } while (!(packet2 != queueRecent.removeNoWait()));
            throw new IllegalStateException();
        }
        PacketIdentifier ptidContTo = member.getContiguousToPacketId();
        long ldtNow = Base.getSafeTimeMillis();
        List listLost = this.getLostPacketListTemp();
        List listAckd = this.getAckdPacketListTemp();
        boolean fAdded = false;
        do {
            if ((packet = (MessagePacket)queueRecent.removeNoWait()) == null) {
                fAdded = false;
                break;
            }
            if (!(!packet.isAddressedTo(nMemberId) ? false : packet.getResendScheduled() > ldtNow)) continue;
            if (PacketComparator.compare(ptidContTo, packet) >= 0) {
                if (!packet.registerAck(member)) continue;
                listAckd.add(packet);
                continue;
            }
            listLost.add(packet);
            fAdded = true;
        } while (packet != packetNewestTo);
        if (listAckd.isEmpty() ^ true) {
            this.onAcknowledgedPacket(member, listAckd);
        }
        if (fAdded) {
            this.getResendQueue().addAllHead(listLost, true);
        }
    }

    public void drainDeferredPackets(Member member) {
        Queue queueReady;
        Queue queueDeferred;
        int cThreshold;
        int cSpots;
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null && (cSpots = (cThreshold = flowControl.isPaused() ? 1 : flowControl.getOutstandingPacketThreshold()) - flowControl.getOutstandingPacketCount()) > 0 && (queueDeferred = flowControl.getDeferredQueue()) != (queueReady = this.getDeferredReadyQueue())) {
            Packet packet;
            while (!((packet = (Packet)queueDeferred.removeNoWait()) == null)) {
                queueReady.add(packet);
                if (packet.getToId() != 0) {
                    --cSpots;
                }
                if (cSpots > 0) continue;
            }
        }
    }

    public long drainOverflow(Set setDest, long cMillisTimeout) throws InterruptedException {
        int cMaxPackets = this.getCloggedCount();
        if (cMaxPackets <= 0 ? true : setDest == null) {
            return cMillisTimeout;
        }
        MemberSet setMember = (MemberSet)setDest;
        Member member = this.getMember(setMember.getFirstId());
        if (!(!(!Member$FlowControl.isEnabled() ? false : setMember.size() == 1) ? false : member != null) ? false : member != this.getThisMember()) {
            long cPackets = this.getResendQueue().getMultipointPacketCount() + this.getDeferredReadyQueue().size();
            Member$FlowControl flowControl = member.getFlowControl();
            if (flowControl != null) {
                cPackets += (long)flowControl.getPendingPacketCount();
            }
            if (cPackets < (long)cMaxPackets) {
                return cMillisTimeout;
            }
        }
        return this.drainOverflowComplex(setMember, cMillisTimeout);
    }

    protected long drainOverflowComplex(MemberSet setMembers, long cMillisTimeout) throws InterruptedException {
        int cMaxPackets = this.getCloggedCount();
        Queue queueIn = this.getPacketAdapterQueue();
        Queue queueReady = this.getDeferredReadyQueue();
        PacketPublisher$ResendQueue queueResend = this.getResendQueue();
        boolean fFlowcontrol = Member$FlowControl.isEnabled();
        Member memberThis = this.getThisMember();
        int[] anToId = null;
        long ldtNow = 0L;
        long ldtStart = 0L;
        long ldtAlarmNext = 0L;
        long ldtTimeout = 0L;
        int cIters = 0;
        while (this.isStarted()) {
            int cPackets;
            int cPacketsIn = cPackets = queueIn.size();
            int cPacketsResend = -1;
            int cPacketsReady = -1;
            int cPacketsMp = -1;
            int cPacketsPending = -1;
            Member memberJammed = null;
            if (fFlowcontrol) {
                cPacketsMp = queueResend.getMultipointPacketCount();
                cPackets += cPacketsMp;
                cPacketsReady = queueReady.size();
                cPackets += cPacketsReady;
                if (setMembers == null) break;
                if (setMembers.size() == 1) {
                    Member$FlowControl flowControl;
                    Member member = this.getMember(setMembers.getFirstId());
                    if (member != null && (flowControl = member.getFlowControl()) != null) {
                        memberJammed = member;
                        cPacketsPending = flowControl.getPendingPacketCount();
                        cPackets += cPacketsPending;
                    }
                } else {
                    anToId = setMembers.toIdArray();
                    int i = 0;
                    int c = anToId.length;
                    while (i < c) {
                        int cPending;
                        Member$FlowControl flowControl;
                        Member member = this.getMember(anToId[i]);
                        if (member != null && (flowControl = member.getFlowControl()) != null && cPackets + (cPending = flowControl.getPendingPacketCount()) > cMaxPackets) {
                            memberJammed = member;
                            cPacketsPending = cPending;
                            cPackets += cPacketsPending;
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                cPacketsResend = queueResend.size();
                cPackets += cPacketsResend;
            }
            if (!(cPackets > cMaxPackets) ? false : ldtNow <= ldtTimeout) {
                if (ldtNow >= ldtAlarmNext) {
                    if (ldtStart == 0L) {
                        ldtStart = ldtNow = Base.getSafeTimeMillis();
                        ldtTimeout = cMillisTimeout == 0L ? Long.MAX_VALUE : ldtStart + cMillisTimeout;
                    } else {
                        Component._trace(new StringBuilder(String.valueOf("Overloaded packet queue; ")).append(cPackets).append("/").append(cMaxPackets).append(" packet limit").append(", Duration=").append((ldtNow - ldtStart) / (long)1000).append("s").append(", InQueue=").append(cPacketsIn).append(", ResendQueue=").append(cPacketsResend).append(", MultiPoint=").append(cPacketsMp).append(", Pending=").append(cPacketsPending).append(", Ready=").append(cPacketsReady).append(", ").append(memberJammed).append(", FlowControl(").append(memberJammed == null ? null : memberJammed.getFlowControl()).append(")").toString(), 2);
                    }
                    ldtAlarmNext = ldtNow + (long)(this.getResendTimeout() / 4);
                }
            } else {
                if (!(!(cPackets == 0) ? false : cIters > 1) || !((ldtNow = Base.getSafeTimeMillis()) > this.getLastTrafficJamWarningTimeMillis() + 60000L)) break;
                Component._trace(new StringBuilder(String.valueOf("The \"traffic-jam\" settings may be overly cautious; consider ")).append("increasing the \"maximum-packets\", or decreasing ").append("\"pause-milliseconds\"").toString(), 3);
                this.setLastTrafficJamWarningTimeMillis(ldtNow);
                break;
            }
            this.getQueue().flush();
            Blocking.sleep(this.getCloggedDelay());
            ldtNow = Base.getSafeTimeMillis();
            ++cIters;
        }
        if (cMillisTimeout == 0L ? true : ldtTimeout == 0L) {
            return cMillisTimeout;
        }
        if (ldtTimeout > ldtNow) {
            return ldtTimeout - ldtNow;
        }
        throw new RequestTimeoutException("Request timed out");
    }

    protected Message[] ensureMsgArrayTemp(int cMinSize) {
        Message[] aMsgTemp = this.getMsgArrayTemp();
        if (aMsgTemp == null ? true : aMsgTemp.length < cMinSize) {
            aMsgTemp = new Message[cMinSize];
            this.setMsgArrayTemp(aMsgTemp);
        }
        return aMsgTemp;
    }

    protected long[] ensureMsgIdArrayTemp(int cMinSize) {
        long[] alTemp = this.getMsgIdArrayTemp();
        if (alTemp == null ? true : alTemp.length < cMinSize) {
            alTemp = new long[cMinSize];
            this.setMsgIdArrayTemp(alTemp);
        }
        return alTemp;
    }

    protected MemberSet ensureSingleMemberSetTemp(Member member) {
        SingleMemberSet setMember = this.getSingleMemberSetTemp();
        setMember.setTheMember(member);
        return setMember;
    }

    public void flush() {
        this.getQueue().flush();
    }

    public void flushSend() {
        this.getSendQueue().flush();
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cMillis = Base.getSafeTimeMillis() - this.getStartTimestamp();
        long lSent = this.getStatsSent();
        long lResent = this.getStatsResent();
        long lWasted = this.getStatsResentExcess();
        double dCpu = cMillis == 0L ? 0.0 : (double)cCpu / (double)cMillis;
        double dThru = cCpu == 0L ? 0.0 : (double)lSent * (double)1000 / (double)cCpu;
        double dSuccess = lSent == 0L ? 1.0 : 1.0 - (double)lResent / (double)lSent;
        double dEfficiency = lSent == 0L ? 1.0f : (float)(1.0 - (double)lWasted / (double)lSent);
        dCpu = (double)((int)(dCpu * 1000.0)) / 10.0;
        dSuccess = (double)((int)(dSuccess * 10000.0)) / 10000.0;
        dEfficiency = (double)((int)(dEfficiency * 10000.0)) / 10000.0;
        return new StringBuilder(String.valueOf("Cpu=")).append(cCpu).append("ms (").append(dCpu).append("%)").append(", PacketsSent=").append(lSent).append(", PacketsResent=").append(lResent).append(", SuccessRate=").append(dSuccess).append(", Efficiency=").append(dEfficiency).append(", Throughput=").append((int)dThru).append("pkt/sec").toString();
    }

    public int getAckDelay() {
        return this.getAckQueue().getDelayMillis();
    }

    public PacketPublisher$AckQueue getAckQueue() {
        return this.__m_AckQueue;
    }

    protected List getAckdPacketListTemp() {
        List list = this.__m_AckdPacketListTemp;
        list.clear();
        return list;
    }

    public Set getBroadcastAddresses() {
        return this.__m_BroadcastAddresses;
    }

    public ByteArrayWriteBuffer.Allocator getBufferAllocator(int cb) {
        return null;
    }

    public int getCloggedCount() {
        return this.__m_CloggedCount;
    }

    public int getCloggedDelay() {
        return this.__m_CloggedDelay;
    }

    public ByteBuffer getClusterNameBuffer() {
        return this.__m_ClusterNameBuffer;
    }

    public PacketPublisher$ConfirmationQueue getConfirmationQueue() {
        return this.__m_ConfirmationQueue;
    }

    public Queue getDeferredReadyQueue() {
        return this.__m_DeferredReadyQueue;
    }

    public long getFromMessageId() {
        return this.__m_FromMessageId;
    }

    protected Queue[] getIncomingPacketQueues() {
        return this.__m_IncomingPacketQueues;
    }

    public long getLastTrafficJamWarningTimeMillis() {
        return this.__m_LastTrafficJamWarningTimeMillis;
    }

    protected List getLostPacketListTemp() {
        List list = this.__m_LostPacketListTemp;
        list.clear();
        return list;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public MultiBufferWriteBuffer.WriteBufferPool getMessageBufferAllocator() {
        return this.__m_MessageBufferAllocator;
    }

    public WindowedArray getMessageOutgoing() {
        return this.__m_MessageOutgoing;
    }

    public Message[] getMsgArrayTemp() {
        return this.__m_MsgArrayTemp;
    }

    public long[] getMsgIdArrayTemp() {
        return this.__m_MsgIdArrayTemp;
    }

    public InetSocketAddress getMulticastAddress() {
        return this.__m_MulticastAddress;
    }

    public int getMulticastBypassCount() {
        return this.__m_MulticastBypassCount;
    }

    public double getMulticastThreshold() {
        return this.__m_MulticastThreshold;
    }

    public long getNackDelayMillis() {
        return this.__m_NackDelayMillis;
    }

    public Queue getPacketAdapterQueue() {
        return this.__m_PacketAdapterQueue;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public int getResendDelay() {
        return this.getResendQueue().getResendMillis();
    }

    public PacketPublisher$ResendQueue getResendQueue() {
        return this.__m_ResendQueue;
    }

    public int getResendTimeout() {
        return this.getResendQueue().getTimeoutMillis();
    }

    public Queue getSendQueue() {
        return this.__m_SendQueue;
    }

    protected SingleMemberSet getSingleMemberSetTemp() {
        return this.__m_SingleMemberSetTemp;
    }

    protected SocketAddress getSocketAddress(Member member, Packet packetData) {
        switch (packetData.getPacketType()) {
            case 232718547: 
            case 232718548: 
            case 232718549: {
                if (!(packetData.getSentCount() < member.getTxDebugDropCount())) break;
                return new InetSocketAddress("0.0.0.0", 0);
            }
        }
        return packetData.getLength() <= member.getPreferredPacketLength() ? member.getPreferredSocketAddress() : member.getSocketAddress();
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsNacksSent() {
        return this.__m_StatsNacksSent;
    }

    public long getStatsResent() {
        return this.__m_StatsResent;
    }

    public long getStatsResentEarly() {
        return this.__m_StatsResentEarly;
    }

    public long getStatsResentExcess() {
        return this.__m_StatsResentExcess;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public UdpSocket getUdpSocketMulticast() {
        return this.__m_UdpSocketMulticast;
    }

    public UnicastUdpSocket getUdpSocketUnicast() {
        return this.__m_UdpSocketUnicast;
    }

    public long getWaitMillis() {
        long lWaitResend = this.getResendQueue().getWaitMillis();
        long lWaitAck = this.getAckQueue().getWaitMillis();
        if (!(lWaitResend == 0L) ? false : lWaitAck == 0L) {
            return 0L;
        }
        if (lWaitResend == 0L) {
            lWaitResend = 60000L;
        }
        if (lWaitAck == 0L) {
            lWaitAck = 60000L;
        }
        return Math.min(lWaitResend, lWaitAck);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PacketPublisher();
    }

    private final Component get_Module() {
        return this;
    }

    protected void halt() {
        this.setUdpSocketMulticast(null);
        this.setUdpSocketUnicast(null);
        super.halt();
    }

    protected Queue instantiateQueue() {
        return (Queue)this._findChild("InQueue");
    }

    public boolean isMulticast(int cToMembers) {
        if (cToMembers <= 1) {
            return false;
        }
        int cOtherMembers = this.getMemberSet().size() - 1;
        double dflMulticastThreshold = this.getMulticastThreshold();
        return cToMembers > (int)(dflMulticastThreshold * (double)cOtherMembers);
    }

    public boolean isMulticastEnabled() {
        return this.__m_MulticastEnabled;
    }

    public boolean isNackEnabled() {
        return this.__m_NackEnabled;
    }

    protected void onAcknowledgedPacket(Member member, Collection collAcknowledged) {
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            int cNewAcks = 0;
            Iterator iter = collAcknowledged.iterator();
            while (iter.hasNext()) {
                MessagePacket packet = (MessagePacket)iter.next();
                if (!packet.isDeferrable()) continue;
                ++cNewAcks;
                packet.setDeliveryState(MessagePacket.DELIVERY_CONFIRMED, member);
            }
            int cSeqAcks = flowControl.getSequentialConfirmedCount();
            int cSeqLost = flowControl.getSequentialLostCount();
            if (cSeqLost > 0) {
                flowControl.setPaused(false);
                flowControl.setSequentialLostCount(0);
                flowControl.setSequentialConfirmedCount(cNewAcks);
            } else {
                flowControl.setSequentialConfirmedCount(cSeqAcks + cNewAcks);
            }
            if (flowControl.isAdjustable()) {
                int cThreshold = flowControl.getOutstandingPacketThreshold();
                int cEffectiveAcks = cSeqLost == 0 ? cSeqAcks : cSeqAcks / cSeqLost;
                int iGoalDelta = cEffectiveAcks - Member$FlowControl.getSuccessGoal();
                boolean fNearCap = flowControl.getOutstandingPacketHighMark() > cThreshold - (cThreshold >>> 2);
                if (!(iGoalDelta < 0) ? false : cSeqLost > 0) {
                    cThreshold -= Math.max(1, cThreshold / Member$FlowControl.getAggressionFactor());
                    flowControl.setOutstandingPacketThreshold(cThreshold);
                } else if (!(iGoalDelta > 0) ? false : fNearCap) {
                    flowControl.setOutstandingPacketHighMark(flowControl.getOutstandingPacketCount());
                    cThreshold += Math.max(1, cThreshold / Member$FlowControl.getAggressionFactor());
                    flowControl.setOutstandingPacketThreshold(cThreshold);
                }
            }
            this.drainDeferredPackets(member);
        }
    }

    protected void onConfirmation(Ack packetAck) {
        Member memberThis;
        Object[] aMsgAck;
        long[] alMsgId;
        int nFromId = packetAck.getFromId();
        Member member = this.getMember(nFromId);
        if (member == null) {
            return;
        }
        WindowedArray waMsg = this.getMessageOutgoing();
        long lMsgFirst = waMsg.getFirstIndex();
        long lMsgId = 0L;
        int cUniqueMsgs = 0;
        try {
            int cNotify = packetAck.getNotifyCount();
            alMsgId = this.ensureMsgIdArrayTemp(cNotify + 1);
            int iNotify = 0;
            int iLastTrint = -1;
            while (iNotify < cNotify) {
                int iMsgIdTrint = packetAck.getMessageId(iNotify);
                if (iMsgIdTrint != iLastTrint) {
                    lMsgId = Packet.translateTrint(iMsgIdTrint, lMsgFirst);
                    iLastTrint = iMsgIdTrint;
                    alMsgId[cUniqueMsgs++] = lMsgId;
                }
                ++iNotify;
            }
        }
        catch (Exception e) {
            Component._trace(new StringBuilder(String.valueOf("Exception while translating Trints from Ack ")).append(packetAck).append(" front of outgoing message array is ").append(waMsg.get(lMsgFirst)).append(" array window size is ").append(waMsg.getWindowSize()).toString(), 1);
            throw Base.ensureRuntimeException(e);
        }
        boolean fUseNacks = this.isNackEnabled();
        PacketIdentifier ptidNewestTo = packetAck.getNewestFromPacketId(lMsgFirst);
        MessagePacket packetNewestTo = null;
        if (!fUseNacks ? false : ptidNewestTo != null) {
            long lNewestMsgId = ptidNewestTo.getFromMessageId();
            if (lNewestMsgId != lMsgId) {
                alMsgId[cUniqueMsgs++] = lNewestMsgId;
            }
            aMsgAck = this.ensureMsgArrayTemp(cUniqueMsgs);
            waMsg.getAll(alMsgId, cUniqueMsgs, aMsgAck);
            Object msgNewest = aMsgAck[cUniqueMsgs - 1];
            int iPacket = ptidNewestTo.getMessagePartIndex();
            if ((!(msgNewest != null) ? false : iPacket < ((Message)msgNewest).getMessagePartCount()) && (!((packetNewestTo = ((Message)msgNewest).getPacket(iPacket)) != null) ? false : packetNewestTo.isAddressedTo(nFromId) ^ true)) {
                packetNewestTo = null;
            }
        } else {
            aMsgAck = this.ensureMsgArrayTemp(cUniqueMsgs);
            waMsg.getAll(alMsgId, cUniqueMsgs, aMsgAck);
        }
        MessagePacket packetLast = this.registerAcks(packetAck, member, (Message[])aMsgAck);
        PacketIdentifier ptidCont = packetAck.getContiguousFromPacketId(lMsgFirst);
        if (PacketComparator.compare(ptidCont, member.getContiguousToPacketId()) > 0) {
            member.setContiguousToPacketId(ptidCont);
        }
        if (fUseNacks) {
            this.doEarlyLossDetection(member, (packetNewestTo == null ? true : packetNewestTo.isOutgoingMultipoint()) ? packetLast : packetNewestTo, packetAck.getNewestToPacketId(member.getLastIncomingMessageId()));
        }
        if ((memberThis = this.getThisMember()) != null) {
            long lRecvTime = packetAck.getReceivedMillis();
            memberThis.setLastIncomingMillis(lRecvTime);
            if (member != memberThis) {
                member.setLastIncomingMillis(lRecvTime);
            }
        }
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    public void onException(Throwable e) {
        super.onException(e);
    }

    public void onInit() {
        this.setMessageOutgoing((PacketPublisher$OutgoingMessageArray)this._findChild("OutgoingMessageArray"));
        this.setAckQueue((PacketPublisher$AckQueue)this._findChild("AckQueue"));
        this.setResendQueue((PacketPublisher$ResendQueue)this._findChild("ResendQueue"));
        this.setConfirmationQueue((PacketPublisher$ConfirmationQueue)this._findChild("ConfirmationQueue"));
        super.onInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMemberLeft(Member member) {
        Queue queueReady;
        Queue queueDeferred;
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null && (queueDeferred = flowControl.getDeferredQueue()) != (queueReady = this.getDeferredReadyQueue())) {
            Member$FlowControl member$FlowControl = flowControl;
            synchronized (member$FlowControl) {
                flowControl.setDeferredQueue(this.getDeferredReadyQueue());
            }
            Object o = queueDeferred.removeNoWait();
            while (o != null) {
                queueReady.add(o);
                o = queueDeferred.removeNoWait();
            }
        }
    }

    protected void onNoRecipientPacket(Packet packet) {
        if (packet.isConfirmationRequired()) {
            ((MessagePacket)packet).clearRecipients();
            this.getResendQueue().addHead(packet);
        }
    }

    protected void onNotify() {
        try {
            long ldtStart = Base.getLastSafeTimeMillis();
            Queue[] aQueue = this.getIncomingPacketQueues();
            Queue queueReady = this.getDeferredReadyQueue();
            PacketPublisher$ConfirmationQueue queueConfirm = this.getConfirmationQueue();
            Queue queueIn = this.getPacketAdapterQueue();
            int cQueues = aQueue.length;
            int cPacketsStart = queueIn.size();
            int cSentPackets = 0;
            int cResentPackets = 0;
            int cEarlyPackets = 0;
            while (true) {
                Ack ack;
                if (!((ack = (Ack)((Queue)queueConfirm).removeNoWait()) == null)) {
                    this.onConfirmation(ack);
                    continue;
                }
                boolean fMore = false;
                int iQueue = 0;
                int cDeferred = 0;
                while (iQueue < cQueues) {
                    Queue queue = aQueue[iQueue];
                    Packet packet = (Packet)queue.removeNoWait();
                    if (packet != null) {
                        boolean fResend = packet.getSentMillis() != 0L;
                        int cSent = this.onPacket(packet);
                        fMore = true;
                        cSentPackets += cSent;
                        if (fResend) {
                            cResentPackets += cSent;
                            if (((MessagePacket)packet).getPendingResendSkips() > 0) {
                                cEarlyPackets += cSent;
                            }
                        }
                        if (queue == queueReady) {
                            if (cDeferred-- > 0) {
                                continue;
                            }
                        } else if (!(cSent == 0) ? false : packet.isDeferrable()) {
                            ++cDeferred;
                        }
                    }
                    ++iQueue;
                }
                if (fMore ^ true ? true : cSentPackets >= 100) {
                    long ldtNow = Base.getSafeTimeMillis();
                    if (fMore ^ true ? true : cSentPackets >= 30000) {
                        int cPacketsNow = fMore ? queueIn.size() : 0;
                        ((PacketSpeaker$BundlingQueue)this.getSendQueue()).tuneVolumeThreshold(cPacketsNow - cPacketsStart);
                        this.setStatsSent(this.getStatsSent() + (long)cSentPackets);
                        this.setStatsResent(this.getStatsResent() + (long)cResentPackets);
                        this.setStatsResentEarly(this.getStatsResentEarly() + (long)cEarlyPackets);
                        this.setStatsCpu(this.getStatsCpu() + ldtNow - ldtStart);
                        cEarlyPackets = 0;
                        cResentPackets = 0;
                        cSentPackets = 0;
                        cPacketsStart = cPacketsNow;
                        ldtStart = ldtNow;
                    }
                }
                if (!fMore) break;
            }
        }
        catch (Exception e) {
            if (this.isExiting()) {
                return;
            }
            throw Base.ensureRuntimeException(e);
        }
    }

    protected int onPacket(Packet packet) {
        if (!(packet.getSentMillis() > 0L) ? false : this.verifyResendNecessary((MessagePacket)packet) ^ true) {
            this.onNoRecipientPacket(packet);
            return 0;
        }
        int nToId = packet.getToId();
        Member memberSingle = nToId > 0 ? this.getMember(nToId) : null;
        if (!(!(memberSingle != null) ? false : packet.isDeferrable()) ? false : this.deferPacket(memberSingle, (MessagePacket)packet)) {
            return 0;
        }
        long ldtNow = Base.getLastSafeTimeMillis();
        boolean fReliable = packet.isConfirmationRequired();
        int cAddresses = 0;
        PacketBundle bundle = new PacketBundle();
        bundle.addPacket(packet);
        if (memberSingle == null) {
            cAddresses = this.addressMany(bundle);
            if (cAddresses == 0) {
                this.onNoRecipientPacket(packet);
                return 0;
            }
        } else {
            bundle.setUdpSocket(this.getUdpSocketUnicast());
            bundle.addDestination(this.getSocketAddress(memberSingle, packet));
            bundle.setMaximumLength(Math.min(this.getPreferredPacketLength(), memberSingle.getPreferredPacketLength()));
            cAddresses = 1;
            if (fReliable) {
                memberSingle.setLastOutgoingMillis(ldtNow);
            }
        }
        this.onSendPacket(packet);
        int cSent = packet.getSentCount();
        if (cSent == 0) {
            this.getSendQueue().add(bundle);
        } else {
            bundle.send();
            ldtNow = Base.getLastSafeTimeMillis();
        }
        packet.setSentMillis(ldtNow);
        packet.setSentCount(cSent + 1);
        if (fReliable) {
            this.getResendQueue().add(packet);
        }
        return cAddresses;
    }

    protected void onSendPacket(Member member, Packet packet) {
        MessagePacket msgPacket;
        Member$FlowControl flowControl = member.getFlowControl();
        if ((!(flowControl != null) ? false : packet.isDeferrable()) && (msgPacket = (MessagePacket)packet).getDeliveryState() != MessagePacket.DELIVERY_CONFIRMED) {
            msgPacket.setDeliveryState(MessagePacket.DELIVERY_OUTSTANDING, member);
        }
        if (!(!this.isNackEnabled() ? false : packet.isConfirmationRequired()) ? false : packet.isOutgoingMultipoint() ^ true) {
            if (packet.getSentMillis() == 0L) {
                member.setNewestToPacketId((MessagePacket)packet);
            }
            member.getRecentPacketQueue().add(packet);
        }
        member.setStatsSent(member.getStatsSent() + (long)1);
        if (packet.getSentMillis() > (long)0) {
            member.setStatsResent(member.getStatsResent() + (long)1);
        }
    }

    protected void onSendPacket(Packet packet) {
        if (packet.isOutgoingMultipoint()) {
            int[] anToId = ((MessagePacket)packet).getToMemberSet().toIdArray();
            int i = 0;
            int c = anToId.length;
            while (i < c) {
                Member member = this.getMember(anToId[i]);
                if (member != null) {
                    this.onSendPacket(member, packet);
                }
                ++i;
            }
        } else {
            Member member = this.getMember(packet.getToId());
            if (member != null) {
                this.onSendPacket(member, packet);
            }
        }
    }

    public void onSlowPacket(MessagePacket packet) {
    }

    public void onUndeliverablePacket(MessagePacket packet) {
        DependentMemberSet setMemberTo;
        int nMemberTo = packet.getToId();
        if (nMemberTo != 0) {
            Member member = this.getMember(nMemberTo);
            if (member != null) {
                this.getMemberSet().remove(member);
            }
            packet.setToId(0);
        }
        if ((setMemberTo = packet.getToMemberSet()) != null) {
            this.getMemberSet().removeAll((Collection)setMemberTo);
            setMemberTo.clear();
        }
    }

    protected void onWait() throws InterruptedException {
        this.flushSend();
        super.onWait();
    }

    public boolean packetizeMessage(Message msg) {
        ReadBuffer bufferRead;
        Disposable controller = msg.getBufferController();
        if (controller == null) {
            try {
                MultiBufferWriteBuffer buffer = new MultiBufferWriteBuffer(this.getMessageBufferAllocator());
                msg.setBufferController(buffer, 1);
                msg.getService().serializeMessage(msg, buffer.getBufferOutput());
                bufferRead = buffer.getUnsafeReadBuffer();
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        } else {
            int i = 0;
            int c = msg.getToMemberSet().size() - 1;
            while (i < c) {
                msg.releaseOutgoing(true);
                ++i;
            }
            BufferSequence bufseq = (BufferSequence)controller;
            int cBuffers = bufseq.getBufferCount();
            if (cBuffers == 1) {
                bufferRead = new ByteBufferReadBuffer(bufseq.getBuffer(0));
            } else {
                ReadBuffer[] abuf = new ReadBuffer[cBuffers];
                int i2 = 0;
                while (i2 < cBuffers) {
                    abuf[i2] = new ByteBufferReadBuffer(bufseq.getBuffer(i2));
                    ++i2;
                }
                bufferRead = new MultiBufferReadBuffer(abuf);
            }
            msg.setReadBuffer(bufferRead);
        }
        return msg.packetize(this, this.getMemberSet(), bufferRead, this.computePreferredPacketLength(msg.getToMemberSet()), this.getMaximumPacketLength());
    }

    public boolean post(Object oMsg) {
        return this.getQueue().add(oMsg);
    }

    protected MessagePacket registerAcks(Ack packetAck, Member member, Message[] aMsgAck) {
        Message msgLast = null;
        MessagePacket packetLast = null;
        List listAckd = this.getAckdPacketListTemp();
        int cNotify = packetAck.getNotifyCount();
        int cNewAck = 0;
        int i = 0;
        int iLastTrint = -1;
        int iMsg = 0;
        while (i < cNotify) {
            MessagePacket packetMsg;
            int iMsgIdTrint = packetAck.getMessageId(i);
            if (iMsgIdTrint != iLastTrint) {
                msgLast = aMsgAck[iMsg];
                aMsgAck[iMsg++] = null;
                iLastTrint = iMsgIdTrint;
            }
            if (msgLast != null && (!((packetMsg = msgLast.getPacket(packetAck.getMessagePartIndex(i))) != null) ? false : packetMsg.registerAck(member))) {
                listAckd.add(packetMsg);
                if (packetMsg.isOutgoingMultipoint() ^ true) {
                    packetLast = packetMsg;
                }
                ++cNewAck;
            }
            ++i;
        }
        if (cNewAck < cNotify) {
            this.setStatsResentExcess(Math.min(this.getStatsResent(), this.getStatsResentExcess() + (long)(cNotify - cNewAck)));
        }
        this.onAcknowledgedPacket(member, listAckd);
        return packetLast;
    }

    public void resetStats() {
        this.setStatsSent(0L);
        this.setStatsResent(0L);
        this.setStatsResentEarly(0L);
        this.setStatsResentExcess(0L);
        this.setStatsNacksSent(0L);
        this.setStatsCpu(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void scheduleNack(Member member) {
        Ack packetAck = member.getPacketAck();
        long ldtSend = Base.getSafeTimeMillis() + this.getNackDelayMillis();
        if (!(packetAck != null) ? false : packetAck.getScheduledMillis() <= ldtSend) {
            if (packetAck.isFlushed() ^ true) {
                return;
            }
            packetAck = null;
        }
        if (packetAck == null) {
            packetAck = new Ack();
            packetAck.setFromId(this.getMemberId());
            packetAck.setToId(member.getId());
        }
        packetAck.setScheduledMillis(ldtSend);
        this.setStatsNacksSent(this.getStatsNacksSent() + 1L);
        this.getAckQueue().addHead(packetAck);
    }

    public void sendDiagnosticPacket(DiagnosticPacket packet) {
        block3: {
            try {
                Member memberTo = this.getMember(packet.getToId());
                if (memberTo == null) {
                    Component._trace(new StringBuilder(String.valueOf("Aborting diagnostic to unknown member ")).append(packet).toString(), 3);
                    return;
                }
                PacketBundle bundle = new PacketBundle();
                bundle.addPacket(packet);
                packet.setFromId(this.getThisMember().getId());
                bundle.setUdpSocket(this.getUdpSocketUnicast());
                bundle.addDestination(packet.isPreferredPortUsed() ? memberTo.getPreferredSocketAddress() : memberTo.getSocketAddress());
                packet.setSentMillis(Base.getSafeTimeMillis());
                SingleMemberSet setTo = new SingleMemberSet();
                setTo.add(memberTo);
                bundle.send();
                packet.setSentCount(1);
                Component._trace(new StringBuilder(String.valueOf("Sent ")).append(packet).toString(), 6);
            }
            catch (Exception e) {
                if (!(this.isExiting() ^ true)) break block3;
                Component._trace(new StringBuilder(String.valueOf("Failed to send ")).append(packet).append(" due to exception: ").append(e).toString(), 1);
            }
        }
    }

    public void setAckDelay(int cMillis) {
        this.getAckQueue().setDelayMillis(cMillis);
    }

    protected void setAckQueue(PacketPublisher$AckQueue queue) {
        this.__m_AckQueue = queue;
    }

    protected void setAckdPacketListTemp(List listPacket) {
        this.__m_AckdPacketListTemp = listPacket;
    }

    public void setBroadcastAddresses(Set list) {
        this.__m_BroadcastAddresses = list;
    }

    public void setCloggedCount(int cMaxPackets) {
        this.__m_CloggedCount = cMaxPackets;
    }

    public void setCloggedDelay(int cMillis) {
        this.__m_CloggedDelay = Math.max(1, cMillis);
    }

    public void setClusterNameBuffer(ByteBuffer bufBuffer) {
        this.__m_ClusterNameBuffer = bufBuffer;
    }

    protected void setConfirmationQueue(PacketPublisher$ConfirmationQueue queue) {
        this.__m_ConfirmationQueue = queue;
    }

    public void setDeferredReadyQueue(Queue queue) {
        this.__m_DeferredReadyQueue = queue;
    }

    protected void setFromMessageId(long lId) {
        this.__m_FromMessageId = lId;
    }

    protected void setIncomingPacketQueues(Queue[] aQueue) {
        this.__m_IncomingPacketQueues = aQueue;
    }

    protected void setLastTrafficJamWarningTimeMillis(long cMillis) {
        this.__m_LastTrafficJamWarningTimeMillis = cMillis;
    }

    protected void setLostPacketListTemp(List listPacket) {
        this.__m_LostPacketListTemp = listPacket;
    }

    public void setMaximumPacketLength(int cbMax) {
        this.__m_MaximumPacketLength = cbMax;
    }

    public void setMessageBufferAllocator(MultiBufferWriteBuffer.WriteBufferPool allocator) {
        this.__m_MessageBufferAllocator = allocator;
    }

    protected void setMessageOutgoing(WindowedArray waMsg) {
        this.__m_MessageOutgoing = waMsg;
    }

    protected void setMsgArrayTemp(Message[] aMsg) {
        this.__m_MsgArrayTemp = aMsg;
    }

    protected void setMsgIdArrayTemp(long[] alMsgId) {
        this.__m_MsgIdArrayTemp = alMsgId;
    }

    public void setMulticastAddress(InetSocketAddress addressMulticast) {
        this.__m_MulticastAddress = addressMulticast;
    }

    protected void setMulticastBypassCount(int nCount) {
        this.__m_MulticastBypassCount = nCount;
    }

    public void setMulticastEnabled(boolean fEnabled) {
        this.__m_MulticastEnabled = fEnabled;
    }

    public void setMulticastThreshold(double dflThresholdPercent) {
        this.__m_MulticastThreshold = dflThresholdPercent;
    }

    public void setNackDelayMillis(long cDelayMillis) {
        this.__m_NackDelayMillis = cDelayMillis;
    }

    public void setNackEnabled(boolean fEnabled) {
        this.__m_NackEnabled = fEnabled;
    }

    protected void setPacketAdapterQueue(Queue queue) {
        this.__m_PacketAdapterQueue = queue;
    }

    public void setPreferredPacketLength(int cbPacket) {
        this.__m_PreferredPacketLength = cbPacket;
    }

    public void setResendDelay(int cMillis) {
        PacketPublisher$ResendQueue queue = this.getResendQueue();
        if (queue != null) {
            queue.setResendMillis(cMillis);
        }
    }

    protected void setResendQueue(PacketPublisher$ResendQueue queue) {
        this.__m_ResendQueue = queue;
    }

    public void setResendTimeout(int cMillis) {
        PacketPublisher$ResendQueue queue = this.getResendQueue();
        if (queue != null) {
            queue.setTimeoutMillis(cMillis);
        }
    }

    public void setSendQueue(Queue queue) {
        this.__m_SendQueue = queue;
    }

    protected void setSingleMemberSetTemp(SingleMemberSet set) {
        this.__m_SingleMemberSetTemp = set;
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsNacksSent(long cPackets) {
        this.__m_StatsNacksSent = cPackets;
    }

    protected void setStatsResent(long cPackets) {
        this.__m_StatsResent = cPackets;
    }

    protected void setStatsResentEarly(long cPackets) {
        this.__m_StatsResentEarly = cPackets;
    }

    protected void setStatsResentExcess(long cPackets) {
        this.__m_StatsResentExcess = cPackets;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    protected void setStatsSent(long cPackets) {
        this.__m_StatsSent = cPackets;
    }

    public void setUdpSocketMulticast(UdpSocket socket) {
        this.__m_UdpSocketMulticast = socket;
    }

    public void setUdpSocketUnicast(UnicastUdpSocket socket) {
        this.__m_UdpSocketUnicast = socket;
    }

    public synchronized void start() {
        if (this.getSendQueue() == null) {
            throw new IllegalStateException("SendQueue is required!");
        }
        if (this.getMaximumPacketLength() == 0) {
            throw new IllegalStateException("MaximumPacketLength is required!");
        }
        if (this.getPreferredPacketLength() == 0) {
            throw new IllegalStateException("PreferredPacketLength is required!");
        }
        if (this.getUdpSocketUnicast() == null) {
            throw new IllegalStateException("UdpSocketUnicast is required!");
        }
        if (!(this.getUdpSocketMulticast() == null) ? false : this.isMulticastEnabled()) {
            throw new IllegalStateException("UdpSocketMulticast is required!");
        }
        this.setPacketAdapterQueue(((PacketPublisher$InQueue)this.getQueue()).getPacketAdapter());
        Queue queueDeferred = this.getDeferredReadyQueue();
        Queue[] aQueue = new Queue[queueDeferred == null ? 3 : 4];
        int iQueue = 0;
        aQueue[iQueue++] = this.getAckQueue();
        aQueue[iQueue++] = this.getPacketAdapterQueue();
        aQueue[iQueue++] = this.getResendQueue();
        if (queueDeferred != null) {
            aQueue[iQueue++] = queueDeferred;
        }
        this.setIncomingPacketQueues(aQueue);
        super.start();
    }

    public void stop() {
        super.stop();
        try {
            UdpSocket socket = this.getUdpSocketMulticast();
            if (socket != null) {
                socket.close();
            }
        }
        catch (Throwable throwable) {}
    }

    public String toString() {
        return new StringBuilder(String.valueOf(this.get_Name())).append(':').append(this.formatStats()).toString();
    }

    public boolean verifyResendNecessary(MessagePacket packet) {
        PacketPublisher publisher = (PacketPublisher)this.get_Module();
        long lMsgId = packet.getFromMessageId();
        boolean fLiveMembers = false;
        if (packet.isOutgoingMultipoint()) {
            int[] anToId = packet.getToMemberSet().toIdArray();
            int i = 0;
            int c = anToId.length;
            while (i < c) {
                Member member = publisher.getMember(anToId[i]);
                if (member != null) {
                    fLiveMembers = true;
                    if (!(PacketComparator.compare(member.getContiguousToPacketId(), packet) >= 0) ? false : packet.registerAck(member)) {
                        this.onAcknowledgedPacket(member, Collections.singleton(packet));
                    }
                }
                ++i;
            }
        } else {
            Member member = publisher.getMember(packet.getToId());
            if (member != null) {
                fLiveMembers = true;
                if (!(PacketComparator.compare(member.getContiguousToPacketId(), packet) >= 0) ? false : packet.registerAck(member)) {
                    this.onAcknowledgedPacket(member, Collections.singleton(packet));
                }
            }
        }
        return !fLiveMembers ? false : packet.isResendNecessary();
    }
}

