/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequest;
import java.util.Collection;

public class Grid$MemberWelcomeRequest$Poll
extends Poll {
    private transient MemberSet __m_RejectedMemberSet;

    public Grid$MemberWelcomeRequest$Poll() {
        this(null, null, true);
    }

    public Grid$MemberWelcomeRequest$Poll(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("RejectedMemberSet=[").append(this.getRejectedMemberSet().getIdList()).append(']');
        return sb.toString();
    }

    public MemberSet getRejectedMemberSet() {
        return this.__m_RejectedMemberSet;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/Grid$MemberWelcomeRequest$Poll".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Grid$MemberWelcomeRequest$Poll();
    }

    private final Component get_Module() {
        return this.get_Parent().get_Parent();
    }

    public boolean isRejected() {
        return this.getRejectedMemberSet().isEmpty() ^ true;
    }

    protected void onCompletion() {
        Grid service = this.getService();
        if (service.getServiceState() == Service.SERVICE_STARTED) {
            MemberSet setLeft = this.getLeftMemberSet();
            MemberSet setRejected = this.getRejectedMemberSet();
            if (service.getThisMember() == service.getServiceOldestMember()) {
                Component._trace(new StringBuilder(String.valueOf("This member has become service senior. Starting ")).append(service.getServiceName()).toString(), 3);
                if (service.getServiceId() > 0) {
                    service.onServiceStarted();
                }
            } else if (setRejected.isEmpty() ^ true ? true : setLeft.isEmpty() ^ true) {
                int cPauseMillis;
                MemberSet setRetry;
                ServiceMemberSet setCurrent = service.getServiceMemberSet();
                StringBuilder sbMsg = new StringBuilder("Retrying service handshake request due to a concurrent membership change");
                if (setLeft.isEmpty()) {
                    MemberSet setPrevious = ((Grid$MemberWelcomeRequest)this.get_Parent()).getSenderMemberSet();
                    setRetry = new MemberSet();
                    if (setPrevious.size() == ((MemberSet)setCurrent).size()) {
                        cPauseMillis = Math.min(500, 10 * setRejected.size());
                    } else {
                        cPauseMillis = 0;
                        setRetry.addAll((Collection)setCurrent);
                        setRetry.removeAll((Collection)setPrevious);
                    }
                    setRetry.addAll((Collection)setRejected);
                    setRetry.retainAll((Collection)service.getOthersMemberSet());
                    sbMsg.append("; resending the request to ").append(setRetry);
                } else {
                    cPauseMillis = 15;
                    setRetry = service.getOthersMemberSet();
                    sbMsg.append("; responders left ").append(setLeft).append("; resending the request to all ").append(setRetry.size()).append(" service members");
                }
                if (cPauseMillis > 0) {
                    sbMsg.append(" after a ").append(new Duration((long)cPauseMillis * 1000000L)).append(" backoff period");
                    Daemon.sleep(cPauseMillis);
                }
                Component._trace(sbMsg.toString(), 3);
                Grid$MemberWelcomeRequest msg = (Grid$MemberWelcomeRequest)service.instantiateMessage("MemberWelcomeRequest");
                msg.setSenderMemberSet(setCurrent);
                msg.setToMemberSet(setRetry);
                service.post(msg);
                this.setResult(Boolean.FALSE);
            } else if (service.getServiceId() > 0) {
                service.onServiceStarted();
            }
        }
        super.onCompletion();
    }

    public void onInit() {
        this.setRejectedMemberSet(new MemberSet());
        super.onInit();
    }

    public void onResponse(Message msg) {
        if (((Grid$MemberWelcome)msg).isRejected()) {
            this.getRejectedMemberSet().add(msg.getFromMember());
        }
        super.onResponse(msg);
    }

    protected void setRejectedMemberSet(MemberSet setReject) {
        this.__m_RejectedMemberSet = setReject;
    }
}

