/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.oracle.coherence.common.net.exabus.EndPoint;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining$Poll;
import com.tangosol.net.Member;
import com.tangosol.net.Service;
import com.tangosol.net.security.PermissionInfo;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class Grid$NotifyServiceJoining
extends RequestMessage
implements Service.MemberJoinAction {
    private Grid$NotifyResponse __m_ContinuationMessage;
    private com.tangosol.coherence.component.net.Member __m_NotifyMember;
    private Map __m_NotifyMemberConfigMap;
    private String __m_NotifyServiceEndPointName;
    private long __m_NotifyServiceJoinTime;
    private String __m_NotifyServiceVersion;
    private PermissionInfo __m_PermissionInfo;

    public Grid$NotifyServiceJoining() {
        this(null, null, true);
    }

    public Grid$NotifyServiceJoining(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(-10);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid$NotifyServiceJoining$Poll("Poll", this, true), "Poll");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public Grid$NotifyResponse getContinuationMessage() {
        return this.__m_ContinuationMessage;
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("NotifyMember=")).append(this.getNotifyMember()).append("\nNotifyEndPoint=").append(this.getNotifyServiceEndPointName()).toString();
    }

    public Member getJoiningMember() {
        return this.getNotifyMember();
    }

    public com.tangosol.coherence.component.net.Member getNotifyMember() {
        return this.__m_NotifyMember;
    }

    public Map getNotifyMemberConfigMap() {
        return this.__m_NotifyMemberConfigMap;
    }

    public String getNotifyServiceEndPointName() {
        return this.__m_NotifyServiceEndPointName;
    }

    public long getNotifyServiceJoinTime() {
        return this.__m_NotifyServiceJoinTime;
    }

    public String getNotifyServiceVersion() {
        return this.__m_NotifyServiceVersion;
    }

    public PermissionInfo getPermissionInfo() {
        return this.__m_PermissionInfo;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/Grid$NotifyServiceJoining".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Grid$NotifyServiceJoining();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceived() {
        MessageHandler handler;
        super.onReceived();
        Grid service = this.getService();
        com.tangosol.coherence.component.net.Member memberThis = service.getThisMember();
        com.tangosol.coherence.component.net.Member memberFrom = this.getNotifyMember();
        Map mapConfig = this.getNotifyMemberConfigMap();
        int nMemberFrom = memberFrom.getId();
        ServiceMemberSet setMember = service.getServiceMemberSet();
        Object oReject = null;
        Grid$NotifyResponse msgResponse = (Grid$NotifyResponse)service.instantiateMessage("NotifyResponse");
        msgResponse.respondTo(this);
        if (setMember.contains(memberFrom)) {
            Component._trace(new StringBuilder(String.valueOf("Rejecting the ServiceJoining request processing from member ")).append(nMemberFrom).toString(), 3);
            oReject = new StringBuilder(String.valueOf("Member ")).append(memberThis.getId()).append(" has not finished processing service departure notification").toString();
        }
        if (!(oReject == null) ? false : service.getActionPolicy().isAllowed(service, this) ^ true) {
            String sMsg = new StringBuilder(String.valueOf("The request from member ")).append(nMemberFrom).append(" to join the service was rejected by the service action policy").toString();
            Component._trace(sMsg, 3);
            oReject = new RuntimeException(sMsg);
        }
        Security security = service.getServiceId() > Cluster.MAX_SYSTEM_SERVICE ? Security.getInstance() : null;
        if (!(!(oReject == null) ? false : security != null) ? false : setMember.getOldestMember() == memberThis) {
            PermissionInfo piRequest = this.getPermissionInfo();
            if (piRequest == null) {
                Component._trace(new StringBuilder(String.valueOf("Request is rejected due to disabled security at ")).append(memberFrom).toString(), 1);
                oReject = new SecurityException();
            } else {
                Object oResponse = security.processSecureRequest(memberThis, memberFrom, piRequest);
                if (oResponse instanceof RuntimeException) {
                    Component._trace(new StringBuilder(String.valueOf("Security configuration mismatch or break-in attempt: ")).append(((RuntimeException)oResponse).getMessage()).toString(), 1);
                    oReject = new SecurityException();
                } else {
                    msgResponse.setResult(oResponse);
                }
            }
        }
        EndPoint peer = null;
        if (oReject == null && (peer = service.resolveEndPoint(this.getNotifyServiceEndPointName(), memberFrom, mapConfig)) != null && (handler = service.getMessageHandler()) != null) {
            if (handler.getConnectionMap().containsKey(peer)) {
                Component._trace(new StringBuilder(String.valueOf("Rejecting the ServiceJoining request processing from member ")).append(nMemberFrom).append("; EndPoint=").append(peer).toString(), 3);
                oReject = new StringBuilder(String.valueOf("Member ")).append(memberThis.getId()).append(" has not finished processing service departure notification").toString();
            } else if (handler.connect(memberFrom, peer) ^ true) {
                peer = null;
            }
        }
        if (oReject == null) {
            ServiceMemberSet serviceMemberSet = setMember;
            synchronized (serviceMemberSet) {
                setMember.add(memberFrom);
                setMember.setServiceVersion(nMemberFrom, this.getNotifyServiceVersion());
                setMember.setServiceJoinTime(nMemberFrom, this.getNotifyServiceJoinTime());
                setMember.setServiceEndPointName(nMemberFrom, peer == null ? null : peer.getCanonicalName());
                setMember.setServiceEndPoint(nMemberFrom, peer);
                setMember.updateMemberConfigMap(nMemberFrom, mapConfig);
                setMember.setServiceJoining(nMemberFrom);
            }
        } else {
            msgResponse.setResult(oReject);
        }
        service.post(msgResponse);
    }

    public void setContinuationMessage(Grid$NotifyResponse msg) {
        this.__m_ContinuationMessage = msg;
    }

    public void setNotifyMember(com.tangosol.coherence.component.net.Member member) {
        this.__m_NotifyMember = member;
    }

    public void setNotifyMemberConfigMap(Map map) {
        this.__m_NotifyMemberConfigMap = map;
    }

    public void setNotifyServiceEndPointName(String sName) {
        this.__m_NotifyServiceEndPointName = sName;
    }

    public void setNotifyServiceJoinTime(long ldt) {
        this.__m_NotifyServiceJoinTime = ldt;
    }

    public void setNotifyServiceVersion(String sVersion) {
        this.__m_NotifyServiceVersion = sVersion;
    }

    public void setPermissionInfo(PermissionInfo infoPermission) {
        this.__m_PermissionInfo = infoPermission;
    }

    public void setRequestTimeout(long ldtTimeout) {
        super.setRequestTimeout(ldtTimeout);
    }
}

