/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$SocketManager$UnicastUdpSocket;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$TcpRing;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.internal.ClusterJoinException;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Date;

public class ClusterService$NewMemberAnnounceReply
extends DiscoveryMessage {
    private int __m_AnnounceProtocolVersion;
    private long __m_PrevRecvTimestamp;
    private long __m_PrevSentTimestamp;
    private transient long __m_ThisRecvTimestamp;
    private long __m_ThisSentTimestamp;
    private static long __s_LastTraceMillis;

    public ClusterService$NewMemberAnnounceReply() {
        this(null, null, true);
    }

    public ClusterService$NewMemberAnnounceReply(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(8);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getAnnounceProtocolVersion() {
        return this.__m_AnnounceProtocolVersion;
    }

    public String getDescription() {
        long lPrevSentTimestamp = this.getPrevSentTimestamp() & 0xFFFFFFFFFFFFFFL;
        long lPrevRecvTimestamp = this.getPrevRecvTimestamp();
        long lThisSentTimestamp = this.getThisSentTimestamp();
        long lThisRecvTimestamp = this.getThisRecvTimestamp();
        String sPrevSentTimestamp = lPrevSentTimestamp == 0L ? "none" : new Date(lPrevSentTimestamp).toString();
        String sPrevRecvTimestamp = lPrevRecvTimestamp == 0L ? "none" : new Date(lPrevRecvTimestamp).toString();
        String sThisSentTimestamp = lThisSentTimestamp == 0L ? "none" : new Date(lThisSentTimestamp).toString();
        String sThisRecvTimestamp = lThisRecvTimestamp == 0L ? "none" : new Date(lThisRecvTimestamp).toString();
        return new StringBuilder(String.valueOf("ToMember=")).append(this.getToMember()).append("\nPrevSentTimestamp=").append(sPrevSentTimestamp).append("\nPrevRecvTimestamp=").append(sPrevRecvTimestamp).append("\nThisSentTimestamp=").append(sThisSentTimestamp).append("\nThisRecvTimestamp=").append(sThisRecvTimestamp).append("\nMaxDeliveryVariance=").append(this.getMaxDeliveryVariance()).toString();
    }

    public static long getLastTraceMillis() {
        return __s_LastTraceMillis;
    }

    protected int getMaxDeliveryVariance() {
        ClusterService service = (ClusterService)this.getService();
        return service.getTimestampMaxVariance();
    }

    public long getPrevRecvTimestamp() {
        return this.__m_PrevRecvTimestamp;
    }

    public long getPrevSentTimestamp() {
        return this.__m_PrevSentTimestamp;
    }

    protected long getThisRecvTimestamp() {
        return this.__m_ThisRecvTimestamp;
    }

    public long getThisSentTimestamp() {
        return this.__m_ThisSentTimestamp;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberAnnounceReply".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberAnnounceReply();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        Member memberFrom = this.getFromMember();
        Member memberTo = this.getToMember();
        switch (service.getState()) {
            case 0: {
                if (this.isReadError()) {
                    service.onMemberRejected(ClusterService.REJECT_VERSION, memberFrom);
                    throw new EventDeathException("Version mismatch");
                }
                Member memberAnnounce = service.getAnnounceMember();
                if (memberTo.equals(memberAnnounce)) {
                    ClusterService$TcpRing ring;
                    service.resetBroadcastCounter(null, this);
                    Cluster cluster = (Cluster)service.getCluster();
                    ClusterDependencies config = cluster.getDependencies();
                    if (cluster.isAuthorizedHost(memberFrom.getAddress()) ^ true) {
                        service.onMemberRejected(ClusterService.REJECT_SENIOR, memberFrom);
                        throw new EventDeathException("Unauthorized senior");
                    }
                    Cluster$SocketManager$UnicastUdpSocket socket = cluster.getSocketManager().getUnicastUdpSocket();
                    if (socket.getInetAddress().isAnyLocalAddress()) {
                        InetAddress addrRebind;
                        InetSocketAddress addrSockExt = this.getExternalAddress();
                        InetAddress addrExt = addrSockExt == null ? null : addrSockExt.getAddress();
                        InetAddress addrAnnounce = memberAnnounce.getAddress();
                        InetAddress inetAddress = addrRebind = addrExt == null ? addrAnnounce : addrExt;
                        if (InetAddresses.isLocalAddress(addrRebind)) {
                            try {
                                socket.rebind(addrRebind);
                            }
                            catch (IOException e) {
                                ClusterJoinException eJoin = new ClusterJoinException();
                                eJoin.initCause(e);
                                throw eJoin;
                            }
                        }
                        if (!(!(!service.isWkaEnabled() ? false : addrExt != null) ? false : addrExt.equals(addrAnnounce) ^ true) ? false : config.getLocalAddress() == null) {
                            Member memberAnnounceNew = service.instantiateMember();
                            memberAnnounceNew.configure(config, addrExt, memberAnnounce.getPort(), memberAnnounce.getTcpRingPort(), new int[]{memberAnnounce.getCpuCount(), memberAnnounce.getSocketCount(), memberAnnounce.getMachineId()});
                            memberAnnounce = memberAnnounceNew;
                            service.setAnnounceMember(memberAnnounce);
                        }
                    }
                    if (!(ring = service.getTcpRing()).isEnabled() ? false : ring.verifyReachable(memberFrom, 1000) ^ true) {
                        service.resetBroadcastCounter(new StringBuilder(String.valueOf("TcpRing failed to connect to")).append(" senior ").append(memberFrom).append("; if this persists it is").append(" likely the result of a local or remote firewall rule").append(" blocking connections to TCP-ring port ").append(memberFrom.getTcpRingPort()).toString(), null);
                        return;
                    }
                    if (!(!config.isIpMonitorEnabled() ? false : memberFrom.isCollocated(memberTo) ^ true) ? false : cluster.getIpMonitor().verifyReachable(memberFrom) ^ true) {
                        service.resetBroadcastCounter(new StringBuilder(String.valueOf("IpMonitor failed to verify ")).append("the reachability of senior ").append(memberFrom).append(" ").append(" via ").append(memberTo.getAddress()).append("; if this persists ").append("it is likely the result of a local or remote ").append("firewall rule blocking either ICMP pings, or ").append("connections to TCP port 7").toString(), null);
                        return;
                    }
                    long cPrevSentMillis = this.getPrevSentTimestamp();
                    long cPrevRecvMillis = this.getPrevRecvTimestamp();
                    long cThisSentMillis = this.getThisSentTimestamp();
                    long cThisRecvMillis = this.getThisRecvTimestamp();
                    long cMillisGoing = cPrevRecvMillis - cPrevSentMillis;
                    long cMillisComing = cThisSentMillis - cThisRecvMillis;
                    long cMillisMaxVar = this.getMaxDeliveryVariance();
                    long cMillisVar = Math.abs(cMillisGoing - cMillisComing);
                    if (cMillisVar <= cMillisMaxVar) {
                        long cMillisDif = (cMillisGoing + cMillisComing) / (long)2;
                        service.setTimestampAdjustment(cMillisDif);
                        Member memberThis = service.instantiateMember();
                        memberThis.configure(memberAnnounce, cThisSentMillis);
                        service.setRequestMember(memberThis);
                        service.setState(ClusterService.STATE_JOINING);
                        break;
                    }
                    long lMillis = Base.getSafeTimeMillis();
                    int nLevel = 5;
                    if (lMillis - ClusterService$NewMemberAnnounceReply.getLastTraceMillis() >= (long)service.getBroadcastTimeoutMillis()) {
                        ClusterService$NewMemberAnnounceReply.setLastTraceMillis(lMillis);
                        nLevel = 3;
                    }
                    Component._trace(new StringBuilder(String.valueOf("Failed to satisfy the variance: allowed=")).append(cMillisMaxVar).append(", actual=").append(cMillisGoing - cMillisComing).toString(), nLevel);
                    int cNewVariance = (int)Math.min(cMillisMaxVar + Math.max((cMillisVar - cMillisMaxVar) / (long)8, (long)1), (long)1000);
                    if (!((long)cNewVariance != cMillisMaxVar)) break;
                    service.setTimestampMaxVariance(cNewVariance);
                    Component._trace(new StringBuilder(String.valueOf("Increasing allowable variance to ")).append(cNewVariance).toString(), nLevel);
                    break;
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                break;
            }
            case 1: {
                if (this.isReadError()) {
                    service.onMemberRejected(ClusterService.REJECT_VERSION, memberFrom);
                    throw new EventDeathException("Version mismatch");
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                break;
            }
            case 2: {
                service.validateSeniorBroadcast(this, null);
                break;
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        MessagePacket packet;
        super.read(input);
        this.setPrevSentTimestamp(input.readLong() & 0xFFFFFFFFFFFFFFL);
        this.setPrevRecvTimestamp(input.readLong());
        this.setThisSentTimestamp(input.readLong());
        this.getFromMember().setTcpRingPort(input.readInt());
        MessagePacket[] aPacket = this.getPacket();
        if ((!(aPacket != null) ? false : aPacket.length > 0) && (packet = aPacket[0]) != null) {
            this.setThisRecvTimestamp(((ClusterService)this.getService()).calcTimestamp(packet.getReceivedMillis()));
        }
        if (input.available() > 0) {
            int cbAddr;
            int nProtoVerPeer = input.read();
            this.setAnnounceProtocolVersion(nProtoVerPeer);
            if (nProtoVerPeer >= 1 && (cbAddr = input.readInt()) > 0) {
                byte[] abAddr = new byte[cbAddr];
                input.read(abAddr);
                int nPort = input.readInt();
                this.setExternalAddress(new InetSocketAddress(InetAddress.getByAddress(abAddr), nPort));
            }
        }
        this.ensureEOS(input);
    }

    public void setAnnounceProtocolVersion(int nVersion) {
        if ((nVersion & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("version exceeds max bit width");
        }
        this.__m_AnnounceProtocolVersion = nVersion;
    }

    protected static void setLastTraceMillis(long lMillis) {
        __s_LastTraceMillis = lMillis;
    }

    public void setPrevRecvTimestamp(long cMillis) {
        this.__m_PrevRecvTimestamp = cMillis;
    }

    public void setPrevSentTimestamp(long cMillis) {
        this.__m_PrevSentTimestamp = cMillis;
    }

    protected void setThisRecvTimestamp(long ldt) {
        this.__m_ThisRecvTimestamp = ldt;
    }

    public void setThisSentTimestamp(long cMillis) {
        this.__m_ThisSentTimestamp = cMillis;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        long lMillis = ((ClusterService)this.getService()).getTimestamp();
        this.setThisSentTimestamp(lMillis);
        long ldtPrevSent = this.getPrevSentTimestamp();
        output.writeLong(ldtPrevSent);
        output.writeLong(this.getPrevRecvTimestamp());
        output.writeLong(this.getThisSentTimestamp());
        output.writeInt(this.getFromMember().getTcpRingPort());
        int nProtoVerPeer = (int)(ldtPrevSent >>> 56);
        if (nProtoVerPeer >= 1) {
            output.write(this.getAnnounceProtocolVersion());
            InetSocketAddress addrExternal = this.getExternalAddress();
            if (addrExternal == null) {
                output.writeInt(0);
            } else {
                InetAddress addr = addrExternal.getAddress();
                byte[] abAddr = addr.getAddress();
                output.writeInt(abAddr.length);
                output.write(abAddr);
                output.writeInt(addrExternal.getPort());
            }
        }
    }
}

