/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ClusterService$NewMemberWelcome
extends Message {
    private UUID __m_FromMemberUid;
    private int __m_PreferredPacketLength;
    private int __m_PreferredPort;
    private int __m_ServiceCount;
    private String[] __m_ServiceEndPointName;
    private int[] __m_ServiceId;
    private long[] __m_ServiceJoinTime;
    private Map[] __m_ServiceMemberConfigMap;
    private String[] __m_ServiceName;
    private int[] __m_ServiceState;
    private String[] __m_ServiceType;
    private String[] __m_ServiceVersion;

    public ClusterService$NewMemberWelcome() {
        this(null, null, true);
    }

    public ClusterService$NewMemberWelcome(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(37);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        int cServices = this.getServiceCount();
        sb.append("FromMemberUid=").append(this.getFromMemberUid()).append(", ServiceCount=").append(cServices).append("\nServiceId/ServiceName/ServiceVersion/ServiceEndPoint/ServiceState=[");
        int i = 0;
        while (i < cServices) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getServiceId(i)).append('/').append(this.getServiceName(i)).append('/').append(this.getServiceVersion(i)).append('/').append(this.getServiceEndPointName(i)).append('/').append(ServiceMemberSet.formatJoinTime(this.getServiceJoinTime(i))).append('/').append(ServiceMemberSet.formatStateName(this.getServiceState(i)));
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public UUID getFromMemberUid() {
        return this.__m_FromMemberUid;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public int getPreferredPort() {
        return this.__m_PreferredPort;
    }

    public int getServiceCount() {
        int[] anId = this.getServiceId();
        return anId == null ? 0 : anId.length;
    }

    public String[] getServiceEndPointName() {
        return this.__m_ServiceEndPointName;
    }

    public String getServiceEndPointName(int i) {
        return this.getServiceEndPointName()[i];
    }

    public int[] getServiceId() {
        return this.__m_ServiceId;
    }

    public int getServiceId(int i) {
        return this.getServiceId()[i];
    }

    public long[] getServiceJoinTime() {
        return this.__m_ServiceJoinTime;
    }

    public long getServiceJoinTime(int i) {
        return this.getServiceJoinTime()[i];
    }

    public Map[] getServiceMemberConfigMap() {
        return this.__m_ServiceMemberConfigMap;
    }

    public Map getServiceMemberConfigMap(int i) {
        return this.getServiceMemberConfigMap()[i];
    }

    public String[] getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceName(int i) {
        return this.getServiceName()[i];
    }

    public int[] getServiceState() {
        return this.__m_ServiceState;
    }

    public int getServiceState(int i) {
        return this.getServiceState()[i];
    }

    public String[] getServiceType() {
        return this.__m_ServiceType;
    }

    public String getServiceType(int i) {
        return this.getServiceType()[i];
    }

    public String[] getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public String getServiceVersion(int i) {
        return this.getServiceVersion()[i];
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberWelcome".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberWelcome();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        MasterMemberSet setMembers = service.getClusterMemberSet();
        Member member = this.getFromMember();
        int nMemberId = member.getId();
        Component._assert(this.getFromMemberUid().equals(member.getUid32()));
        member.setPreferredPort(this.getPreferredPort());
        member.setPreferredPacketLength(this.getPreferredPacketLength());
        int cServices = this.getServiceCount();
        if (cServices > 0) {
            ServiceMemberSet setMember;
            ServiceInfo info;
            int[] anServiceId = this.getServiceId();
            String[] asServiceName = this.getServiceName();
            String[] asServiceType = this.getServiceType();
            String[] asServiceVersion = this.getServiceVersion();
            String[] asServiceEndPoint = this.getServiceEndPointName();
            long[] alServiceJoined = this.getServiceJoinTime();
            int[] anServiceState = this.getServiceState();
            Map[] aMapServiceConfig = this.getServiceMemberConfigMap();
            ServiceInfo[] ainfo = new ServiceInfo[cServices];
            int i = 0;
            while (i < cServices) {
                info = service.ensureServiceInfo(anServiceId[i], asServiceName[i], asServiceType[i]);
                ServiceMemberSet serviceMemberSet = setMember = info.getMemberSet();
                synchronized (serviceMemberSet) {
                    if (setMember.add(member)) {
                        setMember.setServiceJoinTime(nMemberId, alServiceJoined[i]);
                        setMember.setServiceEndPointName(nMemberId, asServiceEndPoint[i]);
                        setMember.updateMemberConfigMap(nMemberId, aMapServiceConfig[i]);
                    }
                    String sVersion = asServiceVersion[i];
                    setMember.setServiceVersion(nMemberId, sVersion);
                    if (!(anServiceId[i] == 0) ? false : service.isVersionOlder(sVersion)) {
                        Component._trace(new StringBuilder(String.valueOf("Cluster member ")).append(nMemberId).append(" is running an older Coherence version ").append(setMembers.getServiceVersionExternal(nMemberId)).toString(), 2);
                    }
                }
                ainfo[i] = info;
                ++i;
            }
            i = 0;
            while (i < cServices) {
                info = ainfo[i];
                setMember = info.getMemberSet();
                int nServiceState = anServiceState[i];
                switch (setMember.getState(nMemberId)) {
                    default: {
                        if (nServiceState >= ServiceMemberSet.MEMBER_JOINING) {
                            setMember.setServiceJoining(nMemberId);
                            service.onServiceJoining(info, member);
                        }
                    }
                    case 1: {
                        if (!(nServiceState >= ServiceMemberSet.MEMBER_JOINED)) break;
                        setMember.setServiceJoined(nMemberId);
                        service.onServiceJoined(info, member);
                    }
                    case 2: 
                }
                if (nServiceState >= ServiceMemberSet.MEMBER_LEAVING) {
                    setMember.setServiceLeaving(nMemberId);
                    service.onServiceLeaving(info, member);
                }
                ++i;
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        this.setFromMemberUid(new UUID(input));
        int cServices = input.readUnsignedShort();
        if (cServices > 0) {
            int[] anServiceId = new int[cServices];
            String[] asServiceName = new String[cServices];
            String[] asServiceType = new String[cServices];
            String[] asServiceVersion = new String[cServices];
            String[] asServiceEndPoint = new String[cServices];
            long[] alServiceJoinTime = new long[cServices];
            int[] anServiceState = new int[cServices];
            Map[] aMapServiceConfig = new Map[cServices];
            int i = 0;
            while (i < cServices) {
                anServiceId[i] = input.readUnsignedShort();
                asServiceName[i] = input.readUTF();
                asServiceType[i] = input.readUTF();
                asServiceVersion[i] = input.readUTF();
                asServiceEndPoint[i] = input.readUTF();
                alServiceJoinTime[i] = input.readLong();
                anServiceState[i] = input.readInt();
                aMapServiceConfig[i] = new HashMap();
                ExternalizableHelper.readMap(input, aMapServiceConfig[i], null);
                ++i;
            }
            this.setServiceId(anServiceId);
            this.setServiceName(asServiceName);
            this.setServiceType(asServiceType);
            this.setServiceVersion(asServiceVersion);
            this.setServiceEndPointName(asServiceEndPoint);
            this.setServiceJoinTime(alServiceJoinTime);
            this.setServiceState(anServiceState);
            this.setServiceMemberConfigMap(aMapServiceConfig);
        }
        this.setPreferredPacketLength(input.readInt());
        this.setPreferredPort(input.readInt());
    }

    public void setFromMemberUid(UUID uid) {
        this.__m_FromMemberUid = uid;
    }

    public void setPreferredPacketLength(int cb) {
        this.__m_PreferredPacketLength = cb;
    }

    public void setPreferredPort(int nPort) {
        this.__m_PreferredPort = nPort;
    }

    public void setServiceCount(int c) {
        Map[] aMapOld;
        int cOldMap;
        int[] anOldState;
        int cOldState;
        long[] alOldJoined;
        int cOldJoined;
        String[] asOldEndPoint;
        int cOldEndPoints;
        String[] asOldVersion;
        int cOldVersions;
        String[] asOldType;
        int cOldTypes;
        String[] asOldName;
        int cOldNames;
        int[] anOldId = this.getServiceId();
        int cOldIds = anOldId == null ? 0 : anOldId.length;
        if (c != cOldIds) {
            int[] anNewId = new int[c];
            if (cOldIds > 0) {
                System.arraycopy(anOldId, 0, anNewId, 0, Math.min(c, cOldIds));
            }
            this.setServiceId(anNewId);
        }
        if (c != (cOldNames = (asOldName = this.getServiceName()) == null ? 0 : asOldName.length)) {
            String[] asNewName = new String[c];
            if (cOldNames > 0) {
                System.arraycopy(asOldName, 0, asNewName, 0, Math.min(c, cOldNames));
            }
            this.setServiceName(asNewName);
        }
        if (c != (cOldTypes = (asOldType = this.getServiceType()) == null ? 0 : asOldType.length)) {
            String[] asNewType = new String[c];
            if (cOldTypes > 0) {
                System.arraycopy(asOldType, 0, asNewType, 0, Math.min(c, cOldTypes));
            }
            this.setServiceType(asNewType);
        }
        if (c != (cOldVersions = (asOldVersion = this.getServiceVersion()) == null ? 0 : asOldVersion.length)) {
            String[] asNewVersion = new String[c];
            if (cOldVersions > 0) {
                System.arraycopy(asOldVersion, 0, asNewVersion, 0, Math.min(c, cOldVersions));
            }
            this.setServiceVersion(asNewVersion);
        }
        if (c != (cOldEndPoints = (asOldEndPoint = this.getServiceEndPointName()) == null ? 0 : asOldEndPoint.length)) {
            String[] asNewEndPoint = new String[c];
            if (cOldEndPoints > 0) {
                System.arraycopy(asOldEndPoint, 0, asNewEndPoint, 0, Math.min(c, cOldEndPoints));
            }
            this.setServiceEndPointName(asNewEndPoint);
        }
        if (c != (cOldJoined = (alOldJoined = this.getServiceJoinTime()) == null ? 0 : alOldJoined.length)) {
            long[] alNewJoined = new long[c];
            if (cOldJoined > 0) {
                System.arraycopy(alOldJoined, 0, alNewJoined, 0, Math.min(c, cOldJoined));
            }
            this.setServiceJoinTime(alNewJoined);
        }
        if (c != (cOldState = (anOldState = this.getServiceState()) == null ? 0 : anOldState.length)) {
            int[] anNewState = new int[c];
            if (cOldState > 0) {
                System.arraycopy(anOldState, 0, anNewState, 0, Math.min(c, cOldState));
            }
            this.setServiceState(anNewState);
        }
        if (c != (cOldMap = (aMapOld = this.getServiceMemberConfigMap()) == null ? 0 : aMapOld.length)) {
            Map[] aMapNew = new Map[c];
            if (cOldMap > 0) {
                System.arraycopy(aMapOld, 0, aMapNew, 0, Math.min(c, cOldMap));
            }
            this.setServiceMemberConfigMap(aMapNew);
        }
    }

    public void setServiceEndPointName(int i, String sName) {
        this.getServiceEndPointName()[i] = sName;
    }

    public void setServiceEndPointName(String[] asName) {
        this.__m_ServiceEndPointName = asName;
    }

    public void setServiceId(int i, int nId) {
        this.getServiceId()[i] = nId;
    }

    public void setServiceId(int[] anId) {
        this.__m_ServiceId = anId;
    }

    public void setServiceJoinTime(int i, long lJoined) {
        this.getServiceJoinTime()[i] = lJoined;
    }

    public void setServiceJoinTime(long[] alJoined) {
        this.__m_ServiceJoinTime = alJoined;
    }

    public void setServiceMemberConfigMap(int i, Map mapConfig) {
        this.getServiceMemberConfigMap()[i] = mapConfig;
    }

    public void setServiceMemberConfigMap(Map[] amapConfig) {
        this.__m_ServiceMemberConfigMap = amapConfig;
    }

    public void setServiceName(int i, String sName) {
        this.getServiceName()[i] = sName;
    }

    public void setServiceName(String[] asName) {
        this.__m_ServiceName = asName;
    }

    public void setServiceState(int i, int nState) {
        this.getServiceState()[i] = nState;
    }

    public void setServiceState(int[] anState) {
        this.__m_ServiceState = anState;
    }

    public void setServiceType(int i, String sType) {
        this.getServiceType()[i] = sType;
    }

    public void setServiceType(String[] asType) {
        this.__m_ServiceType = asType;
    }

    public void setServiceVersion(int i, String version) {
        this.getServiceVersion()[i] = version;
    }

    public void setServiceVersion(String[] aVersion) {
        this.__m_ServiceVersion = aVersion;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        this.getFromMemberUid().writeExternal(output);
        int cServices = this.getServiceCount();
        output.writeShort(cServices);
        if (cServices > 0) {
            int[] anServiceId = this.getServiceId();
            String[] asServiceName = this.getServiceName();
            String[] asServiceType = this.getServiceType();
            String[] asServiceVersion = this.getServiceVersion();
            String[] asServiceEndPoint = this.getServiceEndPointName();
            long[] alServiceJoinTime = this.getServiceJoinTime();
            int[] anServiceState = this.getServiceState();
            Map[] aMapMemberConfig = this.getServiceMemberConfigMap();
            int i = 0;
            while (i < cServices) {
                output.writeShort(anServiceId[i]);
                output.writeUTF(asServiceName[i]);
                output.writeUTF(asServiceType[i]);
                output.writeUTF(asServiceVersion[i]);
                output.writeUTF(asServiceEndPoint[i]);
                output.writeLong(alServiceJoinTime[i]);
                output.writeInt(anServiceState[i]);
                ExternalizableHelper.writeMap(output, aMapMemberConfig[i]);
                ++i;
            }
        }
        output.writeInt(this.getPreferredPacketLength());
        output.writeInt(this.getPreferredPort());
    }
}

