/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.NonBlocking;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$BusEventMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequestTask;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyConnectionClose;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyConnectionOpen;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceQuiescence;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PingRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.InvocationService$InvocationMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.InvocationService$InvocationRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.InvocationService$InvocationResponse;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocableInOrder;
import com.tangosol.net.InvocationObserver;
import com.tangosol.net.NonBlockingInvocable;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class InvocationService
extends Grid
implements com.tangosol.net.InvocationService {
    private transient Map __m_PendingProcess;
    private static ListMap __mapChildren;

    static {
        InvocationService.__initStatic();
    }

    public InvocationService() {
        this(null, null, true);
    }

    public InvocationService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setPendingProcess(new LiteMap());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setSuspendPollLimit(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid$Guard("Guard", this, true), "Guard");
        this._addChild(new Grid$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid$ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid$ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("BusEventMessage", Grid$BusEventMessage.get_CLASS());
        Class clazz3 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz4 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz5 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz6 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz7 = __mapChildren.put("DispatchEvent", Grid$DispatchEvent.get_CLASS());
        Class clazz8 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz9 = __mapChildren.put("InvocationMessage", InvocationService$InvocationMessage.get_CLASS());
        Class clazz10 = __mapChildren.put("InvocationRequest", InvocationService$InvocationRequest.get_CLASS());
        Class clazz11 = __mapChildren.put("InvocationResponse", InvocationService$InvocationResponse.get_CLASS());
        Class clazz12 = __mapChildren.put("MemberConfigUpdate", Grid$MemberConfigUpdate.get_CLASS());
        Class clazz13 = __mapChildren.put("MemberJoined", Grid$MemberJoined.get_CLASS());
        Class clazz14 = __mapChildren.put("MemberWelcome", Grid$MemberWelcome.get_CLASS());
        Class clazz15 = __mapChildren.put("MemberWelcomeRequest", Grid$MemberWelcomeRequest.get_CLASS());
        Class clazz16 = __mapChildren.put("MemberWelcomeRequestTask", Grid$MemberWelcomeRequestTask.get_CLASS());
        Class clazz17 = __mapChildren.put("NotifyConnectionClose", Grid$NotifyConnectionClose.get_CLASS());
        Class clazz18 = __mapChildren.put("NotifyConnectionOpen", Grid$NotifyConnectionOpen.get_CLASS());
        Class clazz19 = __mapChildren.put("NotifyMemberJoined", Grid$NotifyMemberJoined.get_CLASS());
        Class clazz20 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz21 = __mapChildren.put("NotifyMemberLeft", Grid$NotifyMemberLeft.get_CLASS());
        Class clazz22 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz23 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz24 = __mapChildren.put("NotifyResponse", Grid$NotifyResponse.get_CLASS());
        Class clazz25 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz26 = __mapChildren.put("NotifyServiceJoining", Grid$NotifyServiceJoining.get_CLASS());
        Class clazz27 = __mapChildren.put("NotifyServiceLeaving", Grid$NotifyServiceLeaving.get_CLASS());
        Class clazz28 = __mapChildren.put("NotifyServiceLeft", Grid$NotifyServiceLeft.get_CLASS());
        Class clazz29 = __mapChildren.put("NotifyServiceQuiescence", Grid$NotifyServiceQuiescence.get_CLASS());
        Class clazz30 = __mapChildren.put("NotifyShutdown", Grid$NotifyShutdown.get_CLASS());
        Class clazz31 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz32 = __mapChildren.put("PingRequest", Grid$PingRequest.get_CLASS());
        Class clazz33 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz34 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz35 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    public long drainOverflow(MemberSet setMembers, long cMillis) throws InterruptedException {
        return this.isServiceThread(true) ? cMillis : super.drainOverflow(setMembers, cMillis);
    }

    public void execute(Invocable task, Set setMembers, InvocationObserver observer) {
        long cTimeout;
        Message msgExecute;
        Message msg;
        if (task == null) {
            throw new IllegalArgumentException("Task must be specified");
        }
        if (observer == null) {
            msg = (InvocationService$InvocationMessage)this.instantiateMessage("InvocationMessage");
            ((InvocationService$InvocationMessage)msg).setTask(task);
            msgExecute = msg;
            cTimeout = this.getRequestTimeout();
        } else {
            msg = (InvocationService$InvocationRequest)this.instantiateMessage("InvocationRequest");
            ((InvocationService$InvocationRequest)msg).setTask(task);
            ((InvocationService$InvocationRequest)msg).setQuery(false);
            ((InvocationService$InvocationRequest)msg).setObserver(observer);
            ((InvocationService$InvocationRequest)msg).setRespondInOrder(task instanceof InvocableInOrder ? ((InvocableInOrder)task).isRespondInOrder() : false);
            msgExecute = msg;
            cTimeout = this.calculateRequestTimeout((RequestMessage)msg);
        }
        msgExecute.ensureToMemberSet().addAll((Collection)(setMembers == null ? this.getServiceMemberSet() : setMembers));
        this.send(msgExecute);
        if (NonBlocking.isNonBlockingCaller() ^ true) {
            try {
                this.drainOverflow(msgExecute.getToMemberSet(), cTimeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrapperException(e, "Request interrupted");
            }
        }
    }

    public Map getPendingProcess() {
        return this.__m_PendingProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowedArray getProcessArray(Member member) {
        Map mapPending = this.getPendingProcess();
        WindowedArray waProcess = (WindowedArray)mapPending.get(member);
        if (waProcess == null) {
            InvocationService invocationService = this;
            synchronized (invocationService) {
                waProcess = (WindowedArray)mapPending.get(member);
                if (waProcess == null) {
                    waProcess = new WindowedArray();
                    mapPending.put(member, waProcess);
                }
            }
        }
        return waProcess;
    }

    public String getServiceType() {
        return "Invocation";
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/InvocationService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new InvocationService();
    }

    private final Component get_Module() {
        return this;
    }

    public void onInvocationMessage(InvocationService$InvocationMessage msg) {
        Invocable task = msg.getTask();
        try {
            task.run();
        }
        catch (Throwable e) {
            Component._trace(new StringBuilder(String.valueOf("Failure to execute an Invocable object: ")).append(task).append("\n").append(Component.getStackTrace(e)).toString(), 1);
        }
    }

    public void onInvocationRequest(InvocationService$InvocationRequest msgRequest) {
        block3: {
            Invocable task = msgRequest.getTask();
            try {
                if (task instanceof NonBlockingInvocable) {
                    ((NonBlockingInvocable)task).run(msgRequest);
                    break block3;
                }
                task.run();
                msgRequest.proceed(task.getResult());
            }
            catch (Throwable e) {
                msgRequest.proceed(e);
            }
        }
    }

    public void onNotifyServiceLeft(Member member) {
        super.onNotifyServiceLeft(member);
        this.getPendingProcess().remove(member);
    }

    public void onServiceStarted() {
        DaemonPool pool = this.getDaemonPool();
        if (pool.getDaemonCount() > 0) {
            pool.setThreadGroup(new ThreadGroup(this.getServiceName()));
            pool.start();
        }
        super.onServiceStarted();
    }

    public Map query(Invocable task, Set setMembers) {
        if (task == null) {
            throw new IllegalArgumentException("Task must be specified");
        }
        InvocationService$InvocationRequest msg = (InvocationService$InvocationRequest)this.instantiateMessage("InvocationRequest");
        msg.setTask(task);
        msg.setQuery(true);
        msg.setRespondInOrder(task instanceof InvocableInOrder ? ((InvocableInOrder)task).isRespondInOrder() : false);
        msg.ensureToMemberSet().addAll((Collection)(setMembers == null ? this.getServiceMemberSet() : setMembers));
        return (Map)this.poll(msg);
    }

    public void sendResponse(InvocationService$InvocationRequest msgRequest, InvocationService$InvocationResponse msgResponse) {
        try {
            msgResponse.respondTo(msgRequest);
            this.send(msgResponse);
        }
        catch (Exception e) {
            msgResponse = (InvocationService$InvocationResponse)msgResponse.cloneMessage();
            msgResponse.setException(e);
            msgResponse.respondTo(msgRequest);
            this.send(msgResponse);
        }
    }

    protected void setPendingProcess(Map map) {
        this.__m_PendingProcess = map;
    }
}

