/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.connection.JmsConnection;
import com.tangosol.coherence.component.net.extend.util.JmsUtil;
import com.tangosol.coherence.component.net.extend.util.JndiUtil;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$MessageFactory;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.DefaultJmsAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.JmsAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.LegacyXmlJmsAcceptorHelper;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.WrapperException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.naming.NamingException;

public class JmsAcceptor
extends Acceptor
implements ExceptionListener,
MessageListener {
    private int __m_MessageDeliveryMode;
    private long __m_MessageExpiration;
    private int __m_MessagePriority;
    private QueueConnection __m_QueueConnection;
    private String __m_QueueConnectionFactoryName;
    private Queue __m_QueueDiscovery;
    private String __m_QueueName;
    private QueueReceiver __m_QueueReceiver;
    private QueueSender __m_QueueSender;
    private QueueSession __m_QueueSession;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        JmsAcceptor.__initStatic();
    }

    public JmsAcceptor() {
        this(null, null, true);
    }

    public JmsAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setConnectionPendingSet(new SafeHashSet());
            this.setConnectionSet(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Acceptor$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Peer$Protocol("Protocol", this, true), "Protocol");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", Acceptor$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("javax.jms.Queue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("javax.jms.QueueConnectionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultJmsAcceptorDependencies((JmsAcceptorDependencies)deps);
    }

    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlJmsAcceptorHelper.fromXml(xml, new DefaultJmsAcceptorDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    public String getDescription() {
        String sMode;
        switch (this.getMessageDeliveryMode()) {
            case 2: {
                sMode = "PERSISTENT";
                break;
            }
            case 1: {
                sMode = "NON_PERSISTENT";
                break;
            }
            default: {
                sMode = "UNKNOWN";
            }
        }
        return new StringBuilder(String.valueOf(super.getDescription())).append(", QueueConnectionFactoryName=").append(this.getQueueConnectionFactoryName()).append(", QueueName=").append(this.getQueueName()).append(", MessageExpiration=").append(this.getMessageExpiration()).append(", MessagePriority=").append(this.getMessageDeliveryMode()).append(", MessageDeliveryMode=").append(sMode).toString();
    }

    public int getMessageDeliveryMode() {
        return this.__m_MessageDeliveryMode;
    }

    public long getMessageExpiration() {
        return this.__m_MessageExpiration;
    }

    public int getMessagePriority() {
        return this.__m_MessagePriority;
    }

    public QueueConnection getQueueConnection() {
        return this.__m_QueueConnection;
    }

    public String getQueueConnectionFactoryName() {
        return this.__m_QueueConnectionFactoryName;
    }

    public Queue getQueueDiscovery() {
        return this.__m_QueueDiscovery;
    }

    public String getQueueName() {
        return this.__m_QueueName;
    }

    public QueueReceiver getQueueReceiver() {
        return this.__m_QueueReceiver;
    }

    public QueueSender getQueueSender() {
        return this.__m_QueueSender;
    }

    public QueueSession getQueueSession() {
        return this.__m_QueueSession;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/acceptor/JmsAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new JmsAcceptor();
    }

    private final Component get_Module() {
        return this;
    }

    protected com.tangosol.coherence.component.net.extend.Connection instantiateConnection() {
        JmsConnection connection = new JmsConnection();
        connection.setConnectionManager(this);
        return connection;
    }

    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        JmsAcceptorDependencies jmsDeps = (JmsAcceptorDependencies)deps;
        this.setMessageDeliveryMode(jmsDeps.getMessageDeliveryMode());
        this.setMessageExpiration(jmsDeps.getMessageExpiration());
        this.setMessagePriority(jmsDeps.getMessagePriority());
        this.setQueueConnectionFactoryName(jmsDeps.getQueueConnectionFactoryName());
        this.setQueueName(jmsDeps.getQueueName());
    }

    public void onException(JMSException e) {
        Component._trace(e, new StringBuilder(String.valueOf("Stopping ")).append(this.getServiceName()).append(" due to a fatal JMS exception.").toString());
        this.stop();
    }

    public void onMessage(Message message) {
        QueueSession session = null;
        TemporaryQueue queueIn = null;
        try {
            Destination oQueue = message.getJMSReplyTo();
            if (!(oQueue instanceof Queue)) {
                Component._trace(new StringBuilder(String.valueOf("Received an unexpected peer JMS destination: ")).append(oQueue).toString(), 1);
                return;
            }
            Queue queueOut = (Queue)oQueue;
            queueIn = this.getQueueSession().createTemporaryQueue();
            session = this.getQueueConnection().createQueueSession(false, Session.DUPS_OK_ACKNOWLEDGE);
            JmsConnection jmsConnection = (JmsConnection)this.instantiateConnection();
            jmsConnection.setQueueIn((Queue)queueIn);
            jmsConnection.setQueueOut(queueOut);
            jmsConnection.setQueueSession(session);
            jmsConnection.setMessageDeliveryMode(this.getMessageDeliveryMode());
            jmsConnection.setMessageExpiration(this.getMessageExpiration());
            jmsConnection.setMessagePriority(this.getMessagePriority());
            jmsConnection.open();
            try {
                Message reply = this.getQueueSession().createMessage();
                reply.setJMSCorrelationID(message.getJMSMessageID());
                reply.setJMSDeliveryMode(this.getMessageDeliveryMode());
                reply.setJMSExpiration(this.getMessageExpiration());
                reply.setJMSPriority(this.getMessagePriority());
                reply.setJMSReplyTo((Destination)queueIn);
                this.getQueueSender().send(queueOut, reply);
            }
            catch (JMSException ee) {
                jmsConnection.close(false, new ConnectionException(ee));
                throw ee;
            }
        }
        catch (Throwable e) {
            if (this.isAcceptingConnections()) {
                Component._trace(e, "An error occurred while creating a JmsConnection");
            }
            JmsUtil.close(session);
            JmsUtil.delete(queueIn);
        }
    }

    protected void onServiceStarting() {
        QueueReceiver receiver;
        QueueSession session;
        QueueConnection connection;
        QueueConnectionFactory factory;
        Queue queue;
        super.onServiceStarting();
        try {
            queue = (Queue)JndiUtil.lookup(this.getQueueName(), JmsAcceptor.__sm0());
            this.setQueueDiscovery(queue);
        }
        catch (NamingException e) {
            throw Base.ensureRuntimeException(e, new StringBuilder(String.valueOf("error retrieving a Queue from JNDI")).append(" using the name \"").append(this.getQueueName()).append("\"").toString());
        }
        try {
            factory = (QueueConnectionFactory)JndiUtil.lookup(this.getQueueConnectionFactoryName(), JmsAcceptor.__sm1());
        }
        catch (NamingException e) {
            throw Base.ensureRuntimeException(e, new StringBuilder(String.valueOf("error retrieving a ")).append(" QueueConnectionFactory from JNDI using the name \"").append(this.getQueueConnectionFactoryName()).append("\"").toString());
        }
        try {
            connection = factory.createQueueConnection();
            this.setQueueConnection(connection);
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error creating a QueueConnection");
        }
        try {
            session = connection.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
            this.setQueueSession(session);
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error creating a QueueSession");
        }
        try {
            this.setQueueSender(session.createSender(null));
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error creating a QueueSender");
        }
        try {
            receiver = session.createReceiver(queue);
            this.setQueueReceiver(receiver);
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error creating a QueueReceiver");
        }
        try {
            receiver.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error registering a MessageListener");
        }
        try {
            connection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error registering an ExceptionListener");
        }
        try {
            connection.start();
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error starting a QueueConnection");
        }
        Component._trace(new StringBuilder(String.valueOf("JmsAcceptor now listening for connections on ")).append(this.getQueueName()).toString(), 3);
    }

    protected void onServiceStopped() {
        JmsUtil.close((MessageConsumer)this.getQueueReceiver());
        super.onServiceStopped();
        JmsUtil.close((MessageProducer)this.getQueueSender());
        JmsUtil.close((Session)this.getQueueSession());
        JmsUtil.close((Connection)this.getQueueConnection());
    }

    protected void onServiceStopping() {
        JmsUtil.close((MessageConsumer)this.getQueueReceiver());
        super.onServiceStopping();
    }

    protected void setMessageDeliveryMode(int nMode) {
        this.__m_MessageDeliveryMode = nMode;
    }

    protected void setMessageExpiration(long cMillis) {
        this.__m_MessageExpiration = cMillis;
    }

    protected void setMessagePriority(int nPriority) {
        this.__m_MessagePriority = nPriority;
    }

    protected void setQueueConnection(QueueConnection connection) {
        this.__m_QueueConnection = connection;
    }

    protected void setQueueConnectionFactoryName(String sName) {
        this.__m_QueueConnectionFactoryName = sName;
    }

    protected void setQueueDiscovery(Queue queue) {
        this.__m_QueueDiscovery = queue;
    }

    protected void setQueueName(String sName) {
        this.__m_QueueName = sName;
    }

    protected void setQueueReceiver(QueueReceiver receiver) {
        this.__m_QueueReceiver = receiver;
    }

    protected void setQueueSender(QueueSender sender) {
        this.__m_QueueSender = sender;
    }

    protected void setQueueSession(QueueSession session) {
        this.__m_QueueSession = session;
    }
}

