/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$BufferPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$MessageBuffer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$MessageFactory;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpProcessor;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.DefaultTcpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.LegacyXmlTcpAcceptorHelper;
import com.tangosol.internal.net.service.peer.acceptor.TcpAcceptorDependencies;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.messaging.Message;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class TcpAcceptor
extends Acceptor {
    private Filter __m_AuthorizedHostFilter;
    private transient TcpAcceptor$BufferPool __m_BufferPoolIn;
    private transient TcpAcceptor$BufferPool __m_BufferPoolOut;
    private Queue __m_ConnectionFlushQueue;
    private Queue __m_ConnectionReleaseQueue;
    private long __m_DefaultLimitBytes;
    private int __m_DefaultLimitLength;
    private long __m_DefaultNominalBytes;
    private int __m_DefaultNominalLength;
    private long __m_DefaultSuspectBytes;
    private int __m_DefaultSuspectLength;
    private transient long __m_LastThrottleWarningTimestamp;
    private int __m_ListenBacklog;
    private SocketAddress __m_LocalAddress;
    private SocketAddressProvider __m_LocalAddressProvider;
    private transient TcpAcceptor$TcpProcessor __m_Processor;
    private transient SocketOptions __m_SocketOptions;
    private SocketProvider __m_SocketProvider;
    private SocketProviderFactory __m_SocketProviderFactory;
    private long __m_StatsUnauthorizedConnectionAttempts;
    private boolean __m_SuspectProtocolEnabled;
    private static ListMap __mapChildren;

    static {
        TcpAcceptor.__initStatic();
    }

    public TcpAcceptor() {
        this(null, null, true);
    }

    public TcpAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setConnectionPendingSet(new SafeHashSet());
            this.setConnectionSet(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setDefaultLimitBytes(100000000L);
            this.setDefaultLimitLength(60000);
            this.setDefaultNominalBytes(2000000L);
            this.setDefaultNominalLength(2000);
            this.setDefaultSuspectBytes(10000000L);
            this.setDefaultSuspectLength(10000);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
            this.setSocketOptions(new SocketOptions());
            this.setSuspectProtocolEnabled(true);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Acceptor$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Peer$Protocol("Protocol", this, true), "Protocol");
        this._addChild(new TcpAcceptor$TcpProcessor("TcpProcessor", this, true), "TcpProcessor");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("BufferPool", TcpAcceptor$BufferPool.get_CLASS());
        Class clazz2 = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz3 = __mapChildren.put("MessageBuffer", TcpAcceptor$MessageBuffer.get_CLASS());
        Class clazz4 = __mapChildren.put("MessageFactory", TcpAcceptor$MessageFactory.get_CLASS());
        Class clazz5 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
        Class clazz6 = __mapChildren.put("TcpConnection", TcpAcceptor$TcpConnection.get_CLASS());
    }

    protected WriteBuffer allocateWriteBuffer() {
        return new MultiBufferWriteBuffer(this.getBufferPoolOut());
    }

    protected void bind(ServerSocket socket, SocketAddress addr, int nBacklog) throws IOException {
        socket.bind(addr, nBacklog);
    }

    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultTcpAcceptorDependencies((TcpAcceptorDependencies)deps);
    }

    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlTcpAcceptorHelper.fromXml(xml, new DefaultTcpAcceptorDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    private void configureBufferPool(TcpAcceptor$BufferPool pool, TcpAcceptorDependencies.BufferPoolConfig config) {
        pool.setBufferSize(config.getBufferSize());
        pool.setBufferType(config.getBufferType());
        pool.setCapacity(config.getCapacity());
    }

    public void configureSocket(ServerSocket socket) {
        SocketAddress address;
        try {
            this.getSocketOptions().apply(socket);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "error configuring ServerSocket");
        }
        SocketAddressProvider provider = this.getLocalAddressProvider();
        Exception eLast = null;
        while ((address = provider.getNextAddress()) != null) {
            try {
                this.bind(socket, address, this.getListenBacklog());
                TcpAcceptor.validateLocalAddress(socket.getInetAddress());
                this.setLocalAddress(socket.getLocalSocketAddress());
                provider.accept();
                break;
            }
            catch (Exception e) {
                provider.reject(e);
                eLast = e;
            }
        }
        if (address == null ? true : socket.isBound() ^ true) {
            throw Base.ensureRuntimeException(eLast, new StringBuilder(String.valueOf("Error binding ServerSocket to any of the supplied ports: ")).append(provider).toString());
        }
    }

    public void configureSocket(Socket socket) {
        try {
            this.getSocketOptions().apply(socket);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "error configuring Socket");
        }
    }

    protected void encodeMessage(Message message, WriteBuffer.BufferOutput out, boolean fFilter) throws IOException {
        int i = 0;
        while (i < 5) {
            out.write(0);
            ++i;
        }
        super.encodeMessage(message, out, fFilter);
    }

    public Filter getAuthorizedHostFilter() {
        return this.__m_AuthorizedHostFilter;
    }

    public TcpAcceptor$BufferPool getBufferPoolIn() {
        return this.__m_BufferPoolIn;
    }

    public TcpAcceptor$BufferPool getBufferPoolOut() {
        return this.__m_BufferPoolOut;
    }

    public Queue getConnectionFlushQueue() {
        return this.__m_ConnectionFlushQueue;
    }

    public Queue getConnectionReleaseQueue() {
        return this.__m_ConnectionReleaseQueue;
    }

    public long getDefaultLimitBytes() {
        return this.__m_DefaultLimitBytes;
    }

    public int getDefaultLimitLength() {
        return this.__m_DefaultLimitLength;
    }

    public long getDefaultNominalBytes() {
        return this.__m_DefaultNominalBytes;
    }

    public int getDefaultNominalLength() {
        return this.__m_DefaultNominalLength;
    }

    public long getDefaultSuspectBytes() {
        return this.__m_DefaultSuspectBytes;
    }

    public int getDefaultSuspectLength() {
        return this.__m_DefaultSuspectLength;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer(super.getDescription());
        sb.append(", SocketProvider=").append(this.getSocketProvider());
        sb.append(", LocalAddress=").append(this.getLocalAddressProvider());
        SocketOptions options = this.getSocketOptions();
        if (options != null) {
            sb.append(", ").append(options);
        }
        sb.append(", ListenBacklog=").append(this.getListenBacklog()).append(", BufferPoolIn=").append(this.getBufferPoolIn()).append(", BufferPoolOut=").append(this.getBufferPoolOut());
        return sb.toString();
    }

    public long getLastThrottleWarningTimestamp() {
        return this.__m_LastThrottleWarningTimestamp;
    }

    public int getListenBacklog() {
        return this.__m_ListenBacklog;
    }

    public SocketAddress getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public SocketAddressProvider getLocalAddressProvider() {
        return this.__m_LocalAddressProvider;
    }

    public TcpAcceptor$TcpProcessor getProcessor() {
        TcpAcceptor$TcpProcessor processor = this.__m_Processor;
        if (processor == null) {
            processor = (TcpAcceptor$TcpProcessor)this._findChild("TcpProcessor");
            this.setProcessor(processor);
        }
        return processor;
    }

    public SocketOptions getSocketOptions() {
        return this.__m_SocketOptions;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public SocketProviderFactory getSocketProviderFactory() {
        SocketProviderFactory factory = this.__m_SocketProviderFactory;
        if (factory == null) {
            OperationalContext ctx = this.getOperationalContext();
            factory = ctx == null ? new SocketProviderFactory() : ctx.getSocketProviderFactory();
            this.setSocketProviderFactory(factory);
        }
        return factory;
    }

    public long getStatsUnauthorizedConnectionAttempts() {
        return this.__m_StatsUnauthorizedConnectionAttempts;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpAcceptor();
    }

    private final Component get_Module() {
        return this;
    }

    public Connection instantiateConnection() {
        TcpAcceptor$TcpConnection connection = (TcpAcceptor$TcpConnection)this._newChild("TcpConnection");
        connection.setConnectionManager(this);
        return connection;
    }

    public boolean isAcceptingConnections() {
        return !super.isAcceptingConnections() ? false : this.getBufferPoolOut().getOverflow() <= 0;
    }

    public boolean isAuthorizedHost(InetAddress addr) {
        Filter filterHost = this.getAuthorizedHostFilter();
        if (filterHost == null) {
            return true;
        }
        try {
            if (filterHost.evaluate(addr)) {
                return true;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public boolean isSuspectProtocolEnabled() {
        return this.__m_SuspectProtocolEnabled;
    }

    public void onConnectionClosed(Connection connection) {
        super.onConnectionClosed(connection);
        if (this.get_Connection() == connection) {
            return;
        }
        this.getConnectionReleaseQueue().add(connection);
        this.getProcessor().wakeup();
    }

    public void onConnectionError(Connection connection, Throwable e) {
        super.onConnectionError(connection, e);
        if (this.get_Connection() == connection) {
            return;
        }
        this.getConnectionReleaseQueue().add(connection);
        this.getProcessor().wakeup();
    }

    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        TcpAcceptorDependencies tcpDeps = (TcpAcceptorDependencies)deps;
        ParameterizedBuilder<Filter> bldrFilter = tcpDeps.getAuthorizedHostFilterBuilder();
        if (bldrFilter != null) {
            this.setAuthorizedHostFilter(bldrFilter.realize(new NullParameterResolver(), this.getContextClassLoader(), null));
        }
        this.setDefaultLimitBytes(tcpDeps.getDefaultLimitBytes());
        this.setDefaultLimitLength(tcpDeps.getDefaultLimitMessages());
        this.setDefaultNominalBytes(tcpDeps.getDefaultNominalBytes());
        this.setDefaultNominalLength(tcpDeps.getDefaultNominalMessages());
        this.setDefaultSuspectBytes(tcpDeps.getDefaultSuspectBytes());
        this.setDefaultSuspectLength(tcpDeps.getDefaultSuspectMessages());
        this.setListenBacklog(tcpDeps.getListenBacklog());
        this.setSocketOptions(tcpDeps.getSocketOptions());
        this.setSocketProvider(tcpDeps.getSocketProviderBuilder().realize(null, null, null));
        this.setSuspectProtocolEnabled(tcpDeps.isSuspectProtocolEnabled());
        ParameterizedBuilder<SocketAddressProvider> bldr = tcpDeps.getLocalAddressProviderBuilder();
        if (bldr != null) {
            this.setLocalAddressProvider(bldr.realize(new NullParameterResolver(), this.getContextClassLoader(), null));
        }
        this.configureBufferPool(this.getBufferPoolIn(), tcpDeps.getIncomingBufferPoolConfig());
        this.configureBufferPool(this.getBufferPoolOut(), tcpDeps.getOutgoingBufferPoolConfig());
    }

    protected void onExit() {
        super.onExit();
        this.getProcessor().stop();
    }

    public void onInit() {
        this.setBufferPoolIn((TcpAcceptor$BufferPool)this._newChild("BufferPool"));
        this.setBufferPoolOut((TcpAcceptor$BufferPool)this._newChild("BufferPool"));
        this.setConnectionFlushQueue(new DualQueue());
        this.setConnectionReleaseQueue(new DualQueue());
        this.getBufferPoolIn().setName("Incoming");
        this.getBufferPoolOut().setName("Outgoing");
        super.onInit();
        try {
            SocketOptions options = this.getSocketOptions();
            options.setOption(java.net.SocketOptions.SO_KEEPALIVE, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.TCP_NODELAY, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.SO_LINGER, 0);
        }
        catch (SocketException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void onServiceStarting() {
        super.onServiceStarting();
        TcpAcceptor$TcpProcessor processor = this.getProcessor();
        processor.start();
        Component._trace(new StringBuilder(String.valueOf("TcpAcceptor now listening for connections on ")).append(this.getSocketProvider().getAddressString(processor.getServerSocket())).toString(), 3);
    }

    protected void onServiceStopping() {
        TcpUtil.cancel(this.getProcessor().getServerSocketKey());
        super.onServiceStopping();
    }

    protected void releaseReadBuffer(ReadBuffer rb) {
        Component._assert(rb instanceof TcpAcceptor$MessageBuffer);
        ((TcpAcceptor$MessageBuffer)rb).release();
    }

    protected void releaseWriteBuffer(WriteBuffer wb, Throwable e) {
        Component._assert(wb instanceof MultiBufferWriteBuffer);
        if (!(e == null)) {
            TcpAcceptor$BufferPool pool = this.getBufferPoolOut();
            MultiBufferWriteBuffer mwb = (MultiBufferWriteBuffer)wb;
            int i = 0;
            int c = mwb.getBufferCount();
            while (i < c) {
                pool.release(mwb.getBuffer(i));
                ++i;
            }
        }
    }

    public void resetStats() {
        super.resetStats();
        this.setStatsUnauthorizedConnectionAttempts(0L);
    }

    protected void setAuthorizedHostFilter(Filter filter) {
        this.__m_AuthorizedHostFilter = filter;
    }

    protected void setBufferPoolIn(TcpAcceptor$BufferPool pool) {
        this.__m_BufferPoolIn = pool;
    }

    protected void setBufferPoolOut(TcpAcceptor$BufferPool pool) {
        this.__m_BufferPoolOut = pool;
    }

    protected void setConnectionFlushQueue(Queue queue) {
        this.__m_ConnectionFlushQueue = queue;
    }

    protected void setConnectionReleaseQueue(Queue queue) {
        this.__m_ConnectionReleaseQueue = queue;
    }

    protected void setDefaultLimitBytes(long cb) {
        this.__m_DefaultLimitBytes = cb;
    }

    protected void setDefaultLimitLength(int cMsgs) {
        this.__m_DefaultLimitLength = cMsgs;
    }

    protected void setDefaultNominalBytes(long cb) {
        this.__m_DefaultNominalBytes = cb;
    }

    protected void setDefaultNominalLength(int cMsgs) {
        this.__m_DefaultNominalLength = cMsgs;
    }

    protected void setDefaultSuspectBytes(long cb) {
        this.__m_DefaultSuspectBytes = cb;
    }

    protected void setDefaultSuspectLength(int cMsgs) {
        this.__m_DefaultSuspectLength = cMsgs;
    }

    public void setLastThrottleWarningTimestamp(long ldt) {
        this.__m_LastThrottleWarningTimestamp = ldt;
    }

    protected void setListenBacklog(int cConn) {
        this.__m_ListenBacklog = cConn;
    }

    public void setLocalAddress(SocketAddress addr) {
        this.__m_LocalAddress = addr;
    }

    public void setLocalAddressProvider(SocketAddressProvider pLocalAddressProvider) {
        this.__m_LocalAddressProvider = pLocalAddressProvider;
    }

    protected void setProcessor(TcpAcceptor$TcpProcessor processor) {
        this.__m_Processor = processor;
    }

    protected void setSocketOptions(SocketOptions options) {
        Component._assert(options != null);
        this.__m_SocketOptions = options;
    }

    protected void setSocketProvider(SocketProvider provider) {
        this.__m_SocketProvider = provider;
    }

    public void setSocketProviderFactory(SocketProviderFactory factory) {
        this.__m_SocketProviderFactory = factory;
    }

    public void setStatsUnauthorizedConnectionAttempts(long cMillis) {
        this.__m_StatsUnauthorizedConnectionAttempts = cMillis;
    }

    public void setSuspectProtocolEnabled(boolean pSuspectProtocolEnabled) {
        this.__m_SuspectProtocolEnabled = pSuspectProtocolEnabled;
    }

    protected static void validateLocalAddress(InetAddress addr) {
        if (InetAddressHelper.isLoopbackAddress(addr)) {
            Component._trace(new StringBuilder(String.valueOf("The specified local address \"")).append(addr).append("\" is a loopback address").append("; clients running on remote machines will not be able to connect").append(" to this TcpAcceptor").toString(), 3);
        } else {
            byte[] abAddr = addr.getAddress();
            if (abAddr.length == 16) {
                boolean fSuspect = true;
                List<InetAddress> listLocal = InetAddresses.getAllLocalAddresses();
                Iterator<InetAddress> iter = listLocal.iterator();
                while (iter.hasNext()) {
                    InetAddress addrLocal = iter.next();
                    if (!InetAddressHelper.virtuallyEqual(addrLocal.getAddress(), abAddr)) continue;
                    fSuspect = false;
                    break;
                }
                if (fSuspect) {
                    Component._trace(new StringBuilder(String.valueOf("The local IPv6 address \"")).append(InetAddressHelper.toString(addr)).append("\" does not correspond to any of the local interface addresses; ").append("this address may not be reachable by IPv4-bound nodes").toString(), 2);
                }
            }
        }
    }
}

