/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.connection.TcpConnection;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator$TcpConnection$TcpReader;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class TcpInitiator$TcpConnection
extends TcpConnection {
    private DataInputStream __m_DataInputStream;
    private DataOutputStream __m_DataOutputStream;
    private transient ReentrantLock __m_DataOutputStreamLock;
    private TcpInitiator$TcpConnection$TcpReader __m_Reader;
    private boolean __m_Redirect;
    private List __m_RedirectList;
    private long __m_RequestSendTimeout;
    private static ListMap __mapChildren;

    static {
        TcpInitiator$TcpConnection.__initStatic();
    }

    public TcpInitiator$TcpConnection() {
        this(null, null, true);
    }

    public TcpInitiator$TcpConnection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setChannelArray(new SparseArray());
            this.setChannelPendingArray(new SparseArray());
            this.setDataOutputStreamLock(new ReentrantLock());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("TcpReader", TcpInitiator$TcpConnection$TcpReader.get_CLASS());
    }

    public boolean closeInternal(boolean fNotify, Throwable e, long cMillis) {
        if (super.closeInternal(fNotify, e, cMillis)) {
            DataOutputStream out;
            DataInputStream in;
            TcpInitiator$TcpConnection$TcpReader reader = this.getReader();
            if (reader != null) {
                reader.stop();
                this.setReader(null);
            }
            if ((in = this.getDataInputStream()) != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
                this.setDataInputStream(null);
            }
            if ((out = this.getDataOutputStream()) != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
                this.setDataOutputStream(null);
            }
            TcpUtil.close(this.getSocket());
            return true;
        }
        return false;
    }

    public DataInputStream getDataInputStream() {
        return this.__m_DataInputStream;
    }

    public DataOutputStream getDataOutputStream() {
        return this.__m_DataOutputStream;
    }

    public ReentrantLock getDataOutputStreamLock() {
        return this.__m_DataOutputStreamLock;
    }

    public TcpInitiator$TcpConnection$TcpReader getReader() {
        return this.__m_Reader;
    }

    public List getRedirectList() {
        return this.__m_RedirectList;
    }

    public long getRequestSendTimeout() {
        return this.__m_RequestSendTimeout;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/initiator/TcpInitiator$TcpConnection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpInitiator$TcpConnection();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isRedirect() {
        return this.__m_Redirect;
    }

    public void openInternal() {
        super.openInternal();
        Socket socket = this.getSocket();
        Component._assert(socket != null);
        try {
            this.setDataInputStream(new DataInputStream(new BufferedInputStream(socket.getInputStream(), 5)));
            this.setDataOutputStream(new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 5)));
        }
        catch (IOException e) {
            this.closeInternal(false, e, -1L);
            throw Extend.ensureRuntimeException(e, "error opening connection");
        }
        TcpInitiator$TcpConnection$TcpReader reader = (TcpInitiator$TcpConnection$TcpReader)this._newChild("TcpReader");
        reader.start();
        this.setReader(reader);
    }

    public void send(WriteBuffer wb) throws ConnectionException {
        super.send(wb);
        byte[] ab = ((ByteArrayWriteBuffer)wb).getRawByteArray();
        int cb = wb.length();
        DataOutputStream out = this.getDataOutputStream();
        ReentrantLock lock = this.getDataOutputStreamLock();
        boolean fLock = false;
        long cMillis = this.getRequestSendTimeout();
        try {
            if (cMillis > (long)0) {
                fLock = lock.tryLock(cMillis, TimeUnit.MILLISECONDS);
            } else {
                lock.lockInterruptibly();
                fLock = true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (fLock) {
            try {
                try {
                    ExternalizableHelper.writeInt(out, cb);
                    out.write(ab, 0, cb);
                    out.flush();
                }
                catch (IOException e) {
                    throw new ConnectionException(e, (Connection)this);
                }
                Object var10_11 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                lock.unlock();
                throw throwable;
            }
        }
        throw new RequestTimeoutException(new StringBuilder(String.valueOf("socket write timed out after ")).append(cMillis).toString());
    }

    protected void setDataInputStream(DataInputStream in) {
        this.__m_DataInputStream = in;
    }

    protected void setDataOutputStream(DataOutputStream out) {
        this.__m_DataOutputStream = out;
    }

    protected void setDataOutputStreamLock(ReentrantLock out) {
        this.__m_DataOutputStreamLock = out;
    }

    protected void setReader(TcpInitiator$TcpConnection$TcpReader reader) {
        this.__m_Reader = reader;
    }

    public void setRedirect(boolean f) {
        this.__m_Redirect = f;
    }

    public void setRedirectList(List list) {
        this.__m_RedirectList = list;
    }

    public void setRequestSendTimeout(long ldt) {
        this.__m_RequestSendTimeout = ldt;
    }
}

