/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.ResourceMapping;
import com.tangosol.coherence.config.ResourceMappingRegistry;
import com.tangosol.coherence.config.TopicMapping;
import com.tangosol.util.Base;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class SchemeMappingRegistry
implements ResourceMappingRegistry {
    private final LinkedHashMap<SchemeMappingKey, ResourceMapping> f_mapMappings = new LinkedHashMap();

    @Override
    public Iterator<ResourceMapping> iterator() {
        return this.f_mapMappings.values().iterator();
    }

    @Override
    public void register(ResourceMapping mapping) throws IllegalArgumentException {
        String sName = mapping.getNamePattern();
        Class<CacheMapping> classType = mapping instanceof CacheMapping ? CacheMapping.class : (mapping instanceof TopicMapping ? TopicMapping.class : null);
        SchemeMappingKey key = new SchemeMappingKey(classType, sName);
        if (classType == null) {
            throw new IllegalArgumentException("SchemeMappingRegistry.register: unknown class type: " + mapping.getClass().getCanonicalName());
        }
        if (this.f_mapMappings.containsKey(key)) {
            String sElementName = mapping.getConfigElementName();
            throw new IllegalArgumentException(String.format("Attempted to redefine an existing mapping for <%s>%s</%s>", sElementName, sName, sElementName));
        }
        this.f_mapMappings.put(key, mapping);
        List<ResourceMapping> listMappings = mapping.getSubMappings();
        if (listMappings != null) {
            for (ResourceMapping mappingChild : listMappings) {
                this.register(mappingChild);
            }
        }
    }

    @Override
    public <M extends ResourceMapping> M findMapping(String sName, Class<M> type) {
        ResourceMapping mapping;
        SchemeMappingKey key = new SchemeMappingKey(type, sName);
        if (this.f_mapMappings.containsKey(key)) {
            mapping = this.f_mapMappings.get(key);
        } else {
            mapping = null;
            for (ResourceMapping mappingNext : this.f_mapMappings.values()) {
                if (!type.isAssignableFrom(mappingNext.getClass()) || !mappingNext.isForName(sName)) continue;
                if (mapping == null) {
                    mapping = mappingNext;
                    continue;
                }
                if (mappingNext.getNamePattern().length() <= mapping.getNamePattern().length()) continue;
                mapping = mappingNext;
            }
        }
        if (mapping == null) {
            return null;
        }
        return (M)mapping;
    }

    @Override
    public int size() {
        return this.f_mapMappings.size();
    }

    public static class SchemeMappingKey {
        private final Class<? extends ResourceMapping> f_clz;
        private final String f_sName;

        public SchemeMappingKey(Class<? extends ResourceMapping> clz, String sName) {
            if (clz == null) {
                throw new NullPointerException("SchemeMapping class cannot be null");
            }
            if (sName == null) {
                throw new NullPointerException("SchemeMapping name cannot be null");
            }
            this.f_clz = clz;
            this.f_sName = sName;
        }

        public Class<? extends ResourceMapping> getSchemeMappingClass() {
            return this.f_clz;
        }

        public String getName() {
            return this.f_sName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !Base.equals(this.getClass(), o.getClass())) {
                return false;
            }
            SchemeMappingKey that = (SchemeMappingKey)o;
            return Base.equals(this.f_clz, that.f_clz) && Base.equals(this.f_sName, that.f_sName);
        }

        public int hashCode() {
            int result = this.f_clz.hashCode();
            result = 31 * result + this.f_sName.hashCode();
            return result;
        }
    }
}

