/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.AddressProvider;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.NullImplementation;

public class CustomAddressProviderBuilder
implements AddressProviderBuilder {
    private ParameterizedBuilder<AddressProvider> m_builder;
    private ParameterResolver m_resolver;
    private XmlElement m_xmlConfig = null;

    public CustomAddressProviderBuilder(ParameterizedBuilder<AddressProvider> builder) {
        this(builder, new NullParameterResolver(), null);
    }

    public CustomAddressProviderBuilder(ParameterizedBuilder<AddressProvider> builder, ParameterResolver resolver) {
        this(builder, resolver, null);
    }

    public CustomAddressProviderBuilder(ParameterizedBuilder<AddressProvider> builder, ParameterResolver resolver, XmlElement xmlConfig) {
        this.m_builder = builder;
        this.m_resolver = resolver;
        this.m_xmlConfig = xmlConfig;
    }

    @Override
    public AddressProvider realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        try {
            return this.m_builder == null ? NullImplementation.getAddressProvider() : this.m_builder.realize(resolver == null ? this.m_resolver : resolver, loader, listParameters);
        }
        catch (ClassCastException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("invalid customized AddressProviderBuilder ").append(this.m_builder.getClass().getCanonicalName());
            if (this.m_xmlConfig != null) {
                sb.append(" configured in element <").append(this.m_xmlConfig).append(">");
            }
            throw new ConfigurationException(sb.toString(), "fix configuration to reference a class that returns an AddressProvider", e);
        }
    }

    @Override
    public AddressProvider createAddressProvider(ClassLoader loader) {
        return this.realize(null, loader, null);
    }
}

