/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.SimpleParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderHelper;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.json.bind.annotation.JsonbProperty;

public class InstanceBuilder<T>
implements ParameterizedBuilder<T>,
ParameterizedBuilder.ReflectionSupport,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="exprClassName")
    private Expression<String> m_exprClassName;
    @JsonbProperty(value="constructorParams")
    private ParameterList m_listConstructorParameters;

    public InstanceBuilder() {
        this.m_exprClassName = new LiteralExpression<String>("undefined");
        this.m_listConstructorParameters = new ResolvableParameterList();
    }

    public InstanceBuilder(Class<?> clzToRealize, Object ... aConstructorParameters) {
        this.m_exprClassName = new LiteralExpression<String>(clzToRealize.getName());
        this.m_listConstructorParameters = new SimpleParameterList(aConstructorParameters);
    }

    public InstanceBuilder(Expression<String> exprClassName, Object ... aConstructorParameters) {
        this.m_exprClassName = exprClassName;
        this.m_listConstructorParameters = new SimpleParameterList(aConstructorParameters);
    }

    public InstanceBuilder(String sClassName, Object ... aConstructorParameters) {
        this.m_exprClassName = new LiteralExpression<String>(sClassName);
        this.m_listConstructorParameters = new SimpleParameterList(aConstructorParameters);
    }

    public Expression<String> getClassName() {
        return this.m_exprClassName;
    }

    @Injectable(value="class-name")
    public void setClassName(Expression<String> exprClassName) {
        this.m_exprClassName = exprClassName;
    }

    public ParameterList getConstructorParameterList() {
        return this.m_listConstructorParameters;
    }

    @Injectable(value="init-params")
    public void setConstructorParameterList(ParameterList listParameters) {
        this.m_listConstructorParameters = listParameters;
    }

    @Override
    public T realize(ParameterResolver resolver, ClassLoader loader, ParameterList listConstructorParameters) {
        try {
            loader = Base.ensureClassLoader(loader);
            String sClassName = this.m_exprClassName.evaluate(resolver);
            Class<?> clzClass = loader.loadClass(sClassName);
            ParameterList listParameters = listConstructorParameters == null ? this.m_listConstructorParameters : listConstructorParameters;
            Constructor<?>[] aConstructors = clzClass.getConstructors();
            int cConstructors = aConstructors.length;
            int cConstructorParameters = listParameters.size();
            Object[] aConstructorParameters = cConstructorParameters == 0 ? null : new Object[cConstructorParameters];
            Constructor<?> constructor = null;
            for (int i = 0; i < cConstructors && constructor == null; ++i) {
                if (aConstructors[i].getParameterTypes().length != cConstructorParameters) continue;
                try {
                    Class<?>[] aParameterTypes = aConstructors[i].getParameterTypes();
                    int j = 0;
                    for (Parameter parameter : listParameters) {
                        aConstructorParameters[j] = ParameterizedBuilderHelper.getAssignableValue(aParameterTypes[j], parameter, resolver, loader);
                        ++j;
                    }
                    constructor = aConstructors[i];
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (constructor == null) {
                throw new NoSuchMethodException(String.format("Unable to find a compatible constructor for [%s] with the parameters [%s]", sClassName, listParameters));
            }
            return constructor.newInstance(aConstructorParameters);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public boolean realizes(Class<?> clzClass, ParameterResolver resolver, ClassLoader loader) {
        try {
            loader = Base.ensureClassLoader(loader);
            Class<?> clz = loader.loadClass(this.m_exprClassName.evaluate(resolver));
            return clzClass.isAssignableFrom(clz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        return "InstanceBuilder{className=" + this.m_exprClassName + ", constructorParameters=" + this.m_listConstructorParameters + '}';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_exprClassName = (Expression)ExternalizableHelper.readObject(in, null);
        this.m_listConstructorParameters = (ParameterList)ExternalizableHelper.readObject(in, null);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_exprClassName);
        ExternalizableHelper.writeObject(out, this.m_listConstructorParameters);
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_exprClassName = (Expression)reader.readObject(0);
        this.m_listConstructorParameters = (ParameterList)reader.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.m_exprClassName);
        writer.writeObject(1, this.m_listConstructorParameters);
    }
}

