/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ActionPolicyBuilder;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.ConfigurableQuorumPolicy;
import com.tangosol.run.xml.XmlElement;
import java.util.ArrayList;

public class PartitionedCacheQuorumPolicyBuilder
extends ActionPolicyBuilder {
    private ArrayList<ActionPolicyBuilder.QuorumRule> m_aRules;
    private AddressProviderBuilder m_bldrRecoveryHostAddress;
    private XmlElement m_xmlConfig;

    public PartitionedCacheQuorumPolicyBuilder(AddressProviderBuilder bldrRecoveryHostAddress, XmlElement xmlConfig) {
        this.m_bldrRecoveryHostAddress = bldrRecoveryHostAddress;
        this.m_aRules = new ArrayList(ConfigurableQuorumPolicy.PartitionedCacheQuorumPolicy.ActionRule.values().length);
        this.m_xmlConfig = xmlConfig;
    }

    public void addQuorumRule(String sRuleName, int nRuleMask, int nRuleThreshold) {
        this.m_aRules.add(new ActionPolicyBuilder.QuorumRule(sRuleName, nRuleMask, nRuleThreshold, this.m_xmlConfig));
    }

    @Override
    public ActionPolicy realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) throws ConfigurationException {
        ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule[] rules = new ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule[this.m_aRules.size()];
        int i = 0;
        for (ActionPolicyBuilder.QuorumRule rule : this.m_aRules) {
            rule.validate();
            rules[i] = new ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule(rule.m_nRuleMask, rule.m_nThreshold);
            ++i;
        }
        AddressProvider recoveryHostAddress = this.m_bldrRecoveryHostAddress == null ? null : (AddressProvider)this.m_bldrRecoveryHostAddress.realize(resolver, loader, listParameters);
        return ConfigurableQuorumPolicy.instantiatePartitionedCachePolicy(rules, recoveryHostAddress);
    }
}

