/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder.storemanager;

import com.oracle.coherence.common.util.MemorySize;
import com.tangosol.coherence.config.builder.storemanager.AbstractStoreManagerBuilder;
import com.tangosol.coherence.config.unit.Megabytes;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.CacheFactory;

public abstract class AbstractNioManagerBuilder<T>
extends AbstractStoreManagerBuilder<T> {
    private Expression<Megabytes> m_exprInitialSize = new LiteralExpression<Megabytes>(new Megabytes(1));
    private Expression<Megabytes> m_exprMaxSize = new LiteralExpression<Megabytes>(new Megabytes(1024));

    public long getInitialSize(ParameterResolver resolver) {
        return this.m_exprInitialSize.evaluate(resolver).getByteCount();
    }

    @Injectable
    public void setInitialSize(Expression<Megabytes> expr) {
        this.m_exprInitialSize = expr;
    }

    public long getMaximumSize(ParameterResolver resolver) {
        return this.m_exprMaxSize.evaluate(resolver).getByteCount();
    }

    @Injectable
    public void setMaximumSize(Expression<Megabytes> expr) {
        this.m_exprMaxSize = expr;
    }

    @Override
    protected void validate(ParameterResolver resolver) {
        super.validate(resolver);
        long cbMax = this.getMaximumSize(resolver);
        long cbInit = this.getInitialSize(resolver);
        int cbMaxSize = (int)Math.min(Math.max(cbMax, 1L), 2147482624L);
        int cbInitSize = (int)Math.min(Math.max(cbInit, 1L), (long)cbMaxSize);
        if ((long)cbInitSize != cbInit) {
            CacheFactory.log("Invalid NIO manager initial-size changed to: " + cbInitSize + " bytes", 2);
        }
        if ((long)cbMaxSize != cbMax) {
            CacheFactory.log("Invalid NIO manager maximum-size changed to: " + cbMaxSize + " bytes", 2);
        }
        this.m_exprMaxSize = new LiteralExpression<Megabytes>(new Megabytes(new MemorySize(cbMaxSize, MemorySize.Magnitude.BYTES)));
        this.m_exprInitialSize = new LiteralExpression<Megabytes>(new Megabytes(new MemorySize(cbInitSize, MemorySize.Magnitude.BYTES)));
    }
}

