/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.SimpleParameterList;
import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.scheme.AbstractCompositeScheme;
import com.tangosol.coherence.config.scheme.LocalScheme;
import com.tangosol.coherence.config.scheme.ObservableCachingScheme;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.net.cache.SimpleOverflowMap;
import com.tangosol.util.ObservableMap;
import java.util.Map;

public class OverflowScheme
extends AbstractCompositeScheme {
    private LocalScheme m_schemeMissCache;
    private Expression<Seconds> m_exprExpiryDelay = new LiteralExpression<Seconds>(new Seconds(0));
    private Expression<Boolean> m_exprExpiryEnabled = new LiteralExpression<Boolean>(Boolean.FALSE);

    @Override
    public Map realizeMap(ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
        LocalCache mapMisses;
        ParameterizedBuilder bldrCustom = this.getCustomBuilder();
        ClassLoader loader = dependencies.getClassLoader();
        boolean fExpiryEnabled = this.isExpiryEnabled(resolver);
        ParameterizedBuilder bldrMap = bldrCustom == null ? new InstanceBuilder(OverflowMap.class, new Object[0]) : bldrCustom;
        Map mapFront = this.getFrontScheme().realizeMap(resolver, dependencies);
        Map mapBack = this.getBackScheme().realizeMap(resolver, dependencies);
        LocalCache localCache = mapMisses = this.getMissCacheScheme() == null ? null : this.getMissCacheScheme().realizeMap(resolver, dependencies);
        if (!(mapFront instanceof ObservableMap)) {
            throw new IllegalArgumentException("FrontMap is not observable: " + mapFront.getClass());
        }
        SimpleParameterList listParameters = new SimpleParameterList(mapFront, mapBack);
        Map map = (Map)bldrMap.realize(resolver, loader, listParameters);
        if (SimpleOverflowMap.class.isAssignableFrom(map.getClass()) && mapMisses != null) {
            ((SimpleOverflowMap)map).setMissCache(mapMisses);
        }
        String sCacheName = dependencies.getCacheName();
        if (map instanceof OverflowMap) {
            OverflowMap mapOverflow = (OverflowMap)map;
            mapOverflow.setExpiryEnabled(fExpiryEnabled);
            int cExpiryMillis = (int)this.getExpiryDelay(resolver).as(Duration.Magnitude.MILLI);
            if (cExpiryMillis > 0) {
                mapOverflow.setExpiryDelay(cExpiryMillis);
            }
            if (mapMisses != null) {
                CacheFactory.log("Cache " + sCacheName + " of scheme " + this.getSchemeName() + " has a \"miss-cache-scheme\" configured; since the default OverflowMap implementation has been selected, the miss cache will not be used.", 2);
            }
        } else if (map instanceof SimpleOverflowMap) {
            if (fExpiryEnabled) {
                CacheFactory.log("Cache " + sCacheName + " of scheme " + this.getSchemeName() + " has \"expiry-enabled\" set to true or \"expiry-delay\" configured; these settings will have no effect, and expiry will not work, because the scheme explicitly ues a SimpleOverflowMap.", 2);
            }
            if (mapBack instanceof ObservableMap) {
                CacheFactory.log("Cache " + sCacheName + " of scheme " + this.getSchemeName() + " has a \"back-scheme\" that is observable; the events from the back map will be ignored because the scheme explicitly uses a SimpleOverflowMap, and this could result in missing events if the back map actively expires and/or evicts its entries.", 2);
            }
        } else {
            throw new IllegalArgumentException(bldrCustom + " will not realize a sub-class of either OverflowMap or SimpleOverflowMap");
        }
        return map;
    }

    @Override
    public void establishMapListeners(Map map, ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
        super.establishMapListeners(map, resolver, dependencies);
        if (map instanceof OverflowMap) {
            if (this.getFrontScheme() instanceof ObservableCachingScheme) {
                ((ObservableCachingScheme)this.getFrontScheme()).establishMapListeners(((OverflowMap)map).getFrontMap(), resolver, dependencies);
            }
            if (this.getBackScheme() instanceof ObservableCachingScheme) {
                ((ObservableCachingScheme)this.getBackScheme()).establishMapListeners(((OverflowMap)map).getBackMap(), resolver, dependencies);
            }
        }
        if (map instanceof SimpleOverflowMap) {
            if (this.getFrontScheme() instanceof ObservableCachingScheme) {
                ((ObservableCachingScheme)this.getFrontScheme()).establishMapListeners(((SimpleOverflowMap)map).getFrontMap(), resolver, dependencies);
            }
            if (this.getBackScheme() instanceof ObservableCachingScheme) {
                ((ObservableCachingScheme)this.getBackScheme()).establishMapListeners(((SimpleOverflowMap)map).getBackMap(), resolver, dependencies);
            }
        }
    }

    public Seconds getExpiryDelay(ParameterResolver resolver) {
        return this.m_exprExpiryDelay.evaluate(resolver);
    }

    @Injectable
    public void setExpiryDelay(Expression<Seconds> expr) {
        this.m_exprExpiryDelay = expr;
    }

    public boolean isExpiryEnabled(ParameterResolver resolver) {
        return this.m_exprExpiryEnabled.evaluate(resolver);
    }

    @Injectable
    public void setExpiryEnabled(Expression<Boolean> expr) {
        this.m_exprExpiryEnabled = expr;
    }

    public LocalScheme getMissCacheScheme() {
        return this.m_schemeMissCache;
    }

    @Injectable(value="miss-cache-scheme")
    public void setMissCacheScheme(LocalScheme scheme) {
        this.m_schemeMissCache = scheme;
    }
}

