/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.MemorySize;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.builder.UnitCalculatorBuilder;
import com.tangosol.coherence.config.scheme.BackingMapScheme;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.DistributedScheme;
import com.tangosol.coherence.config.scheme.LocalScheme;
import com.tangosol.coherence.config.scheme.NamedTopicScheme;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.injection.SimpleInjector;
import com.tangosol.internal.net.topic.impl.paged.Configuration;
import com.tangosol.internal.net.topic.impl.paged.PagedTopic;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.Service;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ResourceResolver;
import com.tangosol.util.ResourceResolverHelper;
import java.util.List;

public class PagedTopicScheme
extends DistributedScheme
implements NamedTopicScheme {
    private static final ParameterResolver NULL_PARAMETER_RESOLVER = new NullParameterResolver();
    public static final String DEFAULT_SERVICE_NAME = "DistributedTopic";
    private Expression<MemorySize> m_exprPageSize = new LiteralExpression<MemorySize>(new MemorySize(0x100000L));
    private Expression<MemorySize> m_exprHighUnits = new LiteralExpression<MemorySize>(new MemorySize(0L));
    private Expression<Boolean> m_exprTransient = new LiteralExpression<Boolean>(Boolean.FALSE);
    private Expression<String> m_exprStorageAccessAuthorizer = null;
    private CachingScheme m_schemeBackingMap;
    private Expression<Boolean> m_exprRetainConsumed = new LiteralExpression<Boolean>(Boolean.FALSE);
    private Expression<Seconds> m_exprExpiryDelay = new LiteralExpression<Seconds>(new Seconds(0));

    @Override
    protected String getDefaultServiceName() {
        return DEFAULT_SERVICE_NAME;
    }

    @Override
    public <T extends NamedCollection> boolean realizes(Class<T> type) {
        return NamedTopic.class.equals(type);
    }

    public CachingScheme getStorageScheme(ParameterResolver resolver) {
        if (this.m_schemeBackingMap == null) {
            LocalScheme scheme = new LocalScheme();
            scheme.setUnitCalculatorBuilder(this.getUnitCalculatorBuilder(resolver));
            long cbHigh = this.getHighUnits(resolver);
            if (cbHigh >= Integer.MAX_VALUE) {
                scheme.setUnitFactor(r -> 1024);
            }
            this.m_schemeBackingMap = scheme;
        }
        return this.m_schemeBackingMap;
    }

    public CachingScheme getStorageScheme() {
        return this.getStorageScheme(NULL_PARAMETER_RESOLVER);
    }

    @Injectable(value="storage")
    public void setStorageScheme(CachingScheme scheme) {
        this.m_schemeBackingMap = scheme;
    }

    public int getPageSize(ParameterResolver resolver) {
        return (int)this.m_exprPageSize.evaluate(resolver).getByteCount();
    }

    @Injectable(value="page-size")
    public void setPageSize(Expression<MemorySize> expr) {
        this.m_exprPageSize = expr;
    }

    public long getHighUnits(ParameterResolver resolver) {
        return this.m_exprHighUnits.evaluate(resolver).getByteCount();
    }

    @Injectable(value="high-units")
    public void setHighUnits(Expression<MemorySize> expr) {
        this.m_exprHighUnits = expr;
    }

    public Expression<Boolean> getTransientExpression() {
        return this.m_exprTransient;
    }

    @Injectable
    public void setTransient(Expression<Boolean> expr) {
        this.m_exprTransient = expr;
    }

    public Expression<String> getStorageAccessAuthorizer() {
        return this.m_exprStorageAccessAuthorizer;
    }

    @Injectable(value="storage-authorizer")
    public void setStorageAccessAuthorizer(Expression<String> exprStorageAccessAuthorizer) {
        this.m_exprStorageAccessAuthorizer = exprStorageAccessAuthorizer;
        BackingMapScheme scheme = this.getBackingMapScheme();
        if (scheme != null) {
            scheme.setStorageAccessAuthorizer(this.m_exprStorageAccessAuthorizer);
        }
    }

    public Seconds getExpiryDelay(ParameterResolver resolver) {
        return this.m_exprExpiryDelay.evaluate(resolver);
    }

    @Injectable
    public void setExpiryDelay(Expression<Seconds> expr) {
        this.m_exprExpiryDelay = expr;
    }

    public boolean isRetainConsumed(ParameterResolver resolver) {
        Boolean fRetain = this.m_exprRetainConsumed.evaluate(resolver);
        return fRetain != null && fRetain != false;
    }

    @Injectable(value="retain-consumed")
    public void setRetainConsumed(Expression<Boolean> expr) {
        this.m_exprRetainConsumed = expr;
    }

    @Override
    @Injectable(value="interceptors")
    public void setEventInterceptorBuilders(List<NamedEventInterceptorBuilder> listBuilders) {
        super.setEventInterceptorBuilders(listBuilders);
    }

    @Override
    public <V> NamedTopic realize(ValueTypeAssertion<V> typeConstraint, ParameterResolver resolver, MapBuilder.Dependencies deps) {
        String sQueueName = deps.getCacheName();
        CacheService service = this.ensureConfiguredService(resolver, deps);
        PagedTopicCaches topicCaches = new PagedTopicCaches(sQueueName, service);
        return new PagedTopic(topicCaches);
    }

    @Override
    public CacheService ensureConfiguredService(ParameterResolver resolver, MapBuilder.Dependencies deps) {
        ClassLoader loader = deps.getClassLoader();
        String sTopicName = PagedTopicCaches.Names.getTopicName(deps.getCacheName());
        CacheService service = this.getOrEnsureService(deps);
        ResourceRegistry registry = service.getResourceRegistry();
        Configuration configuration = registry.getResource(Configuration.class, sTopicName);
        if (configuration == null) {
            configuration = this.createConfiguration(resolver, loader);
            registry.registerResource(Configuration.class, sTopicName, configuration);
        }
        return service;
    }

    private CacheService getOrEnsureService(MapBuilder.Dependencies deps) {
        ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)deps.getConfigurableCacheFactory();
        Service service = CacheFactory.getCluster().getService(this.getScopedServiceName());
        if (service == null) {
            service = eccf.ensureService(this);
        }
        if (service instanceof CacheService) {
            return (CacheService)service;
        }
        throw new IllegalArgumentException("Error: the configured service " + service.getInfo().getServiceName() + " is not a CacheService");
    }

    public Configuration createConfiguration(ParameterResolver resolver, ClassLoader loader) {
        int nMaxBatchSizeBytes;
        Cluster cluster;
        int nMTU;
        SimpleInjector injector = new SimpleInjector();
        ResourceResolver resourceResolver = ResourceResolverHelper.resourceResolverFrom(PagedTopicScheme.class, this);
        injector.inject(this, ResourceResolverHelper.resourceResolverFrom(resourceResolver, resourceResolver));
        long cbServer = this.getHighUnits(resolver);
        int cbPage = this.getPageSize(resolver);
        long expiryDelayMillis = 0L;
        Seconds expiryDelaySeconds = this.getExpiryDelay(resolver);
        boolean fRetainConsumed = this.isRetainConsumed(resolver);
        if (expiryDelaySeconds != null) {
            expiryDelayMillis = expiryDelaySeconds.as(Duration.Magnitude.MILLI);
        }
        if ((nMTU = InetAddresses.getLocalMTU((cluster = CacheFactory.getCluster()).getLocalMember().getAddress())) == 0) {
            nMTU = 1500;
        }
        try {
            nMaxBatchSizeBytes = Math.multiplyExact(nMTU, cluster.getDependencies().getPublisherCloggedCount());
        }
        catch (ArithmeticException e) {
            nMaxBatchSizeBytes = Integer.MAX_VALUE;
        }
        Configuration configuration = new Configuration();
        configuration.setServerCapacity(cbServer);
        configuration.setPageCapacity(cbPage);
        configuration.setElementExpiryMillis(expiryDelayMillis);
        configuration.setMaxBatchSizeBytes(Math.min(cbPage, nMaxBatchSizeBytes));
        configuration.setRetainConsumed(fRetainConsumed);
        CacheFactory.log("PagedTopicScheme configuration: " + configuration, 6);
        return configuration;
    }

    private UnitCalculatorBuilder getUnitCalculatorBuilder(ParameterResolver resolver) {
        UnitCalculatorBuilder bldr = new UnitCalculatorBuilder();
        Parameter parm = resolver.resolve("unit-calculator");
        LiteralExpression<String> expr = parm == null ? new LiteralExpression<String>("BINARY") : parm.evaluate(resolver).as(Expression.class);
        bldr.setUnitCalculatorType(expr);
        return bldr;
    }
}

