/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.tangosol.coherence.config.scheme.AbstractCompositeScheme;
import com.tangosol.coherence.config.scheme.AbstractScheme;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.ClassScheme;
import com.tangosol.coherence.config.scheme.DistributedScheme;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.service.DefaultViewDependencies;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.net.internal.ScopedServiceReferenceStore;
import com.tangosol.net.internal.ViewCacheService;
import com.tangosol.util.Base;
import java.lang.reflect.Method;

public class ViewScheme
extends AbstractCompositeScheme<ContinuousQueryCache> {
    private static final CachingScheme NO_SCHEME;
    private static final Method SAFE_CLUSTER_GET_SCOPED_SERVICE_STORE;

    public ViewScheme() {
        this.m_serviceDependencies = new DefaultViewDependencies();
        this.setFrontScheme(NO_SCHEME);
        DistributedScheme schemeBack = new DistributedScheme();
        schemeBack.setServiceName(this.getServiceType());
        this.setBackScheme(schemeBack);
    }

    @Override
    public String getScopedServiceName() {
        return "$ViewCacheServiceHandlers-" + super.getScopedServiceName();
    }

    @Override
    public Service realizeService(ParameterResolver resolver, ClassLoader loader, Cluster cluster) {
        this.validate();
        ScopedServiceReferenceStore store = this.getServiceStore(cluster);
        String sServiceName = this.getScopedServiceName();
        Service service = store.getService(sServiceName);
        if (service != null) {
            return service;
        }
        CachingScheme schemeBack = this.getBackScheme();
        if (schemeBack instanceof AbstractScheme) {
            ((AbstractScheme)((Object)schemeBack)).validate();
        }
        CacheService serviceBack = (CacheService)schemeBack.getServiceBuilder().realizeService(resolver, loader, cluster);
        DefaultViewDependencies deps = (DefaultViewDependencies)this.m_serviceDependencies;
        deps.setBackService(serviceBack);
        service = new ViewCacheService(serviceBack);
        service.setDependencies(deps);
        store.putService(service, sServiceName, this.getServiceType());
        return service;
    }

    @Override
    public BackingMapManager realizeBackingMapManager(ConfigurableCacheFactory ccf) {
        return this.getBackScheme().realizeBackingMapManager(ccf);
    }

    @Override
    public String getServiceType() {
        return "ViewCache";
    }

    protected ScopedServiceReferenceStore getServiceStore(Cluster cluster) {
        try {
            return (ScopedServiceReferenceStore)SAFE_CLUSTER_GET_SCOPED_SERVICE_STORE.invoke((Object)cluster, new Object[0]);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Failed to invoke SafeCluster.getScopedReferenceStore()");
        }
    }

    static {
        try {
            Class<?> clzSafeCluster = Class.forName("com.tangosol.coherence.component.util.SafeCluster", false, ViewScheme.class.getClassLoader());
            SAFE_CLUSTER_GET_SCOPED_SERVICE_STORE = clzSafeCluster.getDeclaredMethod("getScopedServiceStore", new Class[0]);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "ViewScheme initialization failed");
        }
        NO_SCHEME = new ClassScheme();
    }
}

