/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.unit;

import com.oracle.coherence.common.util.MemorySize;

public class Units {
    private long m_cUnits;
    private MemorySize m_memorySize;

    public Units(String sValue) {
        try {
            this.m_cUnits = Long.parseLong(sValue);
            this.m_memorySize = null;
        }
        catch (NumberFormatException e) {
            this.m_memorySize = new MemorySize(sValue);
            this.m_cUnits = this.m_memorySize.getByteCount();
        }
    }

    public Units(long cUnits) {
        this.m_cUnits = cUnits;
        this.m_memorySize = null;
    }

    public Units(MemorySize memorySize) {
        this.m_memorySize = memorySize;
        this.m_cUnits = memorySize.getByteCount();
    }

    public long getUnitCount() {
        return this.m_cUnits;
    }

    public MemorySize getMemorySize() {
        return this.m_memorySize;
    }

    public boolean isMemorySize() {
        return this.m_memorySize != null;
    }
}

