/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.preprocessor;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.DocumentElementPreprocessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;

public class ViewSchemePreprocessor
implements DocumentElementPreprocessor.ElementPreprocessor {
    private static final String VIEW_FILTER_ELEMENT = "view-filter";
    private static final String READ_ONLY_ELEMENT = "read-only";
    private static final String TRANSFORMER_ELEMENT = "transformer";
    private static final String RECONNECT_INTERVAL_ELEMENT = "reconnect-interval";
    private static final String VIEW_SCHEME_ELEMENT = "view-scheme";
    private static final String FRONT_SCHEME_ELEMENT = "front-scheme";
    private static final String CONTINUOUS_QUERY_CACHE_SCHEME_ELEMENT = "continuous-query-cache-scheme";
    private static final String LISTENER_ELEMENT = "listener";
    private static final XmlElement DEFAULT_XML = XmlHelper.loadXml("<front-scheme> <continuous-query-cache-scheme>  <view-filter>   <class-scheme>    <class-name>com.tangosol.util.filter.AlwaysFilter</class-name>   </class-scheme>  </view-filter> </continuous-query-cache-scheme></front-scheme>");
    private static final String[] ELEMENTS_TO_MOVE = new String[]{"listener", "read-only", "reconnect-interval", "transformer"};
    public static final ViewSchemePreprocessor INSTANCE = new ViewSchemePreprocessor();

    private ViewSchemePreprocessor() {
    }

    @Override
    public boolean preprocess(ProcessingContext context, XmlElement element) throws ConfigurationException {
        boolean fModified = false;
        if (VIEW_SCHEME_ELEMENT.equals(element.getName())) {
            XmlElement xmlViewScheme;
            XmlElement xmlViewFilter = element.getElement(VIEW_FILTER_ELEMENT);
            XmlElement xmlFrontScheme = element.getElement(FRONT_SCHEME_ELEMENT);
            if (xmlViewFilter == null && xmlFrontScheme == null) {
                element.getElementList().add(DEFAULT_XML.clone());
                xmlFrontScheme = element.getElement(FRONT_SCHEME_ELEMENT);
                fModified = true;
            } else if (xmlFrontScheme == null) {
                xmlFrontScheme = XmlHelper.ensureElement(element, FRONT_SCHEME_ELEMENT);
                xmlViewScheme = XmlHelper.ensureElement(xmlFrontScheme, CONTINUOUS_QUERY_CACHE_SCHEME_ELEMENT);
                xmlViewScheme.getElementList().add(xmlViewFilter);
                element.getElementList().remove(xmlViewFilter);
                fModified = true;
            }
            xmlViewScheme = xmlFrontScheme.getElement(CONTINUOUS_QUERY_CACHE_SCHEME_ELEMENT);
            int len = ELEMENTS_TO_MOVE.length;
            for (int i = 0; i < len; ++i) {
                XmlElement elementToMove = element.getElement(ELEMENTS_TO_MOVE[i]);
                if (elementToMove == null) continue;
                xmlViewScheme.getElementList().add(elementToMove);
                element.getElementList().remove(elementToMove);
            }
        }
        return fModified;
    }
}

