/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.xml.processor.ElementProcessorHelper;
import com.tangosol.coherence.http.HttpServer;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.net.service.peer.acceptor.DefaultHttpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.run.xml.XmlElement;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;

@XmlSimpleName(value="http-acceptor")
public class HttpAcceptorDependenciesProcessor
implements ElementProcessor<HttpAcceptorDependencies> {
    @Override
    public HttpAcceptorDependencies process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        DefaultHttpAcceptorDependencies dependencies = new DefaultHttpAcceptorDependencies();
        ParameterizedBuilder<?> bldr = ElementProcessorHelper.processParameterizedBuilder(context, xmlElement);
        if (bldr == null) {
            dependencies.setHttpServer(HttpServer.create());
        } else {
            try {
                ParameterizedBuilder<?> bldrHttpServer = bldr;
                dependencies.setHttpServer(bldrHttpServer.realize(context.getDefaultParameterResolver(), context.getContextClassLoader(), null));
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Invalid <" + xmlElement.getName() + "> declaration.  The specified element doesn't produce a HttpServer as expected in [" + xmlElement + "]", "Please specify a valid <" + xmlElement.getName() + ">");
            }
        }
        HashMap<String, Object> mapConfig = new HashMap<String, Object>();
        Iterator iter = xmlElement.getElements("resource-config");
        while (iter.hasNext()) {
            XmlElement xmlResourceConfig = (XmlElement)iter.next();
            String sContextPath = context.getOptionalProperty("context-path", (Type)((Object)String.class), null, xmlResourceConfig);
            ParameterizedBuilder<?> bldrResourceConfig = ElementProcessorHelper.processParameterizedBuilder(context, xmlResourceConfig);
            if (bldrResourceConfig == null) {
                bldrResourceConfig = new InstanceBuilder("com.tangosol.coherence.rest.server.DefaultResourceConfig", new Object[0]);
            }
            try {
                Class<?> jerseyClz = context.getContextClassLoader().loadClass("org.glassfish.jersey.server.ResourceConfig");
                Object oResourceConfig = bldrResourceConfig.realize(context.getDefaultParameterResolver(), context.getContextClassLoader(), null);
                if (!jerseyClz.isAssignableFrom(oResourceConfig.getClass())) {
                    throw new IllegalArgumentException("<resource-config> is not an instance of " + jerseyClz.getCanonicalName());
                }
                if (sContextPath == null) {
                    ApplicationPath path = oResourceConfig.getClass().getAnnotation(ApplicationPath.class);
                    sContextPath = path == null ? "/" : path.value();
                }
                mapConfig.put(sContextPath, oResourceConfig);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to realize the <resource-config> specified by [" + xmlResourceConfig + "] as the underlying class could not be found", "Please ensure that the class is available on the class path", e);
            }
        }
        if (mapConfig.isEmpty()) {
            ServiceLoader<Application> loaderApps = ServiceLoader.load(Application.class);
            for (Application application : loaderApps) {
                String sPath;
                ApplicationPath annotation = application.getClass().getAnnotation(ApplicationPath.class);
                String string = sPath = annotation == null ? "/" : annotation.value();
                if (sPath.charAt(0) != '/') {
                    sPath = '/' + sPath;
                }
                mapConfig.put(sPath, application);
            }
        }
        dependencies.setResourceConfig(mapConfig);
        context.inject(dependencies, xmlElement);
        return dependencies;
    }
}

