/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.ResourceMapping;
import com.tangosol.coherence.config.TopicMapping;
import com.tangosol.coherence.config.scheme.TopicScheme;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.run.xml.XmlElement;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;

@XmlSimpleName(value="topic-mapping")
public class TopicMappingProcessor
implements ElementProcessor<TopicMapping> {
    private final String f_sNameElementName;
    private final Class<? extends TopicScheme> f_clsScheme;

    public TopicMappingProcessor(String sNameElementName, Class<? extends TopicScheme> clsScheme) {
        this.f_sNameElementName = sNameElementName;
        this.f_clsScheme = clsScheme;
    }

    @Override
    public TopicMapping process(ProcessingContext context, XmlElement element) throws ConfigurationException {
        String sCacheNamePattern = (String)context.getMandatoryProperty(this.f_sNameElementName, (Type)((Object)String.class), element);
        String sSchemeName = (String)context.getMandatoryProperty("scheme-name", (Type)((Object)String.class), element);
        TopicMapping mapping = new TopicMapping(sCacheNamePattern, sSchemeName, this.f_clsScheme);
        context.inject(mapping, element);
        List<ResourceMapping> subMappings = mapping.getSubMappings();
        List list = PagedTopicCaches.Names.values().stream().map(queueCacheNames -> this.createSubMapping(mapping, (PagedTopicCaches.Names<?, ?>)queueCacheNames, sCacheNamePattern, sSchemeName)).collect(Collectors.toList());
        subMappings.addAll(list);
        context.addCookie(TopicMapping.class, mapping);
        context.processForeignElementsOf(element);
        return mapping;
    }

    private CacheMapping createSubMapping(TopicMapping mappingCol, PagedTopicCaches.Names<?, ?> type, String sNamePattern, String sSchemeName) {
        CacheMapping mapping = new CacheMapping(type.cacheNameForTopicName(sNamePattern), sSchemeName);
        mapping.setKeyClassName(type.getKeyClass().getCanonicalName());
        mapping.setValueClassName(type.getValueClass().getCanonicalName());
        mapping.setParameterResolver(mappingCol.getParameterResolver());
        mapping.setInternal(type.isInternal());
        return mapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicMappingProcessor that = (TopicMappingProcessor)o;
        return this.f_sNameElementName.equals(that.f_sNameElementName);
    }

    public int hashCode() {
        return this.f_sNameElementName.hashCode();
    }
}

