/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.internal;

import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.SimpleParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExtractorBuilder;
import com.tangosol.coherence.dslquery.function.FunctionBuilders;
import com.tangosol.coherence.dslquery.internal.PropertyBuilder;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.TermWalker;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class AbstractCoherenceQueryWalker
implements TermWalker {
    protected final CoherenceQueryLanguage f_language;
    protected String m_sAlias = null;
    protected Object m_oResult;
    protected AtomicTerm m_atomicTerm;
    protected final PropertyBuilder f_propertyBuilder;
    protected boolean m_fExtendedLanguage = false;
    protected List m_listBindVars = new ArrayList();
    protected ParameterResolver m_namedBindVars;
    protected final Term f_termKeyFunction;

    protected AbstractCoherenceQueryWalker(List listBindVars, ParameterResolver namedBindVars, CoherenceQueryLanguage language) {
        if (listBindVars != null) {
            this.m_listBindVars.addAll(listBindVars);
        }
        if (namedBindVars == null) {
            namedBindVars = new NullParameterResolver();
        }
        this.m_namedBindVars = namedBindVars;
        this.f_language = language;
        this.f_propertyBuilder = new PropertyBuilder();
        this.f_termKeyFunction = Terms.create("callNode(key())", language);
    }

    @Override
    public void acceptNode(String sFunctor, NodeTerm term) {
        String sAlias = this.m_sAlias;
        switch (sFunctor) {
            case "literal": {
                this.acceptLiteral((AtomicTerm)term.termAt(1));
                break;
            }
            case "listNode": {
                this.acceptList(term);
                break;
            }
            case "identifier": {
                String sid;
                if (sAlias != null && sAlias.equals(sid = ((AtomicTerm)term.termAt(1)).getValue())) {
                    this.acceptCall("value", new NodeTerm("value"));
                    return;
                }
                this.acceptIdentifier(((AtomicTerm)term.termAt(1)).getValue());
                break;
            }
            case "binaryOperatorNode": {
                this.acceptBinaryOperator(((AtomicTerm)term.termAt(1)).getValue(), term.termAt(2), term.termAt(3));
                break;
            }
            case "unaryOperatorNode": {
                this.acceptUnaryOperator(((AtomicTerm)term.termAt(1)).getValue(), term.termAt(2));
                break;
            }
            case "bindingNode": {
                String sBindingType = ((AtomicTerm)term.termAt(1)).getValue();
                AtomicTerm atomicTerm = (AtomicTerm)term.termAt(2).termAt(1);
                if ("?".equals(sBindingType)) {
                    this.acceptNumericBinding(atomicTerm.getNumber().intValue());
                    break;
                }
                this.acceptKeyedBinding(atomicTerm.getValue());
                break;
            }
            case "callNode": {
                this.acceptCall(term.termAt(1).getFunctor(), (NodeTerm)term.termAt(1));
                break;
            }
            case "derefNode": {
                AtomicTerm atomicTerm;
                Term termChild;
                if (sAlias != null && "identifier".equals((termChild = term.termAt(1)).getFunctor()) && sAlias.equals((atomicTerm = (AtomicTerm)termChild.termAt(1)).getValue())) {
                    int nTerms = term.length() - 1;
                    if (nTerms == 1) {
                        Term t2 = term.termAt(2);
                        t2.accept(this);
                        return;
                    }
                    Term[] aTerms = new Term[term.length() - 1];
                    System.arraycopy(term.children(), 1, aTerms, 0, term.length() - 1);
                    this.acceptPath(new NodeTerm(sFunctor, aTerms));
                    return;
                }
                this.acceptPath(term);
                break;
            }
            default: {
                throw new RuntimeException("Unknown AST node: " + term.fullFormString());
            }
        }
    }

    @Override
    public void acceptAtom(String sFunctor, AtomicTerm atomicTerm) {
        this.m_oResult = atomicTerm.getObject();
        this.m_atomicTerm = atomicTerm;
    }

    @Override
    public void acceptTerm(String sFunctor, Term term) {
    }

    @Override
    public Object walk(Term term) {
        term.accept(this);
        return this.getResult();
    }

    protected void acceptLiteral(AtomicTerm atom) {
        this.m_oResult = atom.getObject();
        this.m_atomicTerm = atom;
    }

    protected void acceptList(NodeTerm termList) {
    }

    protected void acceptIdentifier(String sIdentifier) {
    }

    protected boolean acceptIdentifierInternal(String sIdentifier) {
        switch (sIdentifier.toLowerCase()) {
            case "null": {
                this.m_oResult = null;
                return true;
            }
            case "true": {
                this.m_oResult = Boolean.TRUE;
                return true;
            }
            case "false": {
                this.m_oResult = Boolean.FALSE;
                return true;
            }
        }
        return false;
    }

    protected void acceptBinaryOperator(String sOperator, Term termLeft, Term termRight) {
    }

    protected void acceptUnaryOperator(String sOperator, Term term) {
    }

    protected void acceptNumericBinding(int iVar) {
        this.m_oResult = this.m_listBindVars.get(iVar - 1);
    }

    protected void acceptKeyedBinding(String sName) {
        Parameter p = this.m_namedBindVars.resolve(sName);
        if (p == null) {
            throw new RuntimeException("Unable to resolve named bind variable: " + sName);
        }
        this.m_oResult = p.evaluate(this.m_namedBindVars).get();
    }

    protected void acceptCall(String sFunctionName, NodeTerm term) {
        ParameterizedBuilder<ReflectionExtractor> functionBuilder = this.f_language.getFunction(sFunctionName);
        if (functionBuilder == null) {
            functionBuilder = FunctionBuilders.METHOD_CALL_FUNCTION_BUILDER;
        }
        ResolvableParameterList resolver = new ResolvableParameterList();
        SimpleParameterList listParameters = new SimpleParameterList();
        resolver.add(new Parameter("functionName", sFunctionName));
        int cTerms = term.length();
        for (int i = 1; i <= cTerms; ++i) {
            term.termAt(i).accept(this);
            listParameters.add(this.m_oResult);
        }
        this.m_oResult = functionBuilder.realize(resolver, null, listParameters);
    }

    protected void acceptPath(NodeTerm term) {
    }

    protected void acceptPathAsChainedExtractor(String sCacheName, NodeTerm nodeTerm) {
        ArrayList<ValueExtractor> listExtractors = new ArrayList<ValueExtractor>();
        StringBuilder sbPath = new StringBuilder();
        int nTarget = 0;
        boolean fIdentifier = true;
        for (Term term : nodeTerm) {
            if (this.f_termKeyFunction.termEqual(term)) {
                nTarget = 1;
                continue;
            }
            boolean bl = fIdentifier = fIdentifier && "identifier".equals(term.getFunctor());
            if (fIdentifier) {
                if (sbPath.length() > 0) {
                    sbPath.append(".");
                }
                sbPath.append(((AtomicTerm)term.termAt(1)).getValue());
                continue;
            }
            term.accept(this);
            listExtractors.add((ValueExtractor)this.getResult());
        }
        if (sbPath.length() == 0 && nTarget == 1) {
            listExtractors.add(0, new KeyExtractor());
        } else if (sbPath.length() > 0) {
            ExtractorBuilder builder = this.f_language.getExtractorBuilder();
            ValueExtractor extractor = builder.realize(sCacheName, nTarget, sbPath.toString());
            listExtractors.add(0, extractor);
        }
        this.m_oResult = this.buildExtractor(listExtractors);
    }

    protected ValueExtractor buildExtractor(List<ValueExtractor> listExtractors) {
        if (listExtractors.size() == 1) {
            return listExtractors.get(0);
        }
        ArrayList<ValueExtractor> list = new ArrayList<ValueExtractor>();
        for (ValueExtractor extractor : listExtractors) {
            if (extractor instanceof ChainedExtractor) {
                list.addAll(Arrays.asList(((ChainedExtractor)extractor).getExtractors()));
                continue;
            }
            list.add(extractor);
        }
        return new ChainedExtractor(list.toArray(new ValueExtractor[list.size()]));
    }

    public void setExtendedLanguage(boolean fExtendedLanguage) {
        this.m_fExtendedLanguage = fExtendedLanguage;
    }

    public void setResult(Object oResult) {
        this.m_oResult = oResult;
    }

    @Override
    public Object getResult() {
        return this.m_oResult;
    }

    protected Object reflectiveMakeObject(boolean fUseNew, Object oExtractor) {
        StringBuilder sb;
        String sName = null;
        StringBuilder sbPath = new StringBuilder();
        ReflectionExtractor extractor = null;
        if (oExtractor instanceof ReflectionExtractor) {
            extractor = (ReflectionExtractor)oExtractor;
        } else if (oExtractor instanceof ChainedExtractor) {
            ChainedExtractor extractorChained = (ChainedExtractor)oExtractor;
            ValueExtractor[] aExtractors = extractorChained.getExtractors();
            for (int i = 0; i < aExtractors.length - 1; ++i) {
                ReflectionExtractor reflectionExtractor = (ReflectionExtractor)aExtractors[i];
                if (sbPath.length() > 0) {
                    sbPath.append('.');
                }
                String sMethodName = reflectionExtractor.getMethodName();
                sbPath.append(this.f_propertyBuilder.plainName(sMethodName));
            }
            extractor = (ReflectionExtractor)aExtractors[aExtractors.length - 1];
        } else if (oExtractor instanceof Object[]) {
            Object[] ao = (Object[])oExtractor;
            for (int i = 0; i < ao.length - 1; ++i) {
                if (sbPath.length() > 0) {
                    sbPath.append('.');
                }
                sbPath.append(ao[i]);
            }
            extractor = (ReflectionExtractor)ao[ao.length - 1];
        }
        String sMethod = extractor.getMethodName();
        Object[] aoArgs = extractor.getParameters();
        try {
            if (fUseNew) {
                sName = sbPath.length() > 0 ? sbPath + "." + sMethod : sMethod;
                Class<?> cls = Class.forName(sName);
                return ClassHelper.newInstance(cls, aoArgs);
            }
            if (this.m_fExtendedLanguage && sMethod.equals(".object.")) {
                sName = sbPath.length() > 0 ? sbPath + "." + aoArgs[0] : (String)aoArgs[0];
                Class<?> cls = Class.forName(sName);
                Object oInstance = ClassHelper.newInstance(cls, new Object[0]);
                if (aoArgs.length != 2) {
                    throw new RuntimeException("Malformed object creation " + sName);
                }
                if (aoArgs[1] instanceof Map) {
                    Map map = (Map)aoArgs[1];
                    for (Map.Entry e : map.entrySet()) {
                        String setter = this.f_propertyBuilder.updaterStringFor((String)e.getKey());
                        ClassHelper.invoke(cls, oInstance, setter, new Object[]{e.getValue()});
                    }
                }
                return oInstance;
            }
            if (sbPath.length() == 0) {
                throw new RuntimeException("Malformed static call " + sMethod);
            }
            sName = sbPath.toString();
            Class<?> cls = Class.forName(sName);
            return ClassHelper.invokeStatic(cls, sMethod, aoArgs);
        }
        catch (InstantiationException e) {
            sb = new StringBuilder(" Unable to instantiate ").append(sName).append(" with ");
            this.append(sb, aoArgs, ", ");
            throw Base.ensureRuntimeException(e, sb.toString());
        }
        catch (NoSuchMethodException e) {
            sb = new StringBuilder("Unable to find method ").append(sMethod).append(" on ").append(sName).append(" with: ");
            this.append(sb, aoArgs, ", ");
            throw Base.ensureRuntimeException(e, sb.toString());
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void append(StringBuilder sb, Object[] aoObjects, String sSeparator) {
        boolean fFirst = true;
        for (Object o : aoObjects) {
            if (!fFirst) {
                sb.append(sSeparator);
                fFirst = false;
            }
            sb.append(o);
        }
    }

    public void setAlias(String sAlias) {
        this.m_sAlias = sAlias;
    }
}

