/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.internal;

import com.tangosol.util.Base;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.CompositeUpdater;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.extractor.ReflectionUpdater;
import java.util.ArrayList;

public class PropertyBuilder {
    protected String m_sPrefixToSuppress = null;

    public PropertyBuilder() {
    }

    public PropertyBuilder(String sPrefix) {
        this.m_sPrefixToSuppress = sPrefix;
    }

    public ValueExtractor extractorFor(String sName) {
        return this.extractorFor(this.splitString(sName, '.'));
    }

    public String extractorStringFor(String sName) {
        return this.uniformStringFor(this.uniformArrayFor(this.splitString(sName, '.'), "get"));
    }

    public String updaterStringFor(String sName) {
        return this.uniformStringFor(this.uniformArrayFor(this.splitString(sName, '.'), "set"));
    }

    public String propertyStringFor(String sName) {
        return this.uniformStringFor(this.uniformArrayFor(this.splitString(sName, '.'), ""));
    }

    public ValueUpdater updaterFor(String sName) {
        return this.updaterFor(this.splitString(sName, '.'));
    }

    public ValueExtractor extractorFor(String[] asProps) {
        String[] asMethodNames = this.uniformArrayFor(asProps, "get");
        if (asMethodNames.length == 1) {
            return new ReflectionExtractor(asMethodNames[0]);
        }
        ValueExtractor[] aExtractors = new ValueExtractor[asMethodNames.length];
        for (int i = 0; i < aExtractors.length; ++i) {
            aExtractors[i] = new ReflectionExtractor(asMethodNames[i]);
        }
        return new ChainedExtractor(aExtractors);
    }

    public ValueUpdater updaterFor(String[] asProps) {
        int nStart = 0;
        int nPartCount = asProps.length;
        String sProp = asProps[nPartCount - 1];
        Base updater = new ReflectionUpdater(this.makeSimpleName("set", sProp));
        if (this.m_sPrefixToSuppress != null && asProps[0].equals(this.m_sPrefixToSuppress)) {
            nStart = 1;
        }
        if (nPartCount - nStart > 1) {
            ValueExtractor[] extractors = new ValueExtractor[nPartCount - nStart - 1];
            for (int i = 0; i < extractors.length; ++i) {
                extractors[i] = new ReflectionExtractor(this.makeSimpleName("get", asProps[i + nStart]));
            }
            updater = new CompositeUpdater(new ChainedExtractor(extractors), (ValueUpdater)((Object)updater));
        }
        return updater;
    }

    public String makeSimpleName(String sPrefix, String sName) {
        if (sName.startsWith(sPrefix)) {
            String sn = sName.substring(sPrefix.length());
            if (sn.length() >= 1 && Character.isUpperCase(sn.charAt(0))) {
                return sName;
            }
            if (sn.length() == 0) {
                return sName;
            }
            return sPrefix + Character.toUpperCase(sn.charAt(0)) + sn.substring(1);
        }
        return sPrefix + sName.substring(0, 1).toUpperCase() + sName.substring(1);
    }

    public String plainName(String sName) {
        if (sName == null || sName.isEmpty()) {
            return sName;
        }
        if (sName.startsWith("set") || sName.startsWith("get")) {
            sName = sName.substring(3);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toLowerCase(sName.charAt(0)));
        if (sName.length() > 1) {
            sb.append(sName.substring(1));
        }
        return sb.toString();
    }

    protected String[] uniformArrayFor(String[] asProps, String sPrefix) {
        int nStart = 0;
        int nPartCount = asProps.length;
        if (this.m_sPrefixToSuppress != null && asProps[0].equals(this.m_sPrefixToSuppress)) {
            nStart = 1;
        }
        String[] aExtractors = new String[nPartCount - nStart];
        for (int i = 0; i < aExtractors.length; ++i) {
            aExtractors[i] = this.makeSimpleName(sPrefix, asProps[i + nStart]);
        }
        return aExtractors;
    }

    protected String uniformStringFor(String[] asParts) {
        if (asParts == null || asParts.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < asParts.length; ++i) {
            sb.append('.').append(asParts[i]);
        }
        return sb.substring(1);
    }

    public String[] splitString(String sName, char delim) {
        if (sName == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int nPrev = -1;
        while (true) {
            int nNext;
            if ((nNext = sName.indexOf(delim, nPrev + 1)) < 0) break;
            list.add(sName.substring(nPrev + 1, nNext));
            nPrev = nNext;
        }
        list.add(sName.substring(nPrev + 1));
        return list.toArray(new String[list.size()]);
    }
}

