/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.queryplus;

import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.QueryPlus;
import com.tangosol.coherence.dslquery.StatementBuilder;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.queryplus.AbstractQueryPlusStatementBuilder;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;

public class CommandsStatementBuilder
extends AbstractQueryPlusStatementBuilder {
    protected final CommandsQueryPlusStatement f_command = new CommandsQueryPlusStatement();

    @Override
    public CommandsQueryPlusStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        return this.f_command;
    }

    @Override
    public String getSyntax() {
        return "COMMANDS";
    }

    @Override
    public String getDescription() {
        return "Print a simple list of commands without explanations.";
    }

    @Override
    public AbstractQueryPlusStatementBuilder.AbstractOPToken instantiateOpToken() {
        return new CommandsOPToken();
    }

    public class CommandsQueryPlusStatement
    extends AbstractQueryPlusStatementBuilder.AbstractStatement {
        public CommandsQueryPlusStatement() {
            super(CommandsStatementBuilder.this);
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            PrintWriter out = ctx.getWriter();
            QueryPlus.DependenciesHelper.usage(out);
            out.println("BYE |  QUIT");
            CoherenceQueryLanguage language = ctx.getCoherenceQueryLanguage();
            Collection<StatementBuilder<?>> colBuilders = language.getStatementBuilders().values();
            for (StatementBuilder<?> builder : colBuilders) {
                out.println(builder.getSyntax());
            }
            return StatementResult.NULL_RESULT;
        }
    }

    public class CommandsOPToken
    extends AbstractQueryPlusStatementBuilder.AbstractOPToken {
        public CommandsOPToken() {
            super(CommandsStatementBuilder.this, "commands", OPToken.IDENTIFIER_NODE, "showCommands");
        }

        @Override
        public Term nud(OPParser parser) {
            return Terms.newTerm(this.getFunctor());
        }
    }
}

