/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.queryplus;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.Statement;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.queryplus.AbstractQueryPlusStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.precedence.OPException;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import java.util.List;
import java.util.StringJoiner;

public class SetTimeoutStatementBuilder
extends AbstractQueryPlusStatementBuilder {
    @Override
    public Statement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        AtomicTerm atomicTerm = (AtomicTerm)term.termAt(1);
        String sTimeout = atomicTerm.getValue();
        if (atomicTerm.getTypeCode() == 7 || sTimeout.isEmpty()) {
            throw new CohQLException("timeout value cannot be null or empty string");
        }
        try {
            Duration timeout = sTimeout.matches("\\d+$") ? new Duration(sTimeout, Duration.Magnitude.MILLI) : new Duration(sTimeout);
            return new SetTimeoutStatement(timeout);
        }
        catch (IllegalArgumentException e) {
            throw new CohQLException("The timeout value of [" + sTimeout + "] is invalid");
        }
    }

    @Override
    public AbstractQueryPlusStatementBuilder.AbstractOPToken instantiateOpToken() {
        return new SetTimeoutOPToken();
    }

    @Override
    public String getSyntax() {
        return "ALTER SESSION SET TIMEOUT <milli-seconds>";
    }

    @Override
    public String getDescription() {
        return "Set the timeout value to be used by the current QueryPlus session. Statements\nwill be interrupted if they take longer than this time to execute.";
    }

    public class SetTimeoutStatement
    extends AbstractQueryPlusStatementBuilder.AbstractStatement {
        protected final Duration f_durationTimeout;

        public SetTimeoutStatement(Duration timeout) {
            this.f_durationTimeout = timeout;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.setTimeout(this.f_durationTimeout);
            return new DefaultStatementResult("CohQL statement timeout set to " + this.f_durationTimeout.toString(true));
        }
    }

    public class SetTimeoutOPToken
    extends AbstractQueryPlusStatementBuilder.AbstractOPToken {
        public SetTimeoutOPToken() {
            super("timeout", OPToken.IDENTIFIER_NODE, "setTimeout");
        }

        @Override
        public Term nud(OPParser parser) {
            OPScanner scanner = parser.getScanner();
            if (scanner.isEndOfStatement()) {
                throw new OPException("Invalid ALTER SESSION SET TIMEOUT statement, timeout value required.");
            }
            StringJoiner joiner = new StringJoiner(" ");
            while (!scanner.isEndOfStatement()) {
                joiner.add(scanner.getCurrentAsStringWithAdvance());
            }
            String sTimeout = joiner.toString();
            return Terms.newTerm(this.getFunctor(), AtomicTerm.createString(sTimeout));
        }
    }
}

