/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.util.MapBackupHelper;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.NullImplementation;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.List;

public class BackupStatementBuilder
extends AbstractStatementBuilder<BackupStatement> {
    public static final BackupStatementBuilder INSTANCE = new BackupStatementBuilder();

    @Override
    public BackupStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = BackupStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for backing up cache");
        }
        String sFile = BackupStatementBuilder.getFile(term);
        if (sFile == null || sFile.isEmpty()) {
            throw new CohQLException("File name needed for backing up cache");
        }
        return new BackupStatement(sCacheName, sFile);
    }

    @Override
    public String getSyntax() {
        return "BACKUP CACHE 'cache-name' [TO] [FILE] 'filename'";
    }

    @Override
    public String getDescription() {
        return "Backup the cache named 'cache-name' to the file named 'filename'.\nWARNING: This backup command should not be used on active data set, as it\nmakes no provisions that ensure data consistency during the backup. Please see\nthe documentation for more detailed information.\nNote: As of Coherence 12.2.1 this command is deprecated. Please use Persistence\ncommand 'CREATE SNAPSHOT' instead.";
    }

    public static class BackupStatement
    extends AbstractStatement {
        protected final String f_sCache;
        protected final String f_sFile;

        public BackupStatement(String sCache, String sFile) {
            this.f_sCache = sCache;
            this.f_sFile = sFile;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            try (RandomAccessFile file = new RandomAccessFile(new File(this.f_sFile), "rw");){
                ConfigurableCacheFactory ccf = ctx.getCacheFactory();
                NamedCache cache = ccf.ensureTypedCache(this.f_sCache, NullImplementation.getClassLoader(), TypeAssertion.withoutTypeChecking());
                MapBackupHelper.writeMap(file, cache);
            }
            catch (IOException e) {
                throw BackupStatement.ensureRuntimeException(e, "Error in BACKUP");
            }
            return StatementResult.NULL_RESULT;
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCache, ctx);
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("ExternalizableHelper.writeMap(new RandomAccessFile(new File(\"%s\"),\"rw\"),CacheFactory.getCache(\"%s\"))", this.f_sFile, this.f_sCache);
        }
    }
}

