/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.SelectListMaker;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.ValueExtractor;
import java.io.PrintWriter;
import java.util.List;

public class CreateIndexStatementBuilder
extends AbstractStatementBuilder<CreateIndexStatement> {
    public static final CreateIndexStatementBuilder INSTANCE = new CreateIndexStatementBuilder();

    @Override
    public CreateIndexStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = CreateIndexStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for create index");
        }
        Term termExtractor = CreateIndexStatementBuilder.getExtractor(term);
        if (termExtractor == null || termExtractor.length() == 0) {
            throw new CohQLException("ValueExtractor(s) needed for create index");
        }
        SelectListMaker transformer = new SelectListMaker(listBindVars, namedBindVars, ctx.getCoherenceQueryLanguage());
        transformer.makeSelectsForCache(sCacheName, (NodeTerm)termExtractor);
        ValueExtractor extractor = transformer.getResultsAsValueExtractor();
        if (extractor == null) {
            throw new CohQLException("ValueExtractor(s) needed for create index");
        }
        return new CreateIndexStatement(sCacheName, extractor);
    }

    @Override
    public String getSyntax() {
        return "(ENSURE | CREATE) INDEX [ON] 'cache-name' value-extractor-list";
    }

    @Override
    public String getDescription() {
        return "Make sure the Index on 'cache-name' that is made from the value-extractor-list\nexists.";
    }

    public static class CreateIndexStatement
    extends AbstractStatement {
        protected final String f_sCache;
        protected final ValueExtractor f_extractor;

        public CreateIndexStatement(String sCache, ValueExtractor extractor) {
            this.f_sCache = sCache;
            this.f_extractor = extractor;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.getCacheFactory().ensureTypedCache(this.f_sCache, null, TypeAssertion.withoutTypeChecking()).addIndex(this.f_extractor, true, null);
            return StatementResult.NULL_RESULT;
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("CacheFactory.getCache(\"%s\")).addIndex(%s, true, null)", this.f_sCache, this.f_extractor);
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCache, ctx);
        }
    }
}

