/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.Filter;
import com.tangosol.util.aggregator.QueryRecorder;
import java.io.PrintWriter;
import java.util.List;

public class QueryRecorderStatementBuilder
extends AbstractStatementBuilder<QueryRecorderStatement> {
    public static final QueryRecorderStatementBuilder EXPLAIN_INSTANCE = new QueryRecorderStatementBuilder(QueryRecorder.RecordType.EXPLAIN);
    public static final QueryRecorderStatementBuilder TRACE_INSTANCE = new QueryRecorderStatementBuilder(QueryRecorder.RecordType.TRACE);
    protected QueryRecorder.RecordType m_recordType;

    protected QueryRecorderStatementBuilder(QueryRecorder.RecordType recordType) {
        this.m_recordType = recordType;
    }

    @Override
    public QueryRecorderStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        NodeTerm termStmt = (NodeTerm)term.termAt(1);
        String sCacheName = QueryRecorderStatementBuilder.getCacheName(termStmt);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for query plan");
        }
        String sAlias = QueryRecorderStatementBuilder.getAlias(termStmt);
        NodeTerm termWhere = QueryRecorderStatementBuilder.getWhere(termStmt);
        Filter filter = QueryRecorderStatementBuilder.ensureFilter(termWhere, sCacheName, sAlias, listBindVars, namedBindVars, ctx);
        return new QueryRecorderStatement(sCacheName, filter, this.m_recordType);
    }

    @Override
    public String getSyntax() {
        if (this.m_recordType == QueryRecorder.RecordType.EXPLAIN) {
            return "SHOW PLAN 'CohQL command' | EXPLAIN PLAN for 'CohQL command'";
        }
        return "TRACE 'CohQL command'";
    }

    @Override
    public String getDescription() {
        if (this.m_recordType == QueryRecorder.RecordType.EXPLAIN) {
            return "Shows what the CohQL command would do rather than executing it.";
        }
        return "Shows what the CohQL command would do rather than executing it.";
    }

    public static class QueryRecorderStatement
    extends AbstractStatement {
        protected final String f_sCacheName;
        protected final Filter f_filter;
        protected final QueryRecorder<Object, Object> f_aggregator;

        public QueryRecorderStatement(String sCacheName, Filter filter, QueryRecorder.RecordType type) {
            this.f_sCacheName = sCacheName;
            this.f_filter = filter;
            this.f_aggregator = new QueryRecorder(type);
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            Object oResult = ctx.getCacheFactory().ensureTypedCache(this.f_sCacheName, null, TypeAssertion.withoutTypeChecking()).aggregate(this.f_filter, this.f_aggregator);
            return new DefaultStatementResult(oResult);
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("CacheFactory.getCache(\"%s\").aggregate(%s, %s)", this.f_sCacheName, this.f_filter, this.f_aggregator);
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCacheName, ctx);
        }
    }
}

