/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.extractor;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ValueExtractor;
import java.lang.reflect.Array;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class OperationExtractor
implements ValueExtractor,
Constants {
    protected final MBeanServer f_mbs;
    protected String m_sMethodName;
    protected char m_chDelim;
    protected Object[] m_aoMethodParamsParams;
    protected String[] m_asParamTypes;

    public OperationExtractor(String sMethodName, char chDelim, Object[] aoMethodParamsParams, String[] asParamTypes) {
        this(sMethodName, chDelim, aoMethodParamsParams, asParamTypes, MBeanHelper.findMBeanServer());
    }

    public OperationExtractor(String sMethodName, char chDelim, Object[] aoMethodParamsParams, String[] asParamTypes, MBeanServer server) {
        this.m_sMethodName = sMethodName;
        this.m_chDelim = chDelim;
        this.m_aoMethodParamsParams = aoMethodParamsParams;
        this.m_asParamTypes = asParamTypes;
        this.f_mbs = server;
    }

    public Object extract(Object oTarget) {
        try {
            ObjectName objectName = (ObjectName)oTarget;
            Object[] aoParams = this.m_aoMethodParamsParams;
            String[] asParamTypes = this.m_asParamTypes;
            Object oResult = this.f_mbs.invoke(objectName, this.m_sMethodName, aoParams, asParamTypes);
            return this.getValueForReportColumn(oResult);
        }
        catch (Exception e) {
            CacheFactory.log("OperationExtractor.extract: handled exception while invoking an MBean operation\nStack trace:" + Base.printStackTrace(e), 1);
            return DEFAULT_VALUE;
        }
    }

    protected Object getValueForReportColumn(Object oResult) {
        char chSubDelim = this.m_chDelim;
        Class<?> clzResult = oResult.getClass();
        String sPrefix = "";
        if (clzResult.isArray()) {
            StringBuilder sb = new StringBuilder();
            int c = Array.getLength(oResult);
            for (int i = 0; i < c; ++i) {
                sb.append(sPrefix).append(Array.get(oResult, i));
                sPrefix = String.valueOf(chSubDelim);
            }
            return sb.toString();
        }
        return oResult;
    }
}

