/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.extractor;

import com.tangosol.util.Base;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import java.util.Date;

public class SubtractExtractor
extends MultiExtractor {
    public SubtractExtractor(ValueExtractor[] aExtractor) {
        super(aExtractor);
        Base.azzert(aExtractor.length == 2, "Report subraction requires two and only two arguments");
    }

    @Override
    public Object extract(Object oTarget) {
        ImmutableArrayList arResults = (ImmutableArrayList)super.extract(oTarget);
        if (arResults.size() > 1) {
            Object o1 = arResults.get(0);
            Object o2 = arResults.get(1);
            if (o1 instanceof Number && o2 instanceof Number) {
                return new Double(((Number)o1).doubleValue() - ((Number)o2).doubleValue());
            }
            if (o1 instanceof Date && o2 instanceof Date) {
                return ((Date)o1).getTime() - ((Date)o2).getTime();
            }
        }
        return null;
    }
}

