/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.expression;

import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import javax.json.bind.annotation.JsonbProperty;

public class ChainedParameterResolver
implements ParameterResolver,
ExternalizableLite,
PortableObject {
    private static final ParameterResolver[] EMPTY_RESOLVER_ARRAY = new ParameterResolver[0];
    @JsonbProperty(value="resolvers")
    private ParameterResolver[] m_aResolvers;

    public ChainedParameterResolver() {
        this.m_aResolvers = new ParameterResolver[1];
    }

    public ChainedParameterResolver(ParameterResolver ... resolvers) {
        for (ParameterResolver resolver : resolvers) {
            if (resolver != null) continue;
            throw new NullPointerException("A null ParameterResolver found. Only non-null ParameterResolvers are permitted");
        }
        this.m_aResolvers = resolvers;
    }

    @Override
    public Parameter resolve(String sName) {
        for (ParameterResolver resolver : this.m_aResolvers) {
            Parameter param = resolver.resolve(sName);
            if (param == null) continue;
            return param;
        }
        return null;
    }

    protected String getDescription() {
        return "Resolvers=" + Arrays.toString(this.m_aResolvers);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int cResolver = ExternalizableHelper.readInt(in);
        Base.azzert(cResolver < 16384, "Unexpected number of parameter resolvers.");
        ParameterResolver[] aResolver = new ParameterResolver[cResolver];
        for (int i = 0; i < cResolver; ++i) {
            aResolver[i] = (ParameterResolver)ExternalizableHelper.readObject(in);
        }
        this.m_aResolvers = aResolver;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ParameterResolver[] aResolver = this.m_aResolvers;
        int cResolver = aResolver.length;
        ExternalizableHelper.writeInt(out, cResolver);
        for (int i = 0; i < cResolver; ++i) {
            ExternalizableHelper.writeObject(out, aResolver[i]);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_aResolvers = (ParameterResolver[])in.readObjectArray(0, EMPTY_RESOLVER_ARRAY);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.m_aResolvers);
    }
}

