/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.injection;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.injection.Injector;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.ResourceResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class SimpleInjector
implements Injector {
    @Override
    public <T> T inject(T object, ResourceResolver resolver) {
        if (object != null && resolver != null) {
            Class<?> clsObject = object.getClass();
            for (Method method : clsObject.getMethods()) {
                Object oResource;
                int modifiers = method.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || method.getParameterTypes().length != 1) continue;
                Class<?> clsResource = method.getParameterTypes()[0];
                Injectable injectable = method.getAnnotation(Injectable.class);
                if (injectable == null) continue;
                String sResourceName = injectable.value().trim();
                if (sResourceName.isEmpty()) {
                    oResource = resolver.getResource(clsResource);
                } else {
                    try {
                        oResource = resolver.getResource(clsResource, sResourceName);
                    }
                    catch (Exception e) {
                        oResource = null;
                        CacheFactory.log(String.format("Failed to lookup resource %s resource-type %s for method %s due to %s", sResourceName, clsResource.getCanonicalName(), method, e), 2);
                    }
                }
                if (oResource == null) continue;
                try {
                    method.invoke(object, oResource);
                }
                catch (Exception e) {
                    CacheFactory.log(String.format("Failed to inject resource %s into %s using method %s due to %s", oResource, object, method, e), 2);
                }
            }
        }
        return object;
    }
}

