/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.xml;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ExpressionParser;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.SystemPropertyParameterResolver;
import com.tangosol.config.xml.DefaultProcessingContext;
import com.tangosol.config.xml.NamespaceHandler;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlDocumentReference;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ResourceRegistry;

public class DocumentProcessor {
    private Dependencies m_dependencies;

    public DocumentProcessor(Dependencies dependencies) {
        this.m_dependencies = dependencies;
    }

    public <T> T process(XmlDocumentReference refDocument, XmlDocumentReference ... aOverrides) throws ConfigurationException {
        XmlDocument xmlDocument = refDocument.getXmlDocument();
        for (XmlDocumentReference refOverride : aOverrides) {
            XmlDocument xmlOverride = refOverride.getXmlDocument();
            XmlHelper.overrideElement(xmlDocument, xmlOverride);
        }
        DefaultProcessingContext context = new DefaultProcessingContext(this.m_dependencies, (XmlElement)xmlDocument);
        NamespaceHandler handler = this.m_dependencies.getDefaultNamespaceHandler();
        if (handler != null) {
            context.ensureNamespaceHandler("", handler);
        }
        Object oResult = context.processDocument(xmlDocument);
        context.terminate();
        return (T)oResult;
    }

    public static class DefaultDependencies
    implements Dependencies {
        private ResourceRegistry m_resourceRegistry = null;
        private ClassLoader m_contextClassLoader = Base.ensureClassLoader(null);
        private ExpressionParser m_exprParser = null;
        private NamespaceHandler m_namespaceHandler = null;
        private ParameterResolver m_parameterResolver = new SystemPropertyParameterResolver();

        public DefaultDependencies() {
        }

        public DefaultDependencies(NamespaceHandler handler) {
            this();
            this.m_namespaceHandler = handler;
        }

        @Override
        public ResourceRegistry getResourceRegistry() {
            return this.m_resourceRegistry;
        }

        @Override
        public ClassLoader getContextClassLoader() {
            return this.m_contextClassLoader;
        }

        @Override
        public NamespaceHandler getDefaultNamespaceHandler() {
            return this.m_namespaceHandler;
        }

        @Override
        public ExpressionParser getExpressionParser() {
            return this.m_exprParser;
        }

        @Override
        public ParameterResolver getDefaultParameterResolver() {
            return this.m_parameterResolver;
        }

        public DefaultDependencies setResourceRegistry(ResourceRegistry registry) {
            this.m_resourceRegistry = registry;
            return this;
        }

        public DefaultDependencies setClassLoader(ClassLoader classLoader) {
            this.m_contextClassLoader = classLoader;
            return this;
        }

        public DefaultDependencies setDefaultNamespaceHandler(NamespaceHandler handler) {
            this.m_namespaceHandler = handler;
            return this;
        }

        public DefaultDependencies setExpressionParser(ExpressionParser parser) {
            this.m_exprParser = parser;
            return this;
        }

        public DefaultDependencies setDefaultParameterResolver(ParameterResolver parameterResolver) {
            this.m_parameterResolver = parameterResolver;
            return this;
        }
    }

    public static interface Dependencies {
        public ResourceRegistry getResourceRegistry();

        public ClassLoader getContextClassLoader();

        public ExpressionParser getExpressionParser();

        public NamespaceHandler getDefaultNamespaceHandler();

        public ParameterResolver getDefaultParameterResolver();
    }
}

