/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.xml;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.AttributeProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlAttribute;
import com.tangosol.run.xml.XmlValue;
import java.lang.reflect.Constructor;

public class SimpleAttributeProcessor<T>
implements AttributeProcessor<T> {
    private Class<T> m_clzAttribute;

    public SimpleAttributeProcessor(Class<T> clzAttribute) {
        this.m_clzAttribute = clzAttribute;
    }

    @Override
    public T process(ProcessingContext context, XmlAttribute attribute) throws ConfigurationException {
        try {
            if (this.m_clzAttribute.isEnum()) {
                String sValue = attribute.getXmlValue().getString();
                try {
                    return Enum.valueOf(this.m_clzAttribute, sValue);
                }
                catch (Exception exception) {
                    throw new ClassCastException(String.format("The specified Enum value '%s' is unknown.", sValue));
                }
            }
            try {
                Constructor<T> constructor = this.m_clzAttribute.getConstructor(XmlAttribute.class);
                return constructor.newInstance(attribute);
            }
            catch (NoSuchMethodException constructor) {
                try {
                    Constructor<T> constructor2 = this.m_clzAttribute.getConstructor(XmlValue.class);
                    return constructor2.newInstance(attribute.getXmlValue());
                }
                catch (NoSuchMethodException constructor2) {
                    try {
                        Constructor<T> constructor3 = this.m_clzAttribute.getConstructor(String.class);
                        return constructor3.newInstance(attribute.getXmlValue().getString());
                    }
                    catch (NoSuchMethodException e) {
                        throw new ConfigurationException(String.format("Can't instantiate the required class [%s] using the attribute [%s]", this.m_clzAttribute, attribute), "The required class does not provide a public single argument constructor for either String, XmlAttribute or XmlValue type values.");
                    }
                }
            }
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ConfigurationException(String.format("Can't instantiate the required class [%s] using the attribute [%s]", this.m_clzAttribute, attribute), "The required class must define a public single argument constructor for String, XmlAttribute or XmlValue type values", exception);
        }
    }
}

