/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.OpBranch;
import java.io.DataOutput;
import java.io.IOException;

public class Case
extends OpBranch
implements Constants,
Comparable {
    private static final String CLASS = "Case";
    private int m_iCase;

    public Case(int iCase, Label label) {
        super(253, label);
        this.m_iCase = iCase;
    }

    @Override
    public String toString() {
        String sName = this.getName();
        String sCase = String.valueOf(this.m_iCase);
        String sLabel = this.getLabel().format();
        return Case.format(null, sName + ' ' + sCase + ' ' + sLabel, null);
    }

    @Override
    public String toJasm() {
        String sName = this.getName();
        String sCase = String.valueOf(this.m_iCase);
        String sLabel = String.valueOf(this.getLabel().getOffset());
        return sName + ' ' + sCase + ": goto " + sLabel;
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        this.setSize(0);
    }

    public int compareTo(Object obj) {
        Case that = (Case)obj;
        int nThis = this.m_iCase;
        int nThat = that.m_iCase;
        return nThis < nThat ? -1 : (nThis > nThat ? 1 : 0);
    }

    public int getCase() {
        return this.m_iCase;
    }
}

