/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Case;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpBranch;
import java.io.DataOutput;
import java.io.IOException;
import java.util.TreeSet;

public abstract class OpSwitch
extends OpBranch
implements Constants {
    private static final String CLASS = "OpSwitch";
    private static final Case[] CASE_ARRAY = new Case[0];
    private int m_iSwitchOp;
    private Case[] m_acase;

    protected OpSwitch(int iOp, Label label) {
        super(iOp, label);
        this.setSwitch(iOp);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        int iOp = this.getSwitch();
        stream.writeByte(iOp);
        int ofOp = this.getOffset();
        int cbPad = 3 - ofOp % 4;
        for (int i = 0; i < cbPad; ++i) {
            stream.writeByte(0);
        }
        int ofDefault = this.getLabel().getOffset() - ofOp;
        stream.writeInt(ofDefault);
        Case[] acase = this.getCases();
        int cCases = acase.length;
        switch (iOp) {
            case 170: {
                if (cCases == 0) {
                    throw new IllegalStateException("OpSwitch.assemble:  TABLESWITCH requires at least one case!");
                }
                int iLow = acase[0].getCase();
                stream.writeInt(iLow);
                int iHigh = acase[cCases - 1].getCase();
                stream.writeInt(iHigh);
                int iCase = 0;
                for (int i = iLow; i <= iHigh; ++i) {
                    Case op = acase[iCase];
                    if (i == op.getCase()) {
                        stream.writeInt(op.getLabel().getOffset() - ofOp);
                        ++iCase;
                        continue;
                    }
                    stream.writeInt(ofDefault);
                }
                break;
            }
            case 171: {
                stream.writeInt(cCases);
                for (int i = 0; i < cCases; ++i) {
                    Case op = acase[i];
                    stream.writeInt(op.getCase());
                    stream.writeInt(op.getLabel().getOffset() - ofOp);
                }
                break;
            }
            default: {
                throw new IllegalStateException("OpSwitch.assemble:  Illegal byte code! (" + iOp + ")");
            }
        }
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        Case[] acase = this.getCases();
        int cCases = acase.length;
        int cbPad = 3 - this.getOffset() % 4;
        int iOp = this.getSwitch();
        switch (iOp) {
            case 170: {
                if (cCases > 1) {
                    cCases = acase[cCases - 1].getCase() - acase[0].getCase() + 1;
                }
                this.setSize(cbPad + 13 + 4 * cCases);
                break;
            }
            case 171: {
                this.setSize(cbPad + 9 + 8 * cCases);
                break;
            }
            default: {
                throw new IllegalStateException("OpSwitch.calculateSize:  Illegal byte code! (" + iOp + ")");
            }
        }
    }

    @Override
    public String toJasm() {
        return this.getName() + " default: goto " + this.getLabel().getOffset();
    }

    protected Case[] getCases() {
        Case[] acase = this.m_acase;
        if (acase == null) {
            TreeSet<Case> setCase = new TreeSet<Case>();
            Op op = this.getNext();
            while (op instanceof Case) {
                Case opCase = (Case)op;
                if (opCase.getLabel() != this.getLabel()) {
                    setCase.add(opCase);
                }
                op = op.getNext();
            }
            acase = setCase.toArray(CASE_ARRAY);
            this.m_acase = acase;
        }
        return acase;
    }

    protected int getSwitch() {
        return this.m_iSwitchOp;
    }

    protected void setSwitch(int iOp) {
        switch (iOp) {
            case 170: 
            case 171: 
            case 252: {
                this.m_iSwitchOp = iOp;
                break;
            }
            default: {
                throw new IllegalArgumentException("OpSwitch.setSwitch:  Illegal op (" + iOp + ")");
            }
        }
    }
}

