/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler;

import com.tangosol.dev.compiler.Colorizer;
import com.tangosol.dev.compiler.Compiler;
import com.tangosol.dev.compiler.Script;
import com.tangosol.dev.compiler.Tokenizer;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.StringTable;
import java.util.Enumeration;
import java.util.Locale;

public abstract class Locator
extends Base {
    private static final Class SCRIPT = Script.class;
    private static final Class TOKENIZER = Tokenizer.class;
    private static final Class COLORIZER = Colorizer.class;
    private static final Class COMPILER = Compiler.class;
    private static StringTable m_tblLanguages = new StringTable();
    private static String m_sDefault;

    public static Enumeration languages() {
        return m_tblLanguages.keys();
    }

    public static void setDefaultLanguage(String sLanguage) {
        if (m_sDefault == null) {
            throw new IllegalArgumentException();
        }
        if (!sLanguage.equals(m_sDefault) && m_tblLanguages.contains(sLanguage)) {
            m_sDefault = sLanguage;
        }
    }

    public static String getDefaultLanguage() {
        return m_sDefault;
    }

    public static void registerLanguage(String sLanguage, Class clzScript, Class clzTokenizer, Class clzColorizer, Class clzCompiler) {
        if (sLanguage == null || sLanguage.length() < 1) {
            throw new IllegalArgumentException();
        }
        if (clzScript == null || clzTokenizer == null || clzColorizer == null || clzCompiler == null) {
            throw new IllegalArgumentException();
        }
        m_tblLanguages.put(sLanguage, new LanguageInfo(sLanguage, clzScript, clzTokenizer, clzColorizer, clzCompiler));
        if (m_sDefault == null) {
            m_sDefault = sLanguage;
        }
    }

    public static boolean registerLanguage(String sLanguage, String sPackage) {
        if (sLanguage == null || sLanguage.length() < 1) {
            return false;
        }
        if (sPackage == null || sPackage.length() < 1) {
            return false;
        }
        try {
            Class<?> clzScript = Class.forName(ClassHelper.getCompositeName(SCRIPT, sPackage));
            Class<?> clzTokenizer = Class.forName(ClassHelper.getCompositeName(TOKENIZER, sPackage));
            Class<?> clzColorizer = Class.forName(ClassHelper.getCompositeName(COLORIZER, sPackage));
            Class<?> clzCompiler = Class.forName(ClassHelper.getCompositeName(COMPILER, sPackage));
            Locator.registerLanguage(sLanguage, clzScript, clzTokenizer, clzColorizer, clzCompiler);
            return true;
        }
        catch (Throwable t) {
            Locator.out(t);
            return false;
        }
    }

    private static boolean registerSystemLanguage(String sLanguage) {
        String sPackage = sLanguage.toLowerCase(Locale.ENGLISH);
        char[] achTest = sPackage.toCharArray();
        int cchTest = achTest.length;
        for (int of = 0; of < cchTest; ++of) {
            if (achTest[of] >= 'a' && achTest[of] <= 'z') continue;
            return false;
        }
        return Locator.registerLanguage(sLanguage, "." + sPackage + ".");
    }

    public static void unregisterLanguage(String sLanguage) {
        if (sLanguage == null || sLanguage.length() < 1) {
            throw new IllegalArgumentException();
        }
        if (sLanguage.equals(m_sDefault)) {
            m_sDefault = null;
        }
        m_tblLanguages.remove(sLanguage);
    }

    private static LanguageInfo getLanguageInfo(String sLanguage) {
        LanguageInfo info;
        if (!m_tblLanguages.contains(sLanguage)) {
            Locator.registerSystemLanguage(sLanguage);
        }
        if ((info = (LanguageInfo)m_tblLanguages.get(sLanguage)) == null) {
            throw new IllegalArgumentException("Unsupported language: \"" + sLanguage + '\"');
        }
        return info;
    }

    public static Script getScript(String sLanguage) {
        try {
            return (Script)Locator.getLanguageInfo((String)sLanguage).clzScript.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException();
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException();
        }
    }

    public static Tokenizer getTokenizer(String sLanguage) {
        try {
            return (Tokenizer)Locator.getLanguageInfo((String)sLanguage).clzTokenizer.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException();
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException();
        }
    }

    public static Colorizer getColorizer(String sLanguage) {
        try {
            return (Colorizer)Locator.getLanguageInfo((String)sLanguage).clzColorizer.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException();
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException();
        }
    }

    public static Compiler getCompiler(String sLanguage) {
        try {
            return (Compiler)Locator.getLanguageInfo((String)sLanguage).clzCompiler.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException();
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException();
        }
    }

    static class LanguageInfo {
        String sLanguage;
        Class clzScript;
        Class clzTokenizer;
        Class clzColorizer;
        Class clzCompiler;

        LanguageInfo(String sLanguage, Class clzScript, Class clzTokenizer, Class clzColorizer, Class clzCompiler) {
            this.sLanguage = sLanguage;
            this.clzScript = clzScript;
            this.clzTokenizer = clzTokenizer;
            this.clzColorizer = clzColorizer;
            this.clzCompiler = clzCompiler;
        }
    }
}

