/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Arraylength;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.Getfield;
import com.tangosol.dev.assembler.Getstatic;
import com.tangosol.dev.assembler.Pop;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.FieldInfo;
import com.tangosol.dev.compiler.TypeInfo;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.SuperExpression;
import com.tangosol.dev.compiler.java.ThisExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.compiler.java.UnaryExpression;
import com.tangosol.dev.compiler.java.VariableExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class FieldAccessExpression
extends UnaryExpression {
    private static final String CLASS = "FieldAccessExpression";
    private static final DataType UNKNOWN = DataType.UNKNOWN;
    private static final DataType OBJECT = DataType.OBJECT;
    private static final DataType INT = DataType.INT;
    private boolean m_fAssignee;
    private FieldInfo m_field;
    private boolean m_fOmitRef;

    public FieldAccessExpression(Token operator, Expression expr, Token tokName) {
        super(operator, expr);
        this.setStartToken(expr.getStartToken());
        this.setEndToken(tokName);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        TypeInfo type;
        boolean fRef;
        Expression expr = this.getExpression();
        String sName = this.getName();
        if (expr instanceof SuperExpression) {
            ((SuperExpression)expr).allowSuper();
        }
        expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        this.setExpression(expr);
        if (expr instanceof TypeExpression) {
            fRef = false;
        } else {
            if (expr instanceof SuperExpression) {
                throw new IllegalStateException();
            }
            expr.checkReference(false, errlist);
            fRef = true;
        }
        DataType dtRef = expr.getType();
        if (dtRef == UNKNOWN) {
            return this;
        }
        if (dtRef.isArray()) {
            if (sName.equals("length")) {
                if (this.isAssignee()) {
                    this.logError(3, "JC-033", new String[]{sName}, errlist);
                }
                this.setType(INT);
                return this;
            }
            dtRef = OBJECT;
        }
        if ((type = ctx.getTypeInfo(dtRef)) == null) {
            String sPkg = "";
            String sType = expr.getType().toString();
            int ofDot = sType.lastIndexOf(46);
            if (ofDot >= 0) {
                sPkg = sType.substring(0, ofDot);
                sType = sType.substring(ofDot + 1);
            }
            expr.logError(3, "JC-055", new String[]{sType, sPkg}, errlist);
            return this;
        }
        FieldInfo field = type.getFieldInfo(sName);
        if (field == null) {
            DataType dt = type.getDataType();
            this.logError(3, "JC-062", new String[]{sName, expr.getType().toString()}, errlist);
            return this;
        }
        if (!field.isStatic() && !fRef) {
            this.logError(3, "JC-063", new String[]{sName}, errlist);
        }
        if (field.isFinal() && this.isAssignee()) {
            this.logError(3, "JC-033", new String[]{sName}, errlist);
        }
        if (field.isViaAccessor() || !field.isAccessible()) {
            this.logError(3, "JC-058", new String[]{sName, expr.getType().toString()}, errlist);
        }
        this.addDependency(field, false);
        this.setType(field.getDataType());
        this.m_field = field;
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        FieldInfo field;
        Expression expr = this.getExpression();
        boolean fStatic = this.isStatic();
        boolean fOmitRef = false;
        if (fStatic && (expr.isConstant() || expr instanceof TypeExpression || expr instanceof VariableExpression || expr instanceof ThisExpression)) {
            fOmitRef = true;
        }
        if (!fOmitRef) {
            expr.compile(ctx, code, fReached, errlist);
            if (fStatic) {
                code.add(new Pop());
            }
        }
        if ((field = this.m_field) == null) {
            if (!this.getName().equals("length")) {
                throw new IllegalStateException();
            }
            code.add(new Arraylength());
        } else if (field.isInlined() || !ctx.isDebug() && field.isInlineable()) {
            super.compile(ctx, code, fReached, errlist);
        } else {
            FieldConstant constant = (FieldConstant)field.getConstant();
            if (fStatic) {
                code.add(new Getstatic(constant));
            } else {
                code.add(new Getfield(constant));
            }
            this.addDependency(field, true);
        }
        return fReached;
    }

    protected void addDependency(FieldInfo field, boolean fRuntime) throws CompilerException {
        Token tokField = this.getEndToken();
        field.addDependency(fRuntime, tokField.getLine(), tokField.getOffset(), tokField.getLine(), tokField.getOffset() + tokField.getLength());
    }

    @Override
    public boolean isConstant() {
        FieldInfo field = this.m_field;
        if (field != null) {
            return field.isInlineable();
        }
        if (this.getType() == INT && this.getName().equals("length")) {
            Expression expr = this.getExpression();
            return expr.isConstant() && expr.getValue() != null;
        }
        return false;
    }

    @Override
    public Object getValue() {
        FieldInfo field = this.m_field;
        if (field == null) {
            return ((Object[])this.getExpression().getValue()).length;
        }
        Object value = field.getValue();
        if (value instanceof Character) {
            value = (int)((Character)value).charValue();
        }
        return value;
    }

    public String getName() {
        return this.getEndToken().getText();
    }

    public boolean isStatic() {
        FieldInfo field = this.m_field;
        return field != null && field.isStatic();
    }

    public FieldConstant getFieldConstant() {
        FieldInfo field = this.m_field;
        return field == null ? null : (FieldConstant)this.m_field.getConstant();
    }

    @Override
    protected boolean checkAssignable(ErrorList errlist) throws CompilerException {
        this.setAssignee(true);
        return true;
    }

    public boolean isAssignee() {
        return this.m_fAssignee;
    }

    protected void setAssignee(boolean fAssignee) {
        this.m_fAssignee = fAssignee;
    }

    @Override
    public String toString() {
        return super.toString() + " field=" + this.getName();
    }
}

