/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dcmpl;
import com.tangosol.dev.assembler.Fcmpl;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.If_icmpgt;
import com.tangosol.dev.assembler.Ifgt;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Lcmp;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.RelationalExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;

public class GreaterExpression
extends RelationalExpression {
    private static final String CLASS = "GreaterExpression";

    public GreaterExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        Label lblTrue = new Label();
        Label lblExit = new Label();
        left.compile(ctx, code, fReached, errlist);
        right.compile(ctx, code, fReached, errlist);
        switch (left.getType().getTypeString().charAt(0)) {
            case 'I': {
                code.add(new If_icmpgt(lblTrue));
                break;
            }
            case 'J': {
                code.add(new Lcmp());
                code.add(new Ifgt(lblTrue));
                break;
            }
            case 'F': {
                code.add(new Fcmpl());
                code.add(new Ifgt(lblTrue));
                break;
            }
            case 'D': {
                code.add(new Dcmpl());
                code.add(new Ifgt(lblTrue));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        code.add(new Iconst(FALSE));
        code.add(new Goto(lblExit));
        code.add(lblTrue);
        code.add(new Iconst(TRUE));
        code.add(lblExit);
        return fReached;
    }

    @Override
    public Object getValue() {
        boolean fVal;
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        Number nbrLeft = (Number)left.getValue();
        Number nbrRight = (Number)right.getValue();
        switch (left.getType().getTypeString().charAt(0)) {
            case 'I': {
                fVal = nbrLeft.intValue() > nbrRight.intValue();
                break;
            }
            case 'J': {
                fVal = nbrLeft.longValue() > nbrRight.longValue();
                break;
            }
            case 'F': {
                fVal = nbrLeft.floatValue() > nbrRight.floatValue();
                break;
            }
            case 'D': {
                fVal = nbrLeft.doubleValue() > nbrRight.doubleValue();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return fVal ? Boolean.TRUE : Boolean.FALSE;
    }
}

