/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.Constants;
import com.tangosol.java.type.ClassType;

public class ComponentType
extends ClassType
implements Constants {
    private String m_sName;

    public ComponentType(String sComponent) {
        super(ComponentType.getComponentClassName(sComponent));
        this.m_sName = sComponent;
    }

    public String getComponentName() {
        return this.m_sName;
    }

    @Override
    public String toString() {
        return this.getComponentName();
    }

    public static String getComponentClassName(Component cd) {
        return ComponentType.getComponentClassName(cd.getQualifiedName());
    }

    public static String getComponentClassName(String sName) {
        return ComponentType.getComponentPackage(sName) + '.' + sName.substring(sName.lastIndexOf(46) + 1);
    }

    public static String getComponentPackage(Component cd) {
        return ComponentType.getComponentPackage(cd.getQualifiedName());
    }

    public static String getComponentPackage(String sName) {
        int ofEnd;
        ComponentType.azzert(Component.isQualifiedNameLegal(sName), "Illegal component name: " + sName);
        String sRelocator = "_package/".replace('/', '.');
        StringBuffer sbPkg = new StringBuffer(sRelocator.length() + sName.length());
        sbPkg.append(sRelocator);
        int ofStart = 0;
        while ((ofEnd = sName.indexOf(46, ofStart)) > 0) {
            sbPkg.append(Character.toLowerCase(sName.charAt(ofStart))).append(sName.substring(ofStart + 1, ofEnd + 1));
            ofStart = ofEnd + 1;
        }
        int iLen = sbPkg.length();
        return iLen > 0 ? sbPkg.substring(0, iLen - 1) : "";
    }

    public static String getComponentName(String sClassName) {
        int ofEnd;
        String sRelocator = "_package/".replace('/', '.');
        if ((sClassName = sClassName.replace('/', '.')).startsWith(sRelocator)) {
            sClassName = sClassName.substring(sRelocator.length());
        }
        StringBuffer sbName = new StringBuffer(sClassName.length());
        int ofStart = 0;
        while ((ofEnd = sClassName.indexOf(46, ofStart)) > 0) {
            sbName.append(Character.toUpperCase(sClassName.charAt(ofStart))).append(sClassName.substring(ofStart + 1, ofEnd + 1));
            ofStart = ofEnd + 1;
        }
        sbName.append(sClassName.substring(ofStart));
        return sbName.toString();
    }
}

