/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.component.Behavior;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.Trait;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ErrorList;
import java.beans.PropertyVetoException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;

public class Implementation
extends Trait {
    public static final String ATTR_LANG = "Language";
    public static final String ATTR_SCRIPT = "Script";
    private static final String CLASS = "Implementation";
    protected static final String DESCRIPTOR = "Script";
    private String m_sLang;
    private String m_sScript;

    protected Implementation(Behavior behavior, String sLang, String sScript) {
        super((Trait)behavior, 1);
        if (behavior == null) {
            throw new IllegalArgumentException("Implementation:  Containing behavior required.");
        }
        if (sLang == null || sLang.length() == 0) {
            throw new IllegalArgumentException("Implementation:  Language identifier required.");
        }
        if (sScript == null || sScript.length() == 0) {
            sScript = "";
        }
        this.m_sLang = sLang;
        this.m_sScript = sScript;
        this.setFromManual();
    }

    protected Implementation(Implementation base, Behavior behavior, int nMode) {
        super((Trait)base, behavior, nMode);
        if (nMode == 2) {
            throw new IllegalArgumentException("Implementation:  Invalid mode for blank Implementation construction (" + nMode + ")");
        }
        this.m_sLang = base.m_sLang;
        this.m_sScript = base.m_sScript;
    }

    protected Implementation(Behavior behavior, Implementation that) {
        super((Trait)behavior, that);
        this.m_sLang = that.m_sLang;
        this.m_sScript = that.m_sScript;
    }

    protected Implementation(Behavior behavior, DataInput stream, int nVersion) throws IOException {
        super((Trait)behavior, stream, nVersion);
        this.m_sLang = Implementation.readString(stream);
        this.m_sScript = Implementation.readString(stream);
    }

    protected Implementation(Trait parent, XmlElement xml, int nVersion) throws IOException {
        super(parent, xml, nVersion);
        String sLang = Implementation.readString(xml.getElement("language"));
        if (sLang.length() == 0) {
            sLang = "java";
        }
        String sScript = Implementation.readString(xml.getElement("script"));
        this.m_sLang = sLang;
        this.m_sScript = sScript;
    }

    @Override
    protected synchronized void save(DataOutput stream) throws IOException {
        super.save(stream);
        stream.writeUTF(this.m_sLang);
        stream.writeUTF(this.m_sScript);
    }

    @Override
    protected synchronized void save(XmlElement xml) throws IOException {
        super.save(xml);
        if (!Implementation.equals(this.m_sLang, "java")) {
            xml.addElement("language").setString(this.m_sLang);
        }
        XmlElement xmlScript = xml.addElement("script");
        Behavior bhvr = this.getBehavior();
        Component cd = bhvr.getComponent();
        String sDesc = cd.isGlobal() ? bhvr.getName() : '$' + cd.getName() + '.' + bhvr.getName();
        xmlScript.addAttribute("desc").setString(sDesc);
        xmlScript.setString(this.m_sScript);
    }

    @Override
    protected Trait getBlankDerivedTrait(Trait parent, int nMode) {
        return new Implementation(this, (Behavior)parent, nMode);
    }

    @Override
    protected Trait resolve(Trait traitDelta, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Implementation base = this;
        Implementation delta = (Implementation)this.resolveDelta(traitDelta, loader, errlist);
        Implementation derived = (Implementation)super.resolve(delta, parent, loader, errlist);
        derived.m_sLang = base.m_sLang;
        derived.m_sScript = base.m_sScript;
        return derived;
    }

    @Override
    protected int getExtractMode(Trait base) {
        throw new UnsupportedOperationException("Implementation.getExtractMode:  Implementations do not extract!");
    }

    @Override
    protected Trait extract(Trait base, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        throw new UnsupportedOperationException("Implementation.extract:  Implementations do not extract!");
    }

    @Override
    protected synchronized void invalidate() {
        super.invalidate();
        this.m_sLang = null;
        this.m_sScript = null;
    }

    @Override
    protected String getUniqueName() {
        return String.valueOf(this.getUID());
    }

    @Override
    protected String getUniqueDescription() {
        return "Script[" + this.getPosition() + "] " + this.getUniqueName();
    }

    public Behavior getBehavior() {
        return (Behavior)this.getParentTrait();
    }

    @Override
    public boolean isModifiable() {
        return this.isDeclaredAtThisLevel() && super.isModifiable();
    }

    public int getPosition() {
        Behavior bhvr = this.getBehavior();
        return bhvr == null ? -1 : bhvr.getImplementationPosition(this);
    }

    public String getLanguage() {
        return this.m_sLang;
    }

    public boolean isLanguageSettable() {
        return this.isModifiable();
    }

    public static boolean isLanguageLegal(String sLang) {
        return ClassHelper.isPartialNameLegal(sLang);
    }

    public void setLanguage(String sLang) throws PropertyVetoException {
        this.setLanguage(sLang, true);
    }

    protected synchronized void setLanguage(String sLang, boolean fVetoable) throws PropertyVetoException {
        String sPrev = this.m_sLang;
        if (sLang.equals(sPrev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isLanguageSettable()) {
                this.readOnlyAttribute(ATTR_LANG, sPrev, sLang);
            }
            if (!Implementation.isLanguageLegal(sLang)) {
                this.illegalAttributeValue(ATTR_LANG, sPrev, sLang);
            }
            this.fireVetoableChange(ATTR_LANG, sPrev, sLang);
        }
        this.m_sLang = sLang;
        this.firePropertyChange(ATTR_LANG, sPrev, sLang);
    }

    public String getScript() {
        return this.m_sScript;
    }

    public boolean isScriptSettable() {
        return this.isModifiable();
    }

    public static boolean isScriptLegal(String sScript) {
        return sScript != null;
    }

    public void setScript(String sScript) throws PropertyVetoException {
        this.setScript(sScript, true);
    }

    protected synchronized void setScript(String sScript, boolean fVetoable) throws PropertyVetoException {
        String sPrev = this.m_sScript;
        if (sScript.equals(sPrev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isScriptSettable()) {
                this.readOnlyAttribute("Script", sPrev, sScript);
            }
            if (!Implementation.isScriptLegal(sScript)) {
                this.illegalAttributeValue("Script", sPrev, sScript);
            }
            this.fireVetoableChange("Script", sPrev, sScript);
        }
        this.m_sScript = sScript;
        this.firePropertyChange("Script", sPrev, sScript);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Implementation) {
            Implementation that = (Implementation)obj;
            return this == that || this.m_sLang.equals(that.m_sLang) && this.m_sScript.equals(that.m_sScript) && super.equals(that);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getUniqueDescription() + " (" + this.m_sLang + ")";
    }

    @Override
    public void dump(PrintWriter out, String sIndent) {
        out.print(sIndent + "Implementation language=" + this.m_sLang + ", script=");
        if (this.m_sScript == null) {
            out.println("<null>");
        } else if (this.m_sScript == "") {
            out.println("<none>");
        } else {
            String sIndentScript = Implementation.nextIndent(sIndent);
            out.println();
            out.println(sIndentScript + "{");
            out.println(Implementation.indentString(this.m_sScript, sIndentScript));
            out.println(sIndentScript + "}");
        }
        super.dump(out, sIndent);
    }
}

