/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.component.BaseStorage;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.DataType;
import com.tangosol.dev.component.Trait;
import com.tangosol.util.ErrorList;
import com.tangosol.util.StringTable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;

public class OSStorage
extends BaseStorage {
    private static final String CLASS = "OSStorage";
    private static final int T_COMPONENT = 0;
    private static final int T_SIGNATURE = 1;
    private static final int T_CLASS = 2;
    private static final int T_JAVA = 3;
    private static final int T_RES_SIG = 4;
    private static final int T_RES_BINARY = 5;
    private static final String ROOT = "Root";
    private static final String[] SUBDIR = new String[6];
    private static final String[] SUFFIX;
    private File m_path;

    public OSStorage(String path) {
        this(new File(path));
    }

    public OSStorage(File path) {
        boolean fValid;
        if (!path.isAbsolute()) {
            try {
                path = path.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (path.exists()) {
            if (!path.canRead()) {
                throw new IllegalArgumentException("OSStorage:  Read access required!");
            }
            fValid = path.isDirectory();
        } else {
            boolean bl = fValid = path.getParentFile() != null && path.getParentFile().exists();
        }
        if (!fValid) {
            throw new IllegalArgumentException("OSStorage:  Invalid directory:  " + path.getPath());
        }
        this.m_path = path;
    }

    @Override
    public Component loadComponent(String sName, boolean fReadOnly, ErrorList errlist) throws ComponentException {
        if (sName.length() == 0) {
            sName = ROOT;
        }
        try {
            byte[] ab = this.loadFile(0, sName);
            if (ab == null) {
                return Component.isQualifiedNameLegal(sName) ? null : this.loadSignature(sName);
            }
            Component cd = new Component(new DataInputStream(new ByteArrayInputStream(ab)));
            if (!sName.equals(ROOT) && !sName.equals(cd.getQualifiedName())) {
                OSStorage.out("Component case-sensitive check failed:  expected=" + sName + ", actual=" + cd.getQualifiedName());
                return null;
            }
            if (fReadOnly) {
                cd.setModifiable(false);
            }
            return cd;
        }
        catch (IOException e) {
            OSStorage.out(e);
            throw new ComponentException(e.toString());
        }
    }

    @Override
    public void storeComponent(Component cd, ErrorList errlist) throws ComponentException {
        try {
            String sName;
            if (Trait.DEBUG) {
                OSStorage.out();
                OSStorage.out("***OSStorage*** Component before finalizeExtract:");
                cd.dump();
            }
            cd.finalizeExtract(this, errlist);
            if (Trait.DEBUG) {
                OSStorage.out();
                OSStorage.out("***OSStorage*** Component after finalizeExtract:");
                cd.dump();
            }
            if ((sName = cd.getQualifiedName()).length() == 0) {
                sName = ROOT;
            }
            if (cd.isDiscardable()) {
                this.removeComponent(sName);
            } else {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                cd.save(new DataOutputStream(stream));
                this.storeFile(0, sName, stream.toByteArray());
            }
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
    }

    @Override
    public void removeComponent(String sName) throws ComponentException {
        try {
            this.removeFile(0, sName);
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
        try {
            String sClz = Component.isQualifiedNameLegal(sName) ? DataType.getComponentClassName(sName) : sName;
            this.removeFile(2, sClz);
            this.removeFile(3, sClz);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Component loadSignature(String sName) throws ComponentException {
        try {
            byte[] ab = this.loadFile(1, sName);
            if (ab == null) {
                return null;
            }
            Component cd = new Component(new DataInputStream(new ByteArrayInputStream(ab)));
            if (!sName.equals(cd.getQualifiedName())) {
                return null;
            }
            return cd;
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
    }

    @Override
    public void storeSignature(Component cdJCS) throws ComponentException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            cdJCS.save(new DataOutputStream(stream));
            this.storeFile(1, cdJCS.getName(), stream.toByteArray());
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
    }

    @Override
    public ClassFile loadOriginalClass(String sName) throws ComponentException {
        return null;
    }

    @Override
    public ClassFile loadClass(String sName) throws ComponentException {
        try {
            String sClass = sName.replace('.', '/');
            byte[] abClass = this.loadFile(2, sName);
            if (abClass == null) {
                return null;
            }
            ClassFile clsf = new ClassFile(new DataInputStream(new ByteArrayInputStream(abClass)));
            if (clsf.getName().equals(sClass)) {
                return clsf;
            }
            OSStorage.out("Class case-sensitive check failed:  expected=" + sClass + ", actual=" + clsf.getName());
            return null;
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
    }

    @Override
    public void storeClass(ClassFile clz, String sListing) throws ComponentException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            clz.save(new DataOutputStream(stream));
            String sClass = clz.getName();
            this.storeFile(2, sClass, stream.toByteArray());
            if (sListing != null) {
                this.storeFile(3, sClass, sListing.getBytes());
            }
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
    }

    @Override
    public String loadJava(String sName) throws IOException {
        return null;
    }

    @Override
    public byte[] loadOriginalResource(String sName) throws IOException {
        return null;
    }

    @Override
    public byte[] loadResourceSignature(String sName) throws IOException {
        return this.loadFile(4, sName);
    }

    @Override
    public void storeResourceSignature(String sName, byte[] abData) throws IOException {
        if (abData == null) {
            this.removeResourceSignature(sName);
        } else {
            this.storeFile(4, sName, abData);
        }
    }

    @Override
    public void removeResourceSignature(String sName) throws IOException {
        this.removeFile(4, sName);
        this.removeFile(5, sName);
    }

    @Override
    public byte[] loadResource(String sName) throws IOException {
        return this.loadFile(5, sName);
    }

    @Override
    public void storeResource(String sName, byte[] abData) throws IOException {
        if (abData == null) {
            this.removeFile(5, sName);
        } else {
            this.storeFile(5, sName, abData);
        }
    }

    @Override
    public StringTable getSubComponents(String sComponent, boolean fQualify) {
        Object oLocator = this.getLocator();
        if (sComponent == null || sComponent.length() == 0) {
            StringTable tbl = new StringTable();
            sComponent = Component.getRootName();
            if (this.existsFile(0, sComponent)) {
                tbl.put(sComponent, oLocator);
            }
            return tbl;
        }
        StringTable tblSub = this.getFiles(0, sComponent);
        if (tblSub == null) {
            return new StringTable();
        }
        if (fQualify && !tblSub.isEmpty()) {
            Enumeration enmr = tblSub.keys();
            tblSub = new StringTable();
            while (enmr.hasMoreElements()) {
                tblSub.put(sComponent + '.' + (String)enmr.nextElement(), oLocator);
            }
        }
        return tblSub;
    }

    @Override
    public StringTable getPackageComponents(String sPackage, boolean fQualify) {
        return this.getSubComponents(sPackage, fQualify);
    }

    @Override
    public StringTable getComponentPackages(String sPackage, boolean fQualify, boolean fSubs) {
        StringTable tblSub;
        if (fSubs) {
            fQualify = true;
        }
        if ((tblSub = this.getSubdirectories(0, sPackage)) == null) {
            return new StringTable();
        }
        if (fQualify && !tblSub.isEmpty()) {
            Object oLocator = this.getLocator();
            Enumeration enmr = tblSub.keys();
            tblSub = new StringTable();
            while (enmr.hasMoreElements()) {
                String sSubPackage = (sPackage == null ? "" : sPackage + '.') + (String)enmr.nextElement();
                tblSub.put(sSubPackage, oLocator);
                if (!fSubs) continue;
                tblSub.addAll(this.getComponentPackages(sSubPackage, true, true));
            }
        }
        return tblSub;
    }

    @Override
    public StringTable getPackageSignatures(String sPackage, boolean fQualify) {
        StringTable tblJCS = this.getFiles(1, sPackage);
        StringTable tblDelta = this.getFiles(0, sPackage);
        if (tblDelta != null) {
            if (sPackage == null) {
                tblDelta.remove(ROOT);
                tblDelta.remove("Component");
            }
            if (tblJCS == null) {
                tblJCS = tblDelta;
            } else {
                tblJCS.putAll(tblDelta);
            }
        }
        if (tblJCS == null) {
            return new StringTable();
        }
        if (fQualify && sPackage != null && !tblJCS.isEmpty()) {
            Object oLocator = this.getLocator();
            Enumeration enmr = tblJCS.keys();
            tblJCS = new StringTable();
            while (enmr.hasMoreElements()) {
                tblJCS.put(sPackage + '.' + (String)enmr.nextElement(), oLocator);
            }
        }
        return tblJCS;
    }

    @Override
    public StringTable getSignaturePackages(String sPackage, boolean fQualify, boolean fSubs) {
        if (fSubs) {
            fQualify = true;
        }
        StringTable tblSub = this.getSubdirectories(1, sPackage);
        StringTable tblDelta = this.getSubdirectories(0, sPackage);
        if (tblDelta != null) {
            if (sPackage == null) {
                tblDelta.remove("Component");
            }
            if (tblSub == null) {
                tblSub = tblDelta;
            } else {
                tblSub.putAll(tblDelta);
            }
        }
        if (tblSub == null) {
            return new StringTable();
        }
        if (fQualify && !tblSub.isEmpty()) {
            Object oLocator = this.getLocator();
            Enumeration enmr = tblSub.keys();
            tblSub = new StringTable();
            while (enmr.hasMoreElements()) {
                String sSubPackage = (sPackage == null ? "" : sPackage + '.') + (String)enmr.nextElement();
                tblSub.put(sSubPackage, oLocator);
                if (!fSubs) continue;
                tblSub.addAll(this.getSignaturePackages(sSubPackage, true, true));
            }
        }
        return tblSub;
    }

    @Override
    public StringTable getPackageResources(String sPackage, boolean fQualify) {
        StringTable tblRes = this.getFiles(4, sPackage);
        if (tblRes == null) {
            return new StringTable();
        }
        if (fQualify && sPackage != null && !tblRes.isEmpty()) {
            Object oLocator = this.getLocator();
            Enumeration enmr = tblRes.keys();
            tblRes = new StringTable();
            while (enmr.hasMoreElements()) {
                tblRes.put(sPackage + '/' + (String)enmr.nextElement(), oLocator);
            }
        }
        return tblRes;
    }

    @Override
    public StringTable getResourcePackages(String sPackage, boolean fQualify, boolean fSubs) {
        StringTable tblSub;
        if (fSubs) {
            fQualify = true;
        }
        if ((tblSub = this.getSubdirectories(4, sPackage)) == null) {
            return new StringTable();
        }
        if (fQualify && !tblSub.isEmpty()) {
            Object oLocator = this.getLocator();
            Enumeration enmr = tblSub.keys();
            tblSub = new StringTable();
            while (enmr.hasMoreElements()) {
                String sSubPackage = (sPackage == null ? "" : sPackage + '/') + (String)enmr.nextElement();
                tblSub.put(sSubPackage, oLocator);
                if (!fSubs) continue;
                tblSub.addAll(this.getResourcePackages(sSubPackage, true, true));
            }
        }
        return tblSub;
    }

    protected boolean existsFile(int nType, String sName) {
        try {
            return this.buildFile(nType, sName, false).exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    protected byte[] loadFile(int nType, String sName) throws IOException {
        File file = this.buildFile(nType, sName, false);
        if (!file.isFile()) {
            return null;
        }
        return OSStorage.read(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeFile(int nType, String sName, byte[] abItem) throws IOException {
        File file = this.buildFile(nType, sName, true);
        if (file.isFile()) {
            if (OSStorage.equalsDeep(abItem, OSStorage.read(file))) {
                return;
            }
            if (nType == 0 && !file.canWrite()) {
                throw new IOException("Read-only component: " + file);
            }
            file.delete();
        }
        FileOutputStream stream = new FileOutputStream(file);
        try {
            stream.write(abItem);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void removeFile(int nType, String sName) throws IOException {
        File[] aFile;
        File file2 = this.buildFile(nType, sName, false);
        if (!file2.isFile()) {
            return;
        }
        File dir = file2.getParentFile();
        file2.delete();
        if ((nType == 2 || nType == 3) && (aFile = dir.listFiles()) != null) {
            String sPref = sName.substring(sName.lastIndexOf(46) + 1) + '$';
            for (File file2 : aFile) {
                if (!file2.getName().startsWith(sPref)) continue;
                file2.delete();
            }
        }
        while (!dir.equals(this.m_path) && this.emptyDir(dir)) {
            dir = dir.getParentFile();
        }
    }

    private boolean emptyDir(File dir) {
        OSStorage.azzert(dir.isDirectory(), "Not a directory: " + dir);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory() && this.emptyDir(file)) continue;
            return false;
        }
        dir.delete();
        return true;
    }

    protected File buildFile(int nType, String sName, boolean fEnsureDir) throws IOException {
        sName = SUBDIR[nType] + '/' + sName;
        if (nType < 4) {
            sName = sName.replace('.', '/');
        }
        File file = this.m_path;
        int ofCur = 0;
        int ofSep = sName.indexOf(47);
        while (true) {
            if (fEnsureDir && !file.isDirectory() && !file.mkdir()) {
                throw new IOException("Unable to create directory " + file);
            }
            if (ofSep < 0) break;
            file = new File(file, sName.substring(ofCur, ofSep));
            ofCur = ofSep + 1;
            ofSep = sName.indexOf(47, ofCur);
        }
        return new File(file, sName.substring(ofCur) + SUFFIX[nType]);
    }

    protected File buildDirectory(int nType, String sPackage) {
        int ofSep;
        sPackage = sPackage == null || sPackage.length() == 0 ? SUBDIR[nType] : SUBDIR[nType] + '/' + sPackage;
        if (nType < 4) {
            sPackage = sPackage.replace('.', '/');
        }
        File dir = this.m_path;
        int ofCur = 0;
        do {
            if (!(dir = new File(dir, (ofSep = sPackage.indexOf(47, ofCur)) >= 0 ? sPackage.substring(ofCur, ofSep) : sPackage.substring(ofCur))).isDirectory()) {
                return null;
            }
            ofCur = ofSep + 1;
        } while (ofSep >= 0);
        return dir;
    }

    protected StringTable getFiles(int nType, String sPackage) {
        File dir = this.buildDirectory(nType, sPackage);
        if (dir == null) {
            return null;
        }
        String sSuffix = SUFFIX[nType];
        int iSuffix = sSuffix.length();
        StringTable tblFiles = new StringTable();
        Object oLocator = this.getLocator();
        for (String sName : dir.list()) {
            File file;
            if (!sName.toLowerCase().endsWith(sSuffix) || !(file = new File(dir, (sName = sName.substring(0, sName.length() - iSuffix)) + sSuffix)).isFile()) continue;
            tblFiles.put(sName, oLocator);
        }
        return tblFiles;
    }

    protected StringTable getSubdirectories(int nType, String sPackage) {
        File dir = this.buildDirectory(nType, sPackage);
        if (dir == null) {
            return null;
        }
        StringTable tblSub = new StringTable();
        Object oLocator = this.getLocator();
        for (String sName : dir.list()) {
            File file = new File(dir, sName);
            if (!file.isDirectory()) continue;
            tblSub.put(sName, oLocator);
        }
        return tblSub;
    }

    public String toString() {
        return "OSStorage(" + this.m_path + ')';
    }

    static {
        OSStorage.SUBDIR[0] = "cdb";
        OSStorage.SUBDIR[1] = "jcs";
        OSStorage.SUBDIR[2] = "classes";
        OSStorage.SUBDIR[3] = "java";
        OSStorage.SUBDIR[4] = "resource";
        OSStorage.SUBDIR[5] = "classes";
        SUFFIX = new String[6];
        OSStorage.SUFFIX[0] = ".cdb";
        OSStorage.SUFFIX[1] = ".jcs";
        OSStorage.SUFFIX[2] = ".class";
        OSStorage.SUFFIX[3] = ".java";
        OSStorage.SUFFIX[4] = "";
        OSStorage.SUFFIX[5] = "";
    }
}

