/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.dev.disassembler.Attribute;
import com.tangosol.dev.disassembler.ClassFile;
import com.tangosol.dev.disassembler.Constant;
import com.tangosol.dev.disassembler.Field;
import com.tangosol.dev.disassembler.Method;
import com.tangosol.util.Base;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;

public class Disassembler
extends Base {
    public static void main(String[] asArgs) throws Throwable {
        try {
            String sName;
            String string = sName = asArgs.length > 0 && asArgs[0] != null && asArgs[0].charAt(0) != '-' ? asArgs[0] : "";
            if (sName.length() <= 0) {
                throw new IllegalArgumentException("Disassembler:  Name of class required!");
            }
            InputStream in = ClassLoader.getSystemResourceAsStream(sName.replace('.', '/').concat(".class"));
            DataInputStream stream = new DataInputStream(in);
            ClassFile clz = new ClassFile(stream);
            for (int i = 0; i < asArgs.length; ++i) {
                if (asArgs[i] == null || !asArgs[i].startsWith("-d") && !asArgs[i].startsWith("-D")) continue;
                Disassembler.outClass(clz);
                break;
            }
            clz.dump(Disassembler.getOut());
            Disassembler.out();
            try {
                stream.readByte();
                Disassembler.out("WARNING!!!  Stream not exhausted!!!");
            }
            catch (EOFException eOFException) {}
        }
        catch (Throwable t) {
            Disassembler.out("Caught \"" + t + "\", stack trace:");
            Disassembler.out(t);
            Disassembler.out("(end stack trace)");
        }
    }

    public static void outClass(ClassFile clz) {
        int i;
        Disassembler.out();
        Disassembler.out("Dumping class information:");
        Disassembler.out();
        int c = clz.getConstantCount();
        if (c == 0) {
            Disassembler.out("No constants.");
        } else {
            Disassembler.out("Constants (" + c + "):");
            for (i = 0; i < c; ++i) {
                Constant constant = clz.getConstant(i);
                Disassembler.out(Disassembler.format(i) + ' ' + (constant == null ? "<null>" : constant.toString()));
            }
        }
        Disassembler.out();
        c = clz.getAttributeCount();
        if (c == 0) {
            Disassembler.out("No attributes.");
        } else {
            Disassembler.outAttributes(clz.getAttributes(), "");
        }
        Disassembler.out();
        c = clz.getFieldCount();
        if (c == 0) {
            Disassembler.out("No fields.");
        } else {
            Disassembler.out("Fields (" + c + "):");
            for (i = 0; i < c; ++i) {
                Field field = clz.getField(i);
                Disassembler.out(Disassembler.format(i) + ' ' + (field == null ? "<null>" : "name=" + field.getName() + ", signature=" + field.getSignature()));
                if (field == null || field.getAttributeCount() <= 0) continue;
                Disassembler.outAttributes(field.getAttributes(), "    ");
            }
        }
        Disassembler.out();
        c = clz.getMethodCount();
        if (c == 0) {
            Disassembler.out("No methods.");
        } else {
            Disassembler.out("Methods (" + c + "):");
            for (i = 0; i < c; ++i) {
                Method method = clz.getMethod(i);
                Disassembler.out(Disassembler.format(i) + ' ' + (method == null ? "<null>" : method.toString()));
                if (method == null || method.getAttributeCount() <= 0) continue;
                Disassembler.outAttributes(method.getAttributes(), "    ");
            }
        }
    }

    public static void outAttributes(Attribute[] aAttr, String sIndent) {
        int c = aAttr.length;
        Disassembler.out(sIndent + "Attributes (" + c + "):");
        for (int i = 0; i < c; ++i) {
            Attribute attribute = aAttr[i];
            Disassembler.out(sIndent + Disassembler.format(i) + ' ' + (attribute == null ? "<null>" : attribute.toString()));
            if (attribute == null) continue;
            String sHexDump = Disassembler.toHexDump(attribute.getInfo(), 16);
            Disassembler.out(Disassembler.indentString(sHexDump, sIndent, true));
        }
    }

    public static String format(int n) {
        return "[" + Disassembler.toDecString(n, 4) + '/' + Disassembler.toHexString(n, 4) + ']';
    }
}

