/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.tools;

import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.StringTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class CommandLineTool
extends Base {
    private String[] m_asArg;

    public String[] getArguments() {
        return this.m_asArg;
    }

    public void setArguments(String[] asArg) {
        this.m_asArg = asArg;
    }

    public static char in(String s) {
        int ch;
        if (s != null && s.length() > 0) {
            System.out.print(s);
            System.out.flush();
        }
        InputStreamReader reader = new InputStreamReader(System.in);
        try {
            while ((ch = reader.read()) < 0) {
            }
        }
        catch (IOException e) {
            ch = 0;
        }
        return (char)ch;
    }

    public static String inputString(String s) {
        if (s != null && s.length() > 0) {
            System.out.print(s);
            System.out.flush();
        }
        StringBuffer sb = new StringBuffer();
        try {
            InputStreamReader reader = new InputStreamReader(System.in);
            do {
                sb.append(new BufferedReader(reader).readLine());
            } while (System.in.available() > 0);
            return sb.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ListMap parseArguments(String[] asArg, String[] asCommand, boolean fCaseSens) {
        ListMap<Object, String> map = new ListMap<Object, String>();
        String sCommand = null;
        int iArg = -1;
        for (int i = 0; i < asArg.length; ++i) {
            String sArg = asArg[i];
            if (sArg.charAt(0) == '-') {
                if (sCommand != null) {
                    CommandLineTool.addArgToResultsMap(sCommand, null, map);
                }
                if ((sCommand = sArg.substring(1)).length() == 0) {
                    throw new IllegalArgumentException("An empty command");
                }
                int of = sCommand.indexOf(61);
                if (of < 0) {
                    of = sCommand.indexOf(58);
                }
                if (of > 0) {
                    String sValue = sCommand.substring(of + 1);
                    sCommand = CommandLineTool.validateCommand(sCommand.substring(0, of), asCommand, fCaseSens);
                    CommandLineTool.addArgToResultsMap(sCommand, sValue, map);
                    sCommand = null;
                    continue;
                }
                sCommand = CommandLineTool.validateCommand(sCommand, asCommand, fCaseSens);
                continue;
            }
            if (sCommand == null) {
                map.put(++iArg, sArg);
                continue;
            }
            CommandLineTool.addArgToResultsMap(sCommand, sArg, map);
            sCommand = null;
        }
        if (sCommand != null) {
            map.put(sCommand, null);
        }
        return map;
    }

    protected static void addArgToResultsMap(String sArg, Object oValue, Map map) {
        LinkedList<Object> listVals;
        Object oValuePrev = map.get(sArg);
        if (oValuePrev == null) {
            map.put(sArg, oValue);
            return;
        }
        if (oValuePrev instanceof List) {
            listVals = (LinkedList<Object>)oValuePrev;
        } else {
            listVals = new LinkedList<Object>();
            map.put(sArg, listVals);
            listVals.add(oValuePrev);
        }
        listVals.add(oValue);
    }

    public static ListMap parseArguments(String[] asArg) {
        return CommandLineTool.parseArguments(asArg, null, false);
    }

    public static List extractSwitches(Collection colArg, String[] asValidSwitch) {
        LinkedList<String> lResult = new LinkedList<String>();
        int c = asValidSwitch.length;
        for (int i = 0; i < c; ++i) {
            String sSwitch = "-" + asValidSwitch[i];
            Iterator iter = colArg.iterator();
            while (iter.hasNext()) {
                String sArg = (String)iter.next();
                if (!sArg.equals(sSwitch)) continue;
                lResult.add(asValidSwitch[i]);
                iter.remove();
            }
        }
        return lResult;
    }

    public static Object processCommand(Map mapCommands, Object oArg) throws UnsupportedOperationException {
        Object value = mapCommands.get(oArg);
        if (value == null) {
            if (oArg instanceof String) {
                throw new UnsupportedOperationException("-" + oArg + " must be specified.");
            }
            throw new UnsupportedOperationException("argument " + oArg + " must be specified.");
        }
        return value;
    }

    public static Object processCommand(Map mapCommands, Object oArg, Object oDefault) throws UnsupportedOperationException {
        Object value = mapCommands.get(oArg);
        return value == null ? oDefault : value;
    }

    public static int processIntCommand(Map mapCommands, Object oArg, int iDefault) throws UnsupportedOperationException {
        Object value = mapCommands.get(oArg);
        return value == null ? iDefault : Integer.parseInt((String)value);
    }

    public static int processIntCommand(Map mapCommands, Object oArg) throws UnsupportedOperationException {
        Object value = CommandLineTool.processCommand(mapCommands, oArg);
        return Integer.parseInt((String)value);
    }

    public static long processLongCommand(Map mapCommands, Object oArg, long lDefault) throws UnsupportedOperationException {
        Object value = mapCommands.get(oArg);
        return value == null ? lDefault : Long.parseLong((String)value);
    }

    protected static String validateCommand(String sCommand, String[] asCommand, boolean fCaseSens) {
        if (!fCaseSens) {
            sCommand = sCommand.toLowerCase();
        }
        if (asCommand == null) {
            return sCommand;
        }
        for (int i = 0; i < asCommand.length; ++i) {
            if (!asCommand[i].equals(sCommand)) continue;
            return sCommand;
        }
        throw new IllegalArgumentException("Illegal command: -" + sCommand);
    }

    public static void showArgs(String[] asArgs) {
        CommandLineTool.out();
        int cArgs = asArgs.length;
        CommandLineTool.out(cArgs + " command line arguments:");
        for (int i = 0; i < cArgs; ++i) {
            CommandLineTool.out("[" + i + "]=\"" + asArgs[i] + "\"");
        }
        CommandLineTool.out();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Enumeration applyFilter(String sFileSpec, boolean fRecurse) {
        void var6_10;
        Stack<File> stackDirs;
        File dir;
        block11: {
            String sFilter = "*";
            String sDir = sFileSpec;
            dir = new File(sDir).getAbsoluteFile();
            if (!dir.isDirectory()) {
                int of = sFileSpec.lastIndexOf(File.separatorChar);
                if (of < 0) {
                    sDir = "";
                    sFilter = sFileSpec;
                } else {
                    sDir = sFileSpec.substring(0, ++of);
                    sFilter = sFileSpec.substring(of);
                }
                dir = new File(sDir).getAbsoluteFile();
                if (!dir.isDirectory()) {
                    return null;
                }
            }
            stackDirs = new Stack<File>();
            if (sFilter.length() < 1) {
                sFilter = "*";
            }
            if (sFilter.indexOf(42) < 0 && sFilter.indexOf(63) < 0) {
                if (fRecurse) {
                    ExactFilter exactFilter = new ExactFilter(stackDirs, fRecurse, sFilter);
                    break block11;
                } else {
                    File file = new File(dir, sFilter);
                    if (file.isFile() && file.exists()) {
                        return new SimpleEnumerator<File>(new File[]{file});
                    }
                    return NullImplementation.getEnumeration();
                }
            }
            if (sFilter.equals("*")) {
                AllFilter allFilter = new AllFilter(stackDirs, fRecurse);
            } else {
                PatternFilter patternFilter = new PatternFilter(stackDirs, fRecurse, sFilter);
            }
        }
        stackDirs.push(dir);
        return CommandLineTool.applyFilter(stackDirs, (FileFilter)var6_10);
    }

    protected static Enumeration applyFilter(Stack stackDirs, FileFilter filter) {
        Vector<File> vectFiles = new Vector<File>();
        while (!stackDirs.isEmpty()) {
            File dir = (File)stackDirs.pop();
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Illegal directory:  \"" + dir.getPath() + "\"");
            }
            File[] aFiles = dir.listFiles(filter);
            int cFiles = aFiles.length;
            for (int i = 0; i < cFiles; ++i) {
                vectFiles.addElement(aFiles[i]);
            }
        }
        return vectFiles.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Enumeration applyZipFilter(ZipFile zip, String sFileSpec, boolean fRecurse) {
        String sFilter = "*";
        String sDir = sFileSpec;
        if (sDir.length() > 0 && sDir.charAt(0) == '/') {
            sDir = sDir.substring(1);
        }
        if (sDir.length() > 0 && sDir.charAt(sDir.length() - 1) != '/') {
            ZipEntry file = zip.getEntry(sDir);
            if (file == null) {
                ZipEntry dir = zip.getEntry(sDir + '/');
                if (dir == null) {
                    int ofSlash = sDir.lastIndexOf(47) + 1;
                    if (ofSlash > 0) {
                        sFilter = sDir.substring(ofSlash);
                        sDir = sDir.substring(0, ofSlash);
                    } else {
                        if (!fRecurse) return NullImplementation.getEnumeration();
                        sFilter = sDir;
                        sDir = "";
                    }
                } else {
                    sDir = sDir + '/';
                }
            } else {
                if (sDir.indexOf(47) >= 0 || !fRecurse) {
                    return new SimpleEnumerator<Object>(new Object[]{file});
                }
                sFilter = sDir;
                sDir = "";
            }
        }
        ZipFilter filter = sFilter.length() < 1 || sFilter.equals("*") ? new ZipFilter(sDir, fRecurse) : (sFilter.indexOf(42) >= 0 || sFilter.indexOf(63) >= 0 ? new ZipPatternFilter(sDir, fRecurse, sFilter) : new ZipExactFilter(sDir, fRecurse, sFilter));
        StringTable tbl = new StringTable();
        Enumeration<? extends ZipEntry> enmr = zip.entries();
        while (enmr.hasMoreElements()) {
            ZipEntry entry = enmr.nextElement();
            if (!filter.accept(entry)) continue;
            tbl.put(entry.getName(), entry);
        }
        return tbl.elements();
    }

    public static boolean matches(String sName, char[] achPattern) {
        return CommandLineTool.matches(sName.toCharArray(), 0, achPattern, 0);
    }

    private static boolean matches(char[] achName, int ofName, char[] achPattern, int ofPattern) {
        int cchName = achName.length;
        int cchPattern = achPattern.length;
        while (ofName < cchName && ofPattern < cchPattern) {
            char chName = achName[ofName];
            char chPattern = achPattern[ofPattern];
            if (chName >= 'A' && chName <= 'Z') {
                chName = (char)(97 + (chName - 65));
            }
            if (chPattern >= 'A' && chPattern <= 'Z') {
                chPattern = (char)(97 + (chPattern - 65));
            }
            switch (chPattern) {
                case '?': {
                    break;
                }
                case '*': {
                    if (ofPattern == cchPattern - 1) {
                        return true;
                    }
                    char chTag = achPattern[ofPattern + 1];
                    for (int ofTag = ofName; ofTag < cchName; ++ofTag) {
                        if (chTag != '?' && achName[ofTag] != chTag || !CommandLineTool.matches(achName, ofTag, achPattern, ofPattern + 1)) continue;
                        return true;
                    }
                    return false;
                }
                default: {
                    if (chName == chPattern) break;
                    return false;
                }
            }
            ++ofName;
            ++ofPattern;
        }
        return ofName == cchName && ofPattern == cchPattern;
    }

    public static class ZipExactFilter
    extends ZipFilter {
        protected String m_sFile;

        public ZipExactFilter(String sDir, boolean fRecurse, String sFile) {
            super(sDir, fRecurse);
            this.m_sFile = sFile;
        }

        @Override
        public boolean accept(ZipEntry entry) {
            if (super.accept(entry)) {
                String sName = entry.getName();
                return this.m_sFile.equals(sName.substring(sName.lastIndexOf(47) + 1));
            }
            return false;
        }
    }

    public static class ZipPatternFilter
    extends ZipFilter {
        protected char[] m_achPattern;

        public ZipPatternFilter(String sDir, boolean fRecurse, String sPattern) {
            super(sDir, fRecurse);
            this.m_achPattern = sPattern.toCharArray();
        }

        @Override
        public boolean accept(ZipEntry entry) {
            return super.accept(entry) && CommandLineTool.matches(entry.getName(), this.m_achPattern);
        }
    }

    public static class ZipFilter {
        protected String m_sDir;
        protected boolean m_fRecurse;

        public ZipFilter(String sDir, boolean fRecurse) {
            if (sDir.length() > 0 && sDir.charAt(sDir.length() - 1) != '/') {
                throw new IllegalStateException("ZipFilter:  \"" + sDir + "\" is not a directory!");
            }
            this.m_sDir = sDir;
            this.m_fRecurse = fRecurse;
        }

        public boolean accept(ZipEntry entry) {
            String sName = entry.getName();
            if (sName.length() > this.m_sDir.length() && sName.startsWith(this.m_sDir) && sName.charAt(sName.length() - 1) != '/') {
                return this.m_fRecurse || sName.indexOf(47, this.m_sDir.length()) < 0;
            }
            return false;
        }
    }

    public static class ExactFilter
    implements FileFilter {
        protected Stack m_stackDirs;
        protected boolean m_fPushDirs;
        protected String m_sFile;

        public ExactFilter(Stack stackDirs, boolean fPushDirs, String sFile) {
            this.m_stackDirs = stackDirs;
            this.m_fPushDirs = fPushDirs;
            this.m_sFile = sFile;
        }

        @Override
        public boolean accept(File path) {
            if (path.isDirectory()) {
                if (this.m_fPushDirs) {
                    this.m_stackDirs.push(path);
                }
                return false;
            }
            return this.m_sFile.equalsIgnoreCase(path.getName());
        }
    }

    public static class PatternFilter
    implements FileFilter {
        protected Stack m_stackDirs;
        protected boolean m_fPushDirs;
        protected char[] m_achPattern;

        public PatternFilter(Stack stackDirs, boolean fPushDirs, String sPattern) {
            this.m_stackDirs = stackDirs;
            this.m_fPushDirs = fPushDirs;
            this.m_achPattern = sPattern.toCharArray();
        }

        @Override
        public boolean accept(File path) {
            if (path.isDirectory()) {
                if (this.m_fPushDirs) {
                    this.m_stackDirs.push(path);
                }
                return false;
            }
            return CommandLineTool.matches(path.getName(), this.m_achPattern);
        }
    }

    public static class AllFilter
    implements FileFilter {
        protected Stack m_stackDirs;
        protected boolean m_fPushDirs;

        public AllFilter(Stack stackDirs, boolean fPushDirs) {
            this.m_stackDirs = stackDirs;
            this.m_fPushDirs = fPushDirs;
        }

        @Override
        public boolean accept(File path) {
            if (path.isDirectory()) {
                if (this.m_fPushDirs) {
                    this.m_stackDirs.push(path);
                }
                return false;
            }
            return true;
        }
    }
}

