/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.tools;

import com.tangosol.dev.tools.CommandLineTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;

public class Replace
extends CommandLineTool {
    public static void main(String[] asArgs) {
        try {
            int MINSIZE;
            Enumeration enmrFiles;
            int cArgs = asArgs.length;
            if (cArgs < 3) {
                Replace.showInstructions();
                return;
            }
            String sFileSpec = asArgs[0];
            String sOldText = asArgs[1];
            String sNewText = asArgs[2];
            if (sFileSpec.length() < 1 || sOldText.length() < 1) {
                Replace.showInstructions();
                return;
            }
            boolean fPrompt = false;
            boolean fRecurse = false;
            boolean fVerbose = false;
            for (int i = 3; i < cArgs; ++i) {
                String sOpt = asArgs[i];
                if (sOpt.length() < 2 || sOpt.charAt(0) != '-') {
                    Replace.showInstructions();
                    return;
                }
                block10: for (int of = 1; of < sOpt.length(); ++of) {
                    switch (sOpt.charAt(of)) {
                        case 'P': 
                        case 'p': {
                            fPrompt = true;
                            continue block10;
                        }
                        case 'D': 
                        case 'd': {
                            fRecurse = true;
                            continue block10;
                        }
                        case 'V': 
                        case 'v': {
                            fVerbose = true;
                            continue block10;
                        }
                        default: {
                            Replace.showInstructions();
                            return;
                        }
                    }
                }
            }
            if (fVerbose) {
                Replace.out();
                Replace.out("File Spec   :  \"" + sFileSpec + "\"");
                Replace.out("Search For  :  \"" + sOldText + "\"");
                Replace.out("Replace With:  \"" + sNewText + "\"");
                Replace.out("Selected Options:");
                if (fRecurse) {
                    Replace.out("  -d  Recurse sub-directories");
                }
                if (fPrompt) {
                    Replace.out("  -p  Prompt before making each change");
                }
                Replace.out("  -v  Verbose mode");
            }
            if (fVerbose) {
                Replace.out();
                Replace.out("Selecting files ...");
            }
            if ((enmrFiles = Replace.applyFilter(sFileSpec, fRecurse)) == null) {
                Replace.out();
                Replace.out("Invalid directory or file specification:  " + sFileSpec);
                Replace.showInstructions();
                return;
            }
            if (fVerbose) {
                Replace.out();
                Replace.out("Processing files ...");
            }
            int MAXSIZE = 0x1000000;
            int cbBuf = MINSIZE = 65536;
            byte[] abBuf = new byte[cbBuf];
            byte[] abOld = Replace.getBytes(sOldText);
            int cbOld = abOld.length;
            byte bTag = abOld[0];
            byte[] abNew = Replace.getBytes(sNewText);
            int cbNew = abNew.length;
            while (enmrFiles.hasMoreElements()) {
                File file = (File)enmrFiles.nextElement();
                boolean fReadable = file.canRead();
                boolean fWriteable = file.canWrite();
                boolean fHidden = file.isHidden();
                boolean fNameShown = false;
                int cbFile = (int)file.length();
                if (fVerbose) {
                    StringBuffer sb = new StringBuffer();
                    if (fReadable) {
                        sb.append("r");
                    }
                    if (fWriteable) {
                        sb.append("w");
                    }
                    if (fHidden) {
                        sb.append("h");
                    }
                    Replace.out(file.getPath() + ", (" + sb.toString() + "), " + cbFile + " bytes");
                    fNameShown = true;
                }
                if (!fReadable || !fWriteable || fHidden || cbFile > MAXSIZE) {
                    String sText = "";
                    if (!fReadable) {
                        sText = "(not readable)";
                    } else if (!fWriteable) {
                        sText = "(not writeable)";
                    } else if (fHidden) {
                        sText = "(hidden)";
                    } else if (cbFile > MAXSIZE) {
                        sText = "(too large)";
                    }
                    Replace.out("Skipping " + file.getPath() + " " + sText);
                    continue;
                }
                if (cbFile > cbBuf) {
                    cbBuf = cbFile + MINSIZE;
                    abBuf = new byte[cbBuf];
                }
                try {
                    FileInputStream in = new FileInputStream(file);
                    for (int cbTotal = 0; cbTotal < cbFile; cbTotal += in.read(abBuf, cbTotal, cbFile - cbTotal)) {
                    }
                    in.close();
                }
                catch (IOException e) {
                    Replace.out("Skipping " + file.getPath() + " due to IOException:");
                    Replace.out(e);
                    continue;
                }
                FileOutputStream out = null;
                int ofCur = 0;
                int ofMax = cbFile - abOld.length;
                int ofLine = 0;
                int cbTotal = 0;
                int cLines = 1;
                int cChanges = 0;
                while (ofCur <= ofMax) {
                    byte bCur = abBuf[ofCur];
                    if (bCur == bTag) {
                        boolean fMatch = true;
                        for (int i = 1; i < cbOld; ++i) {
                            if (abBuf[ofCur + i] == abOld[i]) continue;
                            fMatch = false;
                            break;
                        }
                        if (fMatch) {
                            if (!fNameShown) {
                                Replace.out(file.getPath());
                                fNameShown = true;
                            }
                            int chAns = 89;
                            if (fPrompt) {
                                byte b;
                                int ofEOL;
                                boolean fSkip;
                                boolean bl = fSkip = ofLine < ofCur - 40;
                                if (fSkip) {
                                    ofLine = ofCur - 40;
                                }
                                int ofBreak = ofEOL + 40;
                                boolean fTrunc = false;
                                for (ofEOL = ofCur + cbOld; ofEOL < cbFile && (b = abBuf[ofEOL]) != 13 && b != 10; ++ofEOL) {
                                    if (ofEOL < ofBreak) continue;
                                    fTrunc = true;
                                    break;
                                }
                                Replace.out("(Line " + cLines + ")  " + (fSkip ? "... " : "") + new String(abBuf, ofLine, ofEOL - ofLine) + (fTrunc ? " ..." : ""));
                                chAns = Replace.in("Replace (Y/N): ");
                            }
                            if (chAns == 89 || chAns == 121) {
                                if (out == null) {
                                    if (!file.delete()) {
                                        Replace.out("Error deleting " + file.getPath());
                                        return;
                                    }
                                    if (!file.createNewFile()) {
                                        Replace.out("Error creating " + file.getPath());
                                        return;
                                    }
                                    out = new FileOutputStream(file);
                                }
                                if (cbTotal < ofCur) {
                                    out.write(abBuf, cbTotal, ofCur - cbTotal);
                                }
                                out.write(abNew);
                                cbTotal = ofCur += cbOld;
                                ++cChanges;
                                continue;
                            }
                        }
                    } else if (fPrompt && bCur == 10) {
                        ofLine = ofCur + 1;
                        ++cLines;
                    }
                    ++ofCur;
                }
                if (out == null) continue;
                if (cbTotal < cbFile) {
                    out.write(abBuf, cbTotal, cbFile - cbTotal);
                }
                out.close();
                Replace.out("(" + cChanges + " occurrences replaced)");
            }
        }
        catch (Throwable t) {
            Replace.out();
            Replace.out("Caught \"" + t + "\"");
            Replace.out("(begin stack trace)");
            Replace.out(t);
            Replace.out("(end stack trace)");
            Replace.out();
        }
    }

    static void showInstructions() {
        Replace.out();
        Replace.out("Global search & replace utility");
        Replace.out();
        Replace.out("Usage:");
        Replace.out("  Replace <filespec> <old string> <new string> [-p] [-d] [-v]");
        Replace.out();
        Replace.out("Options:");
        Replace.out("  -d  Recurse sub-directories");
        Replace.out("  -p  Prompt before making each change");
        Replace.out("  -v  Verbose mode");
        Replace.out();
        Replace.out("Example:");
        Replace.out("  java com.tangosol.dev.tools.Replace \"*.java\" \"import \" \"// import \" -p");
        Replace.out();
    }

    static byte[] getBytes(String s) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        char[] ach = s.toCharArray();
        int cch = ach.length;
        boolean fEscape = false;
        for (int i = 0; i < cch; ++i) {
            char ch = ach[i];
            if (fEscape) {
                switch (ch) {
                    case 'b': {
                        stream.write(8);
                        break;
                    }
                    case 't': {
                        stream.write(9);
                        break;
                    }
                    case 'n': {
                        stream.write(10);
                        break;
                    }
                    case 'f': {
                        stream.write(12);
                        break;
                    }
                    case 'r': {
                        stream.write(13);
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        stream.write((byte)ch);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int cMaxDigits = ch > '3' ? 2 : 3;
                        int nChar = 0;
                        do {
                            nChar = nChar * 8 + (ch - 48);
                        } while (++i < cch && (ch = ach[i]) >= '0' && ch <= '7' && --cMaxDigits > 0);
                        --i;
                        ch = (char)nChar;
                        stream.write((byte)ch);
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        throw new IllegalArgumentException("New line in escaped literal!");
                    }
                    default: {
                        throw new IllegalArgumentException("New line in escaped literal!");
                    }
                }
                fEscape = false;
                continue;
            }
            if (ch == '\\') {
                fEscape = true;
                continue;
            }
            stream.write((byte)(ch & 0xFF));
        }
        if (fEscape) {
            throw new IllegalArgumentException("Escaped literal not completed!");
        }
        return stream.toByteArray();
    }
}

