/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.tangosol.net.MemberIdentity;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.lang.reflect.InvocationTargetException;

public class DefaultMemberIdentity
implements MemberIdentity {
    private String m_sClusterName;
    private int m_nMachineId;
    private String m_sMachineName;
    private String m_sMemberName;
    private int m_memberPriority;
    private String m_sProcessName;
    private String m_sRackName;
    private String m_sRoleName;
    private String m_sSiteName;

    public DefaultMemberIdentity() {
        this(null);
    }

    public DefaultMemberIdentity(MemberIdentity identity) {
        if (identity != null) {
            this.m_sClusterName = identity.getClusterName();
            this.m_nMachineId = identity.getMachineId();
            this.m_sMachineName = identity.getMachineName();
            this.m_sMemberName = identity.getMemberName();
            this.m_memberPriority = identity.getPriority();
            this.m_sProcessName = identity.getProcessName();
            this.m_sRackName = identity.getRackName();
            this.m_sRoleName = identity.getRoleName();
            this.m_sSiteName = identity.getSiteName();
        }
    }

    @Override
    public String getClusterName() {
        return this.m_sClusterName;
    }

    public DefaultMemberIdentity setClusterName(String sClusterName) {
        this.m_sClusterName = sClusterName;
        return this;
    }

    @Override
    public int getMachineId() {
        return this.m_nMachineId;
    }

    public DefaultMemberIdentity setMachineId(int nMachineId) {
        this.m_nMachineId = nMachineId & 0xFFFF;
        return this;
    }

    @Override
    public String getMachineName() {
        return this.m_sMachineName;
    }

    public DefaultMemberIdentity setMachineName(String sMachineName) {
        this.m_sMachineName = sMachineName;
        return this;
    }

    @Override
    public String getMemberName() {
        return this.m_sMemberName;
    }

    public DefaultMemberIdentity setMemberName(String sName) {
        this.m_sMemberName = sName;
        return this;
    }

    @Override
    public int getPriority() {
        return this.m_memberPriority;
    }

    public DefaultMemberIdentity setPriority(int nPriority) {
        this.m_memberPriority = nPriority;
        return this;
    }

    @Override
    public String getProcessName() {
        String sProcessName = this.m_sProcessName;
        if (sProcessName == null) {
            this.m_sProcessName = sProcessName = this.makeProcessName();
        }
        return sProcessName;
    }

    public DefaultMemberIdentity setProcessName(String sProcessName) {
        this.m_sProcessName = sProcessName;
        return this;
    }

    @Override
    public String getRackName() {
        return this.m_sRackName;
    }

    public DefaultMemberIdentity setRackName(String sRackName) {
        this.m_sRackName = sRackName;
        return this;
    }

    @Override
    public String getRoleName() {
        String sRoleName = this.m_sRoleName;
        if (sRoleName == null) {
            this.m_sRoleName = sRoleName = this.makeRoleName();
        }
        return sRoleName;
    }

    public DefaultMemberIdentity setRoleName(String sRoleName) {
        this.m_sRoleName = sRoleName;
        return this;
    }

    @Override
    public String getSiteName() {
        return this.m_sSiteName;
    }

    public DefaultMemberIdentity setSiteName(String sSiteName) {
        this.m_sSiteName = sSiteName;
        return this;
    }

    public DefaultMemberIdentity validate() {
        Base.checkRange(this.getClusterName() == null ? 0L : (long)this.getClusterName().length(), 0L, 66L, "ClusterName");
        Base.checkRange(this.getMachineName() == null ? 0L : (long)this.getMachineName().length(), 0L, 66L, "MachineName");
        Base.checkRange(this.getMemberName() == null ? 0L : (long)this.getMemberName().length(), 0L, 66L, "MemberName");
        Base.checkRange(this.getProcessName() == null ? 0L : (long)this.getProcessName().length(), 0L, 66L, "ProcessName");
        Base.checkRange(this.getRackName() == null ? 0L : (long)this.getRackName().length(), 0L, 66L, "RackName");
        Base.checkRange(this.getRoleName() == null ? 0L : (long)this.getRoleName().length(), 0L, 66L, "RoleName");
        Base.checkRange(this.getSiteName() == null ? 0L : (long)this.getSiteName().length(), 0L, 66L, "SiteName");
        Base.checkRange(this.getPriority(), 0L, 10L, "Priority");
        return this;
    }

    public String toString() {
        return "DefaultMemberIdentity{ClusterName=" + this.getClusterName() + ", MachineId=" + this.getMachineId() + ", MachineName=" + this.getMachineName() + ", MemberName=" + this.getMemberName() + ", Priority=" + this.getPriority() + ", ProcessName=" + this.getProcessName() + ", RackName=" + this.getRackName() + ", RoleName=" + this.getRoleName() + ", SiteName=" + this.getSiteName() + "}";
    }

    protected String makeProcessName() {
        String sName = null;
        try {
            Class<?> clz = Class.forName("java.lang.management.ManagementFactory");
            Object oRT = ClassHelper.invokeStatic(clz, "getRuntimeMXBean", ClassHelper.VOID);
            sName = (String)ClassHelper.invoke(oRT, "getName", ClassHelper.VOID);
        }
        catch (ClassNotFoundException clz) {
        }
        catch (InvocationTargetException clz) {
        }
        catch (NoSuchMethodException clz) {
        }
        catch (IllegalAccessException clz) {
            // empty catch block
        }
        int ofAt = sName.indexOf(64);
        if (ofAt != -1) {
            String sPid = sName.substring(0, ofAt);
            try {
                Long.parseLong(sPid);
                sName = sPid;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (sName.length() > 66) {
            sName = sName.substring(0, 66);
        }
        return sName;
    }

    protected String makeRoleName() {
        String sName = null;
        try {
            Thread thread = Thread.currentThread();
            StackTraceElement[] aStack = null;
            if (Base.equals(thread.getName(), "main")) {
                aStack = new Throwable().getStackTrace();
            } else {
                ThreadGroup group = thread.getThreadGroup();
                ThreadGroup parent = group.getParent();
                while (parent != null) {
                    group = parent;
                    parent = group.getParent();
                }
                Thread[] aThread = new Thread[group.activeCount()];
                int c = group.enumerate(aThread);
                for (int i = 0; i < c; ++i) {
                    thread = aThread[i];
                    String sThreadName = thread.getName();
                    if (!Base.equals(sThreadName, "main") && !Base.equals(sThreadName, "Main Thread")) continue;
                    aStack = (StackTraceElement[])ClassHelper.invoke(thread, "getStackTrace", ClassHelper.VOID);
                    break;
                }
            }
            if (aStack != null) {
                String sClass = aStack[aStack.length - 1].getClassName();
                if (sClass.equals("com.tangosol.coherence.component.Application") || sClass.equals("com.tangosol.net.CacheFactory")) {
                    sName = "CoherenceConsole";
                } else if (sClass.equals("com.tangosol.net.DefaultCacheServer")) {
                    sName = "CoherenceServer";
                } else {
                    String[] sParts = Base.parseDelimitedString(sClass, '.');
                    int ofPartStart = sParts[0].equals("com") || sParts[0].equals("org") ? 1 : 0;
                    sName = Base.capitalize(sParts[ofPartStart]);
                    String sEnd = Base.capitalize(sParts[sParts.length - 1]);
                    if (sName.length() + sEnd.length() < 66) {
                        int c = sParts.length - 1;
                        for (int i = ofPartStart + 1; i < c; ++i) {
                            String sPart = sParts[i];
                            if (sName.length() + sPart.length() + sEnd.length() > 66) break;
                            sName = sName + Base.capitalize(sPart);
                        }
                        sName = sName + sEnd;
                    } else {
                        sName = sEnd.substring(0, 66);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sName;
    }
}

