/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.util.Timer;
import java.util.TimerTask;

public class DefaultServiceFailurePolicy
implements ServiceFailurePolicy {
    public static final int POLICY_EXIT_CLUSTER = 1;
    public static final int POLICY_EXIT_PROCESS = 2;
    public static final int POLICY_LOGGING = 3;
    private int m_nPolicyType;
    public static final int DEFAULT_LOGGING_INTERVAL = 60000;

    public DefaultServiceFailurePolicy(int nPolicyType) {
        this.m_nPolicyType = nPolicyType;
    }

    @Override
    public void onGuardableRecovery(Guardable guardable, Service service) {
        GuardSupport.logStackTraces();
        switch (this.getPolicyType()) {
            default: {
                CacheFactory.log("Attempting recovery of " + guardable, 2);
                guardable.recover();
                break;
            }
            case 3: {
                CacheFactory.log("Logging stacktrace due to soft-timeout", 2);
                Guardian.GuardContext context = guardable.getContext();
                if (context == null) break;
                context.heartbeat();
            }
        }
    }

    @Override
    public void onGuardableTerminate(Guardable guardable, Service service) {
        GuardSupport.logStackTraces();
        switch (this.getPolicyType()) {
            default: {
                CacheFactory.log("Terminating " + guardable, 2);
                guardable.terminate();
            }
            case 3: 
        }
    }

    @Override
    public void onServiceFailed(Cluster cluster) {
        String sHeader = " Oracle Coherence <Error>: ";
        switch (this.getPolicyType()) {
            default: {
                System.err.println(DefaultServiceFailurePolicy.getTimestamp() + sHeader + "Halting this cluster node due to unrecoverable service failure");
                System.err.flush();
                try {
                    ClassHelper.invoke(cluster, "halt", ClassHelper.VOID);
                    break;
                }
                catch (Exception e) {
                    System.err.println(DefaultServiceFailurePolicy.getTimestamp() + sHeader + "Unexpected exception while halting the cluster:\nStackTrace:\n" + Base.printStackTrace(e));
                    System.err.flush();
                    throw Base.ensureRuntimeException(e, "Unexpected exception while halting the cluster.");
                }
                finally {
                    System.err.println(DefaultServiceFailurePolicy.getTimestamp() + sHeader + "Halted the cluster: " + cluster.toString());
                    System.err.flush();
                }
            }
            case 2: {
                System.err.println(DefaultServiceFailurePolicy.getTimestamp() + sHeader + "Exiting JVM due to unrecoverable service failure");
                System.err.flush();
                DefaultServiceFailurePolicy.ensureExit(cluster, -1, DefaultServiceFailurePolicy.getShutdownTimeout(cluster));
            }
        }
    }

    public int getPolicyType() {
        return this.m_nPolicyType;
    }

    protected static String getTimestamp() {
        try {
            return Base.formatDateTime(Base.getSafeTimeMillis());
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureExit(Cluster cluster, final int status, final long cTimeout) {
        final String sHeader = " Oracle Coherence <Error>: ";
        try {
            if (cTimeout >= 0L) {
                System.err.println(DefaultServiceFailurePolicy.getTimestamp() + sHeader + "Schedule timer task to halt process in " + cTimeout + " millis");
                System.err.flush();
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.err.println(DefaultServiceFailurePolicy.getTimestamp() + sHeader + " Failed to exit gracefully after " + cTimeout + " millis, halting process");
                        System.err.flush();
                        Runtime.getRuntime().halt(status);
                    }
                }, cTimeout);
            }
            System.err.println(DefaultServiceFailurePolicy.getTimestamp() + sHeader + "Begin graceful exit from JVM ...");
            System.err.flush();
            System.exit(status);
        }
        catch (Throwable ex) {
            String sCause = ex.getCause() == null ? "" : " Cause: " + ex.getCause();
            System.err.println("Handled unexpected exception " + ex.getClass().getName() + ex.getMessage() + sCause);
            System.err.flush();
            Runtime.getRuntime().halt(status);
        }
        finally {
            Runtime.getRuntime().halt(status);
        }
    }

    protected static long getShutdownTimeout(Cluster cluster) {
        try {
            Object oCluster = ClassHelper.invoke(cluster, "getCluster", ClassHelper.VOID);
            Long ldtShutdownTimeout = (Long)ClassHelper.invoke(oCluster, "getShutdownTimeout", ClassHelper.VOID);
            return ldtShutdownTimeout;
        }
        catch (Throwable ignore) {
            return Config.getDuration("coherence.shutdown.timeout", new Duration(2, Duration.Magnitude.MINUTE)).as(Duration.Magnitude.MILLI);
        }
    }

    public String toString() {
        String sType;
        switch (this.getPolicyType()) {
            case 1: {
                sType = "exit cluster";
                break;
            }
            case 2: {
                sType = "exit process";
                break;
            }
            case 3: {
                sType = "logging";
                break;
            }
            default: {
                sType = "unknown";
            }
        }
        return "DefaultServiceFailurePolicy{PolicyType=" + sType + "}";
    }
}

