/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management;

import com.tangosol.internal.net.management.MBeanAttribute;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public enum ServiceMBeanAttribute implements MBeanAttribute
{
    Description(Collectors.toSet()),
    PersistenceLatencyMax(Collectors.maxBy(Long::compareTo)),
    RequestMaxDuration(Collectors.maxBy(Long::compareTo)),
    RequestPendingDuration(Collectors.maxBy(Long::compareTo)),
    Running(Collectors.groupingBy(o -> o, Collectors.counting())),
    StorageEnabled(Collectors.groupingBy(o -> o, Collectors.counting())),
    StorageEnabledCount(false),
    TaskMaxBacklog(Collectors.maxBy(Integer::compareTo)),
    ThreadPoolSizingEnabled(Collectors.groupingBy(o -> o, Collectors.counting()));

    protected final Collector f_collector;
    protected final String f_sName;
    protected final boolean f_fVisible;

    private ServiceMBeanAttribute(boolean fVisible) {
        this(null, MBeanAttribute.NullCollector.INSTANCE(), fVisible);
    }

    private ServiceMBeanAttribute(Collector collector) {
        this(null, collector);
    }

    private ServiceMBeanAttribute(String sName, Collector collector) {
        this(sName, collector, true);
    }

    private ServiceMBeanAttribute(String sName, Collector collector, boolean fVisible) {
        this.f_collector = collector;
        this.f_sName = sName;
        this.f_fVisible = fVisible;
    }

    public Collector collector() {
        return this.f_collector;
    }

    @Override
    public String description() {
        return this.f_sName == null ? this.name() : this.f_sName;
    }

    @Override
    public boolean isVisible() {
        return this.f_fVisible;
    }
}

