/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management;

import com.tangosol.internal.net.management.AbstractMultiCollector;
import com.tangosol.internal.net.management.MBeanCollectorFunction;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;

public class TabularDataCollector<T extends Map<String, Object>>
extends AbstractMultiCollector {
    protected static String KEY = "key";
    protected static String VALUE = "value";

    public BiConsumer<T, TabularData> accumulator() {
        return (map, tabularData) -> {
            CompositeType rowType = tabularData.getTabularType().getRowType();
            if (rowType.containsKey(KEY) && rowType.containsKey(VALUE) && rowType.getType(KEY) instanceof SimpleType) {
                for (Object objValue : tabularData.values()) {
                    String sKey = ((CompositeData)objValue).get(KEY).toString();
                    Object oValue = ((CompositeData)objValue).get(VALUE);
                    Collector collector = (Collector)this.f_mapCollector.get(sKey);
                    if (collector == null) {
                        collector = MBeanCollectorFunction.createTypeBasedCollector(oValue);
                        this.f_mapCollector.put(sKey, collector);
                        map.put(sKey, collector.supplier().get());
                    }
                    collector.accumulator().accept(map.get(sKey), oValue);
                }
            }
        };
    }
}

