/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.extend.proxy;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.extend.proxy.CacheServiceProxyDependencies;
import com.tangosol.internal.net.service.extend.proxy.DefaultServiceProxyDependencies;
import com.tangosol.util.Base;

public class DefaultCacheServiceProxyDependencies
extends DefaultServiceProxyDependencies
implements CacheServiceProxyDependencies {
    private boolean m_fLockEnabled;
    private boolean m_fReadyOnly;
    private long m_cbTransferThreshold = 524288L;

    public DefaultCacheServiceProxyDependencies() {
        this(null);
    }

    public DefaultCacheServiceProxyDependencies(CacheServiceProxyDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_fLockEnabled = deps.isLockEnabled();
            this.m_fReadyOnly = deps.isReadOnly();
            this.m_cbTransferThreshold = deps.getTransferThreshold();
        }
    }

    @Override
    public boolean isLockEnabled() {
        return this.m_fLockEnabled;
    }

    @Injectable(value="lock-enabled")
    public void setLockEnabled(boolean fEnabled) {
        this.m_fLockEnabled = fEnabled;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_fReadyOnly;
    }

    @Injectable(value="read-only")
    public void setReadOnly(boolean fReadOnly) {
        this.m_fReadyOnly = fReadOnly;
    }

    @Override
    public long getTransferThreshold() {
        return this.m_cbTransferThreshold;
    }

    @Injectable(value="transfer-threshold")
    public void setTransferThreshold(long cbThreshold) {
        this.m_cbTransferThreshold = cbThreshold;
    }

    @Override
    public DefaultCacheServiceProxyDependencies validate() {
        super.validate();
        Base.checkRange(this.getTransferThreshold(), 0L, Integer.MAX_VALUE, "TransferThreshold");
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "{LockEnabled=" + this.isLockEnabled() + ", ReadOnly=" + this.isReadOnly() + ", TransferThreshold=" + this.getTransferThreshold() + "}";
    }
}

